/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.declarations;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.Context;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedEnumConstantDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedEnumDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.logic.MethodResolutionCapability;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.typesystem.LazyType;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.parametrization.ResolvedTypeParametersMap;
import com.github.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import com.github.javaparser.symbolsolver.core.resolution.SymbolResolutionCapability;
import com.github.javaparser.symbolsolver.core.resolution.TypeVariableResolutionCapability;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.AstResolutionUtils;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserEnumConstantDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserFieldDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserMethodDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeAdapter;
import com.github.javaparser.symbolsolver.logic.AbstractTypeDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class JavaParserEnumDeclaration
extends AbstractTypeDeclaration
implements ResolvedEnumDeclaration,
MethodResolutionCapability,
MethodUsageResolutionCapability,
SymbolResolutionCapability {
    private static String JAVA_LANG_ENUM = Enum.class.getCanonicalName();
    private static String JAVA_LANG_COMPARABLE = Comparable.class.getCanonicalName();
    private static String JAVA_IO_SERIALIZABLE = Serializable.class.getCanonicalName();
    private TypeSolver typeSolver;
    private EnumDeclaration wrappedNode;
    private JavaParserTypeAdapter<EnumDeclaration> javaParserTypeAdapter;

    public JavaParserEnumDeclaration(EnumDeclaration wrappedNode, TypeSolver typeSolver) {
        this.wrappedNode = wrappedNode;
        this.typeSolver = typeSolver;
        this.javaParserTypeAdapter = new JavaParserTypeAdapter<EnumDeclaration>(wrappedNode, typeSolver);
    }

    public String toString() {
        return "JavaParserEnumDeclaration{wrappedNode=" + this.wrappedNode + '}';
    }

    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        HashSet<ResolvedMethodDeclaration> methods = new HashSet<ResolvedMethodDeclaration>();
        for (BodyDeclaration member : this.wrappedNode.getMembers()) {
            if (!(member instanceof MethodDeclaration)) continue;
            methods.add(new JavaParserMethodDeclaration((MethodDeclaration)member, this.typeSolver));
        }
        return methods;
    }

    public Context getContext() {
        return JavaParserFactory.getContext((Node)this.wrappedNode, this.typeSolver);
    }

    public String getName() {
        return this.wrappedNode.getName().getId();
    }

    public boolean isField() {
        return false;
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isType() {
        return true;
    }

    public boolean hasDirectlyAnnotation(String canonicalName) {
        return AstResolutionUtils.hasDirectlyAnnotation(this.wrappedNode, this.typeSolver, canonicalName);
    }

    public boolean canBeAssignedTo(ResolvedReferenceTypeDeclaration other) {
        String otherName = other.getQualifiedName();
        if (otherName.equals(this.getQualifiedName())) {
            return true;
        }
        if (otherName.equals(JAVA_LANG_ENUM)) {
            return true;
        }
        if (otherName.equals(JAVA_LANG_COMPARABLE)) {
            return true;
        }
        if (otherName.equals(JAVA_IO_SERIALIZABLE)) {
            return true;
        }
        return other.isJavaLangObject();
    }

    public boolean isClass() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public String getPackageName() {
        return this.javaParserTypeAdapter.getPackageName();
    }

    public String getClassName() {
        return this.javaParserTypeAdapter.getClassName();
    }

    public String getQualifiedName() {
        return this.javaParserTypeAdapter.getQualifiedName();
    }

    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        return this.javaParserTypeAdapter.isAssignableBy(other);
    }

    public boolean isAssignableBy(ResolvedType type) {
        return this.javaParserTypeAdapter.isAssignableBy(type);
    }

    public boolean isTypeParameter() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaParserEnumDeclaration that = (JavaParserEnumDeclaration)o;
        return this.wrappedNode.equals((Object)that.wrappedNode);
    }

    public int hashCode() {
        return this.wrappedNode.hashCode();
    }

    @Override
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentTypes, Context invokationContext, List<ResolvedType> typeParameters) {
        return this.getContext().solveMethodAsUsage(name, argumentTypes);
    }

    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        ResolvedType argument;
        if (name.equals("values") && argumentsTypes.isEmpty()) {
            return SymbolReference.solved((ResolvedDeclaration)new ValuesMethod(this, this.typeSolver));
        }
        if (name.equals("valueOf") && argumentsTypes.size() == 1 && (argument = argumentsTypes.get(0)).isReferenceType() && "java.lang.String".equals(argument.asReferenceType().getQualifiedName())) {
            return SymbolReference.solved((ResolvedDeclaration)new ValueOfMethod(this, this.typeSolver));
        }
        return this.getContext().solveMethod(name, argumentsTypes, staticOnly);
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        return this.getContext().solveSymbol(name);
    }

    public List<ResolvedFieldDeclaration> getAllFields() {
        List<ResolvedFieldDeclaration> fields = this.javaParserTypeAdapter.getFieldsForDeclaredVariables();
        this.getAncestors().forEach(a -> fields.addAll(a.getAllFieldsVisibleToInheritors()));
        this.wrappedNode.getMembers().stream().filter(m -> m instanceof FieldDeclaration).forEach(m -> {
            FieldDeclaration fd = (FieldDeclaration)m;
            fd.getVariables().forEach(v -> fields.add(new JavaParserFieldDeclaration((VariableDeclarator)v, this.typeSolver)));
        });
        return fields;
    }

    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        ArrayList<ResolvedReferenceType> ancestors = new ArrayList<ResolvedReferenceType>();
        ResolvedReferenceType enumClass = ReflectionFactory.typeUsageFor(Enum.class, this.typeSolver).asReferenceType();
        if (enumClass.getTypeDeclaration().isPresent()) {
            ResolvedTypeParameterDeclaration eTypeParameter = (ResolvedTypeParameterDeclaration)((ResolvedReferenceTypeDeclaration)enumClass.getTypeDeclaration().get()).getTypeParameters().get(0);
            enumClass = enumClass.deriveTypeParameters(new ResolvedTypeParametersMap.Builder().setValue(eTypeParameter, (ResolvedType)new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)this)).build());
            ancestors.add(enumClass);
        }
        if (this.wrappedNode.getImplementedTypes() != null) {
            for (ClassOrInterfaceType implementedType : this.wrappedNode.getImplementedTypes()) {
                try {
                    ancestors.add(this.toReferenceType(implementedType));
                }
                catch (UnsolvedSymbolException e) {
                    if (acceptIncompleteList) continue;
                    throw e;
                }
            }
        }
        return ancestors;
    }

    private ResolvedReferenceType toReferenceType(ClassOrInterfaceType classOrInterfaceType) {
        SymbolReference<ResolvedTypeDeclaration> ref;
        String className = classOrInterfaceType.getName().getId();
        if (classOrInterfaceType.getScope().isPresent()) {
            className = ((ClassOrInterfaceType)classOrInterfaceType.getScope().get()).toString() + "." + className;
        }
        if (!(ref = this.solveType(className)).isSolved()) {
            throw new UnsolvedSymbolException(classOrInterfaceType.getName().getId());
        }
        if (!classOrInterfaceType.getTypeArguments().isPresent()) {
            return new ReferenceTypeImpl(((ResolvedTypeDeclaration)ref.getCorrespondingDeclaration()).asReferenceType());
        }
        List superClassTypeParameters = ((NodeList)classOrInterfaceType.getTypeArguments().get()).stream().map(ta -> new LazyType(v -> JavaParserFacade.get(this.typeSolver).convert((Type)ta, (Node)ta))).collect(Collectors.toList());
        return new ReferenceTypeImpl(((ResolvedTypeDeclaration)ref.getCorrespondingDeclaration()).asReferenceType(), superClassTypeParameters);
    }

    @Deprecated
    public SymbolReference<ResolvedTypeDeclaration> solveType(String name) {
        if (this.wrappedNode.getName().getId().equals(name)) {
            return SymbolReference.solved((ResolvedDeclaration)this);
        }
        SymbolReference<ResolvedTypeDeclaration> ref = this.javaParserTypeAdapter.solveType(name);
        if (ref.isSolved()) {
            return ref;
        }
        return ((Context)this.getContext().getParent().orElseThrow(() -> new RuntimeException("Parent context unexpectedly empty."))).solveType(name);
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return Collections.emptyList();
    }

    public EnumDeclaration getWrappedNode() {
        return this.wrappedNode;
    }

    public List<ResolvedEnumConstantDeclaration> getEnumConstants() {
        return this.wrappedNode.getEntries().stream().map(entry -> new JavaParserEnumConstantDeclaration((EnumConstantDeclaration)entry, this.typeSolver)).collect(Collectors.toList());
    }

    public AccessSpecifier accessSpecifier() {
        return this.wrappedNode.getAccessSpecifier();
    }

    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        return this.javaParserTypeAdapter.internalTypes();
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return this.javaParserTypeAdapter.containerType();
    }

    public List<ResolvedConstructorDeclaration> getConstructors() {
        return AstResolutionUtils.getConstructors(this.wrappedNode, this.typeSolver, this);
    }

    public Optional<Node> toAst() {
        return Optional.of(this.wrappedNode);
    }

    public static class ValueOfMethod
    implements ResolvedMethodDeclaration,
    TypeVariableResolutionCapability {
        private JavaParserEnumDeclaration enumDeclaration;
        private TypeSolver typeSolver;

        public ValueOfMethod(JavaParserEnumDeclaration enumDeclaration, TypeSolver typeSolver) {
            this.enumDeclaration = enumDeclaration;
            this.typeSolver = typeSolver;
        }

        public ResolvedReferenceTypeDeclaration declaringType() {
            return this.enumDeclaration;
        }

        public ResolvedType getReturnType() {
            return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)this.enumDeclaration);
        }

        public int getNumberOfParams() {
            return 1;
        }

        public ResolvedParameterDeclaration getParam(int i) {
            if (i == 0) {
                return new ResolvedParameterDeclaration(){

                    public String getName() {
                        return "name";
                    }

                    public ResolvedType getType() {
                        return new ReferenceTypeImpl(typeSolver.solveType("java.lang.String"));
                    }

                    public boolean isVariadic() {
                        return false;
                    }

                    public Optional<Node> toAst() {
                        return enumDeclaration.toAst();
                    }
                };
            }
            throw new IllegalArgumentException("Invalid parameter index!");
        }

        public MethodUsage getUsage(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MethodUsage resolveTypeVariables(Context context, List<ResolvedType> parameterTypes) {
            return new MethodUsage((ResolvedMethodDeclaration)this);
        }

        public boolean isAbstract() {
            return false;
        }

        public boolean isDefaultMethod() {
            return false;
        }

        public boolean isStatic() {
            return true;
        }

        public String getName() {
            return "valueOf";
        }

        public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
            return Collections.emptyList();
        }

        public AccessSpecifier accessSpecifier() {
            return AccessSpecifier.PUBLIC;
        }

        public int getNumberOfSpecifiedExceptions() {
            return 0;
        }

        public ResolvedType getSpecifiedException(int index) {
            throw new UnsupportedOperationException("The valueOf method of an enum does not throw any exception");
        }

        public Optional<Node> toAst() {
            return this.enumDeclaration.toAst();
        }

        public String toDescriptor() {
            return String.format("(Ljava/lang/String;)%s", this.getReturnType().toDescriptor());
        }
    }

    public static class ValuesMethod
    implements ResolvedMethodDeclaration,
    TypeVariableResolutionCapability {
        private JavaParserEnumDeclaration enumDeclaration;
        private TypeSolver typeSolver;

        public ValuesMethod(JavaParserEnumDeclaration enumDeclaration, TypeSolver typeSolver) {
            this.enumDeclaration = enumDeclaration;
            this.typeSolver = typeSolver;
        }

        public ResolvedReferenceTypeDeclaration declaringType() {
            return this.enumDeclaration;
        }

        public ResolvedType getReturnType() {
            return new ResolvedArrayType((ResolvedType)new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)this.enumDeclaration));
        }

        public int getNumberOfParams() {
            return 0;
        }

        public ResolvedParameterDeclaration getParam(int i) {
            throw new UnsupportedOperationException();
        }

        public MethodUsage getUsage(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MethodUsage resolveTypeVariables(Context context, List<ResolvedType> parameterTypes) {
            return new MethodUsage((ResolvedMethodDeclaration)this);
        }

        public boolean isAbstract() {
            throw new UnsupportedOperationException();
        }

        public boolean isDefaultMethod() {
            return false;
        }

        public boolean isStatic() {
            return false;
        }

        public String getName() {
            return "values";
        }

        public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
            return Collections.emptyList();
        }

        public AccessSpecifier accessSpecifier() {
            return this.enumDeclaration.getWrappedNode().getAccessSpecifier();
        }

        public int getNumberOfSpecifiedExceptions() {
            return 0;
        }

        public ResolvedType getSpecifiedException(int index) {
            throw new UnsupportedOperationException("The values method of an enum does not throw any exception");
        }

        public Optional<Node> toAst() {
            return this.enumDeclaration.toAst();
        }

        public String toDescriptor() {
            return String.format("()%s", this.getReturnType().toDescriptor());
        }
    }
}

