/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.Navigator;
import com.github.javaparser.resolution.SymbolDeclarator;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.logic.FunctionalInterfaceLogic;
import com.github.javaparser.resolution.logic.InferenceContext;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.Value;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedLambdaConstraintType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.AbstractJavaParserContext;
import com.github.javaparser.utils.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class LambdaExprContext
extends AbstractJavaParserContext<LambdaExpr> {
    private static final Predicate<Node> IS_NOT_ENCLOSED_EXPR = n -> !(n instanceof EnclosedExpr);

    public LambdaExprContext(LambdaExpr wrappedNode, TypeSolver typeSolver) {
        super(wrappedNode, typeSolver);
    }

    public Optional<Value> solveSymbolAsValue(String name) {
        int index = -1;
        for (Parameter parameter : ((LambdaExpr)this.wrappedNode).getParameters()) {
            ++index;
            SymbolDeclarator sb = JavaParserFactory.getSymbolDeclarator((Node)parameter, this.typeSolver);
            for (ResolvedValueDeclaration decl : sb.getSymbolDeclarations()) {
                ResolvedType t;
                if (!decl.getName().equals(name)) continue;
                Node parentNode = Navigator.demandParentNode((Node)this.wrappedNode, IS_NOT_ENCLOSED_EXPR);
                if (parentNode instanceof MethodCallExpr) {
                    MethodCallExpr methodCallExpr = (MethodCallExpr)parentNode;
                    MethodUsage methodUsage = JavaParserFacade.get(this.typeSolver).solveMethodAsUsage(methodCallExpr);
                    int i = this.pos(methodCallExpr, (Expression)this.wrappedNode);
                    ResolvedType lambdaType = (ResolvedType)methodUsage.getParamTypes().get(i);
                    Optional functionalMethodOpt = FunctionalInterfaceLogic.getFunctionalMethod((ResolvedType)lambdaType);
                    if (functionalMethodOpt.isPresent()) {
                        int lambdaParamIndex;
                        MethodUsage functionalMethod = (MethodUsage)functionalMethodOpt.get();
                        InferenceContext inferenceContext = new InferenceContext(this.typeSolver);
                        lambdaType.asReferenceType().getTypeDeclaration().ifPresent(typeDeclaration -> inferenceContext.addPair(lambdaType, (ResolvedType)new ReferenceTypeImpl(typeDeclaration)));
                        boolean found = false;
                        for (lambdaParamIndex = 0; lambdaParamIndex < ((LambdaExpr)this.wrappedNode).getParameters().size(); ++lambdaParamIndex) {
                            if (!((LambdaExpr)this.wrappedNode).getParameter(lambdaParamIndex).getName().getIdentifier().equals(name)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            return Optional.empty();
                        }
                        ResolvedType argType = inferenceContext.resolve(inferenceContext.addSingle(functionalMethod.getParamType(lambdaParamIndex)));
                        ResolvedLambdaConstraintType conType = argType.isWildcard() ? ResolvedLambdaConstraintType.bound((ResolvedType)argType.asWildcard().getBoundedType()) : ResolvedLambdaConstraintType.bound((ResolvedType)argType);
                        Value value = new Value((ResolvedType)conType, name);
                        return Optional.of(value);
                    }
                    return Optional.empty();
                }
                if (parentNode instanceof VariableDeclarator) {
                    VariableDeclarator variableDeclarator = (VariableDeclarator)parentNode;
                    t = JavaParserFacade.get(this.typeSolver).convertToUsage(variableDeclarator.getType());
                    Optional functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod((ResolvedType)t);
                    if (functionalMethod.isPresent()) {
                        ResolvedType lambdaType = ((MethodUsage)functionalMethod.get()).getParamType(index);
                        HashMap inferredTypes = new HashMap();
                        if (lambdaType.isReferenceType()) {
                            for (Pair entry : lambdaType.asReferenceType().getTypeParametersMap()) {
                                if (!((ResolvedType)entry.b).isTypeVariable() || !((ResolvedType)entry.b).asTypeParameter().declaredOnType()) continue;
                                ResolvedType ot = t.asReferenceType().typeParametersMap().getValue((ResolvedTypeParameterDeclaration)entry.a);
                                lambdaType = lambdaType.replaceTypeVariables((ResolvedTypeParameterDeclaration)entry.a, ot, inferredTypes);
                            }
                        } else if (lambdaType.isTypeVariable() && lambdaType.asTypeParameter().declaredOnType()) {
                            lambdaType = t.asReferenceType().typeParametersMap().getValue(lambdaType.asTypeParameter());
                        }
                        Value value = new Value(lambdaType, name);
                        return Optional.of(value);
                    }
                    throw new UnsupportedOperationException();
                }
                if (parentNode instanceof ReturnStmt) {
                    ReturnStmt returnStmt = (ReturnStmt)parentNode;
                    Optional optDeclaration = returnStmt.findAncestor(new Class[]{MethodDeclaration.class});
                    if (!optDeclaration.isPresent()) continue;
                    ResolvedType t2 = JavaParserFacade.get(this.typeSolver).convertToUsage(((MethodDeclaration)optDeclaration.get()).asMethodDeclaration().getType());
                    Optional functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod((ResolvedType)t2);
                    if (functionalMethod.isPresent()) {
                        ResolvedType lambdaType = ((MethodUsage)functionalMethod.get()).getParamType(index);
                        HashMap inferredTypes = new HashMap();
                        if (lambdaType.isReferenceType()) {
                            for (Pair entry : lambdaType.asReferenceType().getTypeParametersMap()) {
                                if (!((ResolvedType)entry.b).isTypeVariable() || !((ResolvedType)entry.b).asTypeParameter().declaredOnType()) continue;
                                ResolvedType ot = t2.asReferenceType().typeParametersMap().getValue((ResolvedTypeParameterDeclaration)entry.a);
                                lambdaType = lambdaType.replaceTypeVariables((ResolvedTypeParameterDeclaration)entry.a, ot, inferredTypes);
                            }
                        } else if (lambdaType.isTypeVariable() && lambdaType.asTypeParameter().declaredOnType()) {
                            lambdaType = t2.asReferenceType().typeParametersMap().getValue(lambdaType.asTypeParameter());
                        }
                        Value value = new Value(lambdaType, name);
                        return Optional.of(value);
                    }
                    throw new UnsupportedOperationException();
                }
                if (parentNode instanceof CastExpr) {
                    CastExpr castExpr = (CastExpr)parentNode;
                    t = JavaParserFacade.get(this.typeSolver).convertToUsage(castExpr.getType());
                    Optional functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod((ResolvedType)t);
                    if (functionalMethod.isPresent()) {
                        ResolvedType lambdaType = ((MethodUsage)functionalMethod.get()).getParamType(index);
                        HashMap inferredTypes = new HashMap();
                        if (lambdaType.isReferenceType()) {
                            for (Pair entry : lambdaType.asReferenceType().getTypeParametersMap()) {
                                if (!((ResolvedType)entry.b).isTypeVariable() || !((ResolvedType)entry.b).asTypeParameter().declaredOnType()) continue;
                                ResolvedType ot = t.asReferenceType().typeParametersMap().getValue((ResolvedTypeParameterDeclaration)entry.a);
                                lambdaType = lambdaType.replaceTypeVariables((ResolvedTypeParameterDeclaration)entry.a, ot, inferredTypes);
                            }
                        } else if (lambdaType.isTypeVariable() && lambdaType.asTypeParameter().declaredOnType()) {
                            lambdaType = t.asReferenceType().typeParametersMap().getValue(lambdaType.asTypeParameter());
                        }
                        Value value = new Value(lambdaType, name);
                        return Optional.of(value);
                    }
                    throw new UnsupportedOperationException();
                }
                throw new UnsupportedOperationException();
            }
        }
        return this.solveSymbolAsValueInParentContext(name);
    }

    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name) {
        for (Parameter parameter : ((LambdaExpr)this.wrappedNode).getParameters()) {
            SymbolDeclarator sb = JavaParserFactory.getSymbolDeclarator((Node)parameter, this.typeSolver);
            SymbolReference<ResolvedValueDeclaration> symbolReference = LambdaExprContext.solveWith(sb, name);
            if (!symbolReference.isSolved()) continue;
            return symbolReference;
        }
        return this.solveSymbolInParentContext(name);
    }

    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        return this.solveMethodInParentContext(name, argumentsTypes, false);
    }

    public List<Parameter> parametersExposedToChild(Node child) {
        if (child == ((LambdaExpr)this.wrappedNode).getBody()) {
            return ((LambdaExpr)this.wrappedNode).getParameters();
        }
        return Collections.emptyList();
    }

    @Override
    protected final Optional<Value> solveWithAsValue(SymbolDeclarator symbolDeclarator, String name) {
        for (ResolvedValueDeclaration decl : symbolDeclarator.getSymbolDeclarations()) {
            if (!decl.getName().equals(name)) continue;
            throw new UnsupportedOperationException();
        }
        return Optional.empty();
    }

    private int pos(MethodCallExpr callExpr, Expression param) {
        int i = 0;
        for (Expression p : callExpr.getArguments()) {
            while (p instanceof EnclosedExpr) {
                p = ((EnclosedExpr)p).getInner();
            }
            if (p == param) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }
}

