/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.DataKey;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.resolution.Context;
import com.github.javaparser.resolution.MethodAmbiguityException;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.Navigator;
import com.github.javaparser.resolution.Solver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedAnnotationDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedClassDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.logic.ConstructorResolutionLogic;
import com.github.javaparser.resolution.logic.MethodResolutionLogic;
import com.github.javaparser.resolution.model.LambdaArgumentTypePlaceholder;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.FailureHandler;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.TypeExtractor;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.FieldAccessContext;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserAnonymousClassDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserEnumDeclaration;
import com.github.javaparser.symbolsolver.resolution.SymbolSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.github.javaparser.utils.Log;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class JavaParserFacade {
    private static final DataKey<ResolvedType> TYPE_WITH_LAMBDAS_RESOLVED = new DataKey<ResolvedType>(){};
    private static final DataKey<ResolvedType> TYPE_WITHOUT_LAMBDAS_RESOLVED = new DataKey<ResolvedType>(){};
    private static final Map<TypeSolver, JavaParserFacade> instances = new WeakHashMap<TypeSolver, JavaParserFacade>();
    private static final String JAVA_LANG_STRING = String.class.getCanonicalName();
    private final TypeSolver typeSolver;
    private final TypeExtractor typeExtractor;
    private final Solver symbolSolver;
    private FailureHandler failureHandler;

    public static synchronized JavaParserFacade get(TypeSolver typeSolver) {
        return instances.computeIfAbsent(typeSolver, JavaParserFacade::new);
    }

    public static void clearInstances() {
        instances.clear();
    }

    private JavaParserFacade(TypeSolver typeSolver) {
        this.typeSolver = typeSolver.getRoot();
        this.symbolSolver = new SymbolSolver(typeSolver);
        this.typeExtractor = new TypeExtractor(this.typeSolver, this);
        this.failureHandler = new FailureHandler();
    }

    public TypeSolver getTypeSolver() {
        return this.typeSolver;
    }

    public Solver getSymbolSolver() {
        return this.symbolSolver;
    }

    public SymbolReference<? extends ResolvedValueDeclaration> solve(NameExpr nameExpr) {
        return this.symbolSolver.solveSymbol(nameExpr.getName().getId(), (Node)nameExpr);
    }

    public SymbolReference<? extends ResolvedValueDeclaration> solve(SimpleName nameExpr) {
        return this.symbolSolver.solveSymbol(nameExpr.getId(), (Node)nameExpr);
    }

    public SymbolReference<? extends ResolvedValueDeclaration> solve(Expression expr) {
        return expr.toNameExpr().map(this::solve).orElseThrow(() -> new IllegalArgumentException(expr.getClass().getCanonicalName()));
    }

    public SymbolReference<ResolvedMethodDeclaration> solve(MethodCallExpr methodCallExpr) {
        return this.solve(methodCallExpr, true);
    }

    public SymbolReference<ResolvedMethodDeclaration> solve(MethodReferenceExpr methodReferenceExpr) {
        return this.solve(methodReferenceExpr, true);
    }

    public SymbolReference<ResolvedConstructorDeclaration> solve(ObjectCreationExpr objectCreationExpr) {
        return this.solve(objectCreationExpr, true);
    }

    public SymbolReference<ResolvedConstructorDeclaration> solve(ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt) {
        return this.solve(explicitConstructorInvocationStmt, true);
    }

    public SymbolReference<ResolvedConstructorDeclaration> solve(ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt, boolean solveLambdas) {
        Optional optAncestorClassOrInterfaceNode = explicitConstructorInvocationStmt.findAncestor(new Class[]{ClassOrInterfaceDeclaration.class});
        if (!optAncestorClassOrInterfaceNode.isPresent()) {
            return SymbolReference.unsolved();
        }
        ClassOrInterfaceDeclaration classOrInterfaceNode = (ClassOrInterfaceDeclaration)optAncestorClassOrInterfaceNode.get();
        ResolvedReferenceTypeDeclaration resolvedClassNode = classOrInterfaceNode.resolve();
        if (!resolvedClassNode.isClass()) {
            throw new IllegalStateException("Expected to be a class -- cannot call this() or super() within an interface.");
        }
        ResolvedReferenceTypeDeclaration typeDecl = null;
        if (explicitConstructorInvocationStmt.isThis()) {
            typeDecl = resolvedClassNode.asReferenceType();
        } else {
            Optional superClass = resolvedClassNode.asClass().getSuperClass();
            if (superClass.isPresent() && ((ResolvedReferenceType)superClass.get()).getTypeDeclaration().isPresent()) {
                typeDecl = (ResolvedTypeDeclaration)((ResolvedReferenceType)superClass.get()).getTypeDeclaration().get();
            }
        }
        if (typeDecl == null) {
            return SymbolReference.unsolved();
        }
        LinkedList<ResolvedType> argumentTypes = new LinkedList<ResolvedType>();
        LinkedList<LambdaArgumentTypePlaceholder> placeholders = new LinkedList<LambdaArgumentTypePlaceholder>();
        this.solveArguments((Node)explicitConstructorInvocationStmt, (NodeList<Expression>)explicitConstructorInvocationStmt.getArguments(), solveLambdas, argumentTypes, placeholders);
        SymbolReference res = ConstructorResolutionLogic.findMostApplicable((List)((ResolvedClassDeclaration)typeDecl).getConstructors(), argumentTypes, (TypeSolver)this.typeSolver);
        for (LambdaArgumentTypePlaceholder placeholder : placeholders) {
            placeholder.setMethod(res);
        }
        return res;
    }

    public SymbolReference<ResolvedTypeDeclaration> solve(ThisExpr node) {
        if (node.getTypeName().isPresent()) {
            Optional classByName;
            String className = ((Name)node.getTypeName().get()).asString();
            SymbolReference clazz = this.typeSolver.tryToSolveType(className);
            if (clazz.isSolved()) {
                return SymbolReference.solved((ResolvedDeclaration)clazz.getCorrespondingDeclaration());
            }
            Optional cu = node.findAncestor(new Class[]{CompilationUnit.class});
            if (cu.isPresent() && (classByName = ((CompilationUnit)cu.get()).getClassByName(className)).isPresent()) {
                return SymbolReference.solved((ResolvedDeclaration)this.getTypeDeclaration((ClassOrInterfaceDeclaration)classByName.get()));
            }
        }
        return SymbolReference.solved((ResolvedDeclaration)this.getTypeDeclaration(this.findContainingTypeDeclOrObjectCreationExpr((Node)node)));
    }

    public SymbolReference<ResolvedConstructorDeclaration> solve(ObjectCreationExpr objectCreationExpr, boolean solveLambdas) {
        LinkedList<ResolvedType> argumentTypes = new LinkedList<ResolvedType>();
        LinkedList<LambdaArgumentTypePlaceholder> placeholders = new LinkedList<LambdaArgumentTypePlaceholder>();
        this.solveArguments((Node)objectCreationExpr, (NodeList<Expression>)objectCreationExpr.getArguments(), solveLambdas, argumentTypes, placeholders);
        JavaParserAnonymousClassDeclaration typeDecl = null;
        if (objectCreationExpr.getAnonymousClassBody().isPresent()) {
            typeDecl = new JavaParserAnonymousClassDeclaration(objectCreationExpr, this.typeSolver);
        } else {
            ResolvedType classDecl = JavaParserFacade.get(this.typeSolver).convert((Type)objectCreationExpr.getType(), (Node)objectCreationExpr);
            if (classDecl.isReferenceType() && classDecl.asReferenceType().getTypeDeclaration().isPresent()) {
                typeDecl = (ResolvedReferenceTypeDeclaration)classDecl.asReferenceType().getTypeDeclaration().get();
            }
        }
        if (typeDecl == null) {
            return SymbolReference.unsolved();
        }
        SymbolReference res = ConstructorResolutionLogic.findMostApplicable((List)typeDecl.getConstructors(), argumentTypes, (TypeSolver)this.typeSolver);
        for (LambdaArgumentTypePlaceholder placeholder : placeholders) {
            placeholder.setMethod(res);
        }
        return res;
    }

    private void solveArguments(Node node, NodeList<Expression> args, boolean solveLambdas, List<ResolvedType> argumentTypes, List<LambdaArgumentTypePlaceholder> placeholders) {
        int i = 0;
        for (Expression parameterValue : args) {
            if (parameterValue.isLambdaExpr() || parameterValue.isMethodReferenceExpr()) {
                LambdaArgumentTypePlaceholder placeholder = new LambdaArgumentTypePlaceholder(i);
                argumentTypes.add((ResolvedType)placeholder);
                placeholders.add(placeholder);
            } else {
                try {
                    argumentTypes.add(JavaParserFacade.get(this.typeSolver).getType((Node)parameterValue, solveLambdas));
                }
                catch (Exception e) {
                    throw this.failureHandler.handle(e, String.format("Unable to calculate the type of a parameter of a method call. Method call: %s, Parameter: %s", node, parameterValue));
                }
            }
            ++i;
        }
    }

    public SymbolReference<ResolvedMethodDeclaration> solve(MethodCallExpr methodCallExpr, boolean solveLambdas) {
        LinkedList<ResolvedType> argumentTypes = new LinkedList<ResolvedType>();
        LinkedList<LambdaArgumentTypePlaceholder> placeholders = new LinkedList<LambdaArgumentTypePlaceholder>();
        this.solveArguments((Node)methodCallExpr, (NodeList<Expression>)methodCallExpr.getArguments(), solveLambdas, argumentTypes, placeholders);
        SymbolReference res = JavaParserFactory.getContext((Node)methodCallExpr, this.typeSolver).solveMethod(methodCallExpr.getName().getId(), argumentTypes, false);
        for (LambdaArgumentTypePlaceholder placeholder : placeholders) {
            placeholder.setMethod(res);
        }
        return res;
    }

    public SymbolReference<ResolvedMethodDeclaration> solve(MethodReferenceExpr methodReferenceExpr, boolean solveLambdas) {
        LinkedList argumentTypes = new LinkedList();
        return JavaParserFactory.getContext((Node)methodReferenceExpr, this.typeSolver).solveMethod(methodReferenceExpr.getIdentifier(), argumentTypes, false);
    }

    public SymbolReference<ResolvedAnnotationDeclaration> solve(AnnotationExpr annotationExpr) {
        Context context = JavaParserFactory.getContext((Node)annotationExpr, this.typeSolver);
        SymbolReference typeDeclarationSymbolReference = context.solveType(annotationExpr.getNameAsString());
        if (typeDeclarationSymbolReference.isSolved()) {
            ResolvedAnnotationDeclaration annotationDeclaration = (ResolvedAnnotationDeclaration)typeDeclarationSymbolReference.getCorrespondingDeclaration();
            return SymbolReference.solved((ResolvedDeclaration)annotationDeclaration);
        }
        return SymbolReference.unsolved();
    }

    public SymbolReference<ResolvedValueDeclaration> solve(FieldAccessExpr fieldAccessExpr) {
        return ((FieldAccessContext)JavaParserFactory.getContext((Node)fieldAccessExpr, this.typeSolver)).solveField(fieldAccessExpr.getName().getId());
    }

    public ResolvedType getType(Node node) {
        try {
            return this.getType(node, true);
        }
        catch (UnsolvedSymbolException e) {
            if (node instanceof NameExpr) {
                NameExpr nameExpr = (NameExpr)node;
                SymbolReference typeDeclaration = JavaParserFactory.getContext(node, this.typeSolver).solveType(nameExpr.getNameAsString());
                if (typeDeclaration.isSolved() && typeDeclaration.getCorrespondingDeclaration() instanceof ResolvedReferenceTypeDeclaration) {
                    ResolvedReferenceTypeDeclaration resolvedReferenceTypeDeclaration = (ResolvedReferenceTypeDeclaration)typeDeclaration.getCorrespondingDeclaration();
                    return ReferenceTypeImpl.undeterminedParameters((ResolvedReferenceTypeDeclaration)resolvedReferenceTypeDeclaration);
                }
            }
            throw this.failureHandler.handle(e);
        }
    }

    public ResolvedType getType(Node node, boolean solveLambdas) {
        if (solveLambdas) {
            if (!node.containsData(TYPE_WITH_LAMBDAS_RESOLVED)) {
                ResolvedType res = this.getTypeConcrete(node, solveLambdas);
                node.setData(TYPE_WITH_LAMBDAS_RESOLVED, (Object)res);
                boolean secondPassNecessary = false;
                if (node instanceof MethodCallExpr) {
                    MethodCallExpr methodCallExpr = (MethodCallExpr)node;
                    for (Node arg : methodCallExpr.getArguments()) {
                        if (arg.containsData(TYPE_WITH_LAMBDAS_RESOLVED)) continue;
                        this.getType(arg, true);
                        secondPassNecessary = true;
                    }
                }
                if (secondPassNecessary) {
                    node.removeData(TYPE_WITH_LAMBDAS_RESOLVED);
                    ResolvedType type = this.getType(node, true);
                    node.setData(TYPE_WITH_LAMBDAS_RESOLVED, (Object)type);
                }
                Log.trace((String)"getType on %s  -> %s", (Supplier[])new Supplier[]{() -> node, () -> res});
            }
            return (ResolvedType)node.getData(TYPE_WITH_LAMBDAS_RESOLVED);
        }
        Optional<ResolvedType> res = this.find(TYPE_WITH_LAMBDAS_RESOLVED, node);
        if (res.isPresent()) {
            return res.get();
        }
        res = this.find(TYPE_WITHOUT_LAMBDAS_RESOLVED, node);
        if (!res.isPresent()) {
            ResolvedType resType = this.getTypeConcrete(node, solveLambdas);
            node.setData(TYPE_WITHOUT_LAMBDAS_RESOLVED, (Object)resType);
            Optional<ResolvedType> finalRes = res;
            Log.trace((String)"getType on %s (no solveLambdas) -> %s", (Supplier[])new Supplier[]{() -> node, () -> finalRes});
            return resType;
        }
        return res.get();
    }

    private Optional<ResolvedType> find(DataKey<ResolvedType> dataKey, Node node) {
        if (node.containsData(dataKey)) {
            return Optional.of(node.getData(dataKey));
        }
        return Optional.empty();
    }

    protected MethodUsage toMethodUsage(MethodReferenceExpr methodReferenceExpr, List<ResolvedType> paramTypes) {
        Optional result;
        Expression scope = methodReferenceExpr.getScope();
        ResolvedType typeOfScope = this.getType((Node)methodReferenceExpr.getScope());
        if (!typeOfScope.isReferenceType()) {
            throw new UnsupportedOperationException(typeOfScope.getClass().getCanonicalName());
        }
        Set allMethods = ((ResolvedReferenceTypeDeclaration)typeOfScope.asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty."))).getAllMethods();
        if (scope.isTypeExpr()) {
            List staticMethodUsages = allMethods.stream().filter(it -> it.getDeclaration().isStatic()).collect(Collectors.toList());
            result = MethodResolutionLogic.findMostApplicableUsage(staticMethodUsages, (String)methodReferenceExpr.getIdentifier(), paramTypes, (TypeSolver)this.typeSolver);
            if (!paramTypes.isEmpty()) {
                List instanceMethodUsages = allMethods.stream().filter(it -> !it.getDeclaration().isStatic()).collect(Collectors.toList());
                ArrayList<ResolvedType> instanceMethodParamTypes = new ArrayList<ResolvedType>(paramTypes);
                instanceMethodParamTypes.remove(0);
                Optional instanceResult = MethodResolutionLogic.findMostApplicableUsage(instanceMethodUsages, (String)methodReferenceExpr.getIdentifier(), instanceMethodParamTypes, (TypeSolver)this.typeSolver);
                if (result.isPresent() && instanceResult.isPresent()) {
                    throw new MethodAmbiguityException("Ambiguous method call: cannot find a most applicable method for " + methodReferenceExpr.getIdentifier());
                }
                if (instanceResult.isPresent()) {
                    result = instanceResult;
                }
            }
        } else {
            result = MethodResolutionLogic.findMostApplicableUsage(new ArrayList(allMethods), (String)methodReferenceExpr.getIdentifier(), paramTypes, (TypeSolver)this.typeSolver);
            if (result.isPresent() && ((MethodUsage)result.get()).getDeclaration().isStatic()) {
                throw new RuntimeException("Invalid static method reference " + methodReferenceExpr.getIdentifier());
            }
        }
        if (!result.isPresent()) {
            throw new UnsupportedOperationException();
        }
        return (MethodUsage)result.get();
    }

    protected ResolvedType getBinaryTypeConcrete(Node left, Node right, boolean solveLambdas, BinaryExpr.Operator operator) {
        boolean isRightNumeric;
        ResolvedType leftType = this.getTypeConcrete(left, solveLambdas);
        ResolvedType rightType = this.getTypeConcrete(right, solveLambdas);
        if (operator == BinaryExpr.Operator.PLUS) {
            boolean isRightString;
            boolean isLeftString = leftType.isReferenceType() && leftType.asReferenceType().getQualifiedName().equals(JAVA_LANG_STRING);
            boolean bl = isRightString = rightType.isReferenceType() && rightType.asReferenceType().getQualifiedName().equals(JAVA_LANG_STRING);
            if (isLeftString || isRightString) {
                return isLeftString ? leftType : rightType;
            }
        }
        boolean isLeftNumeric = leftType.isPrimitive() && leftType.asPrimitive().isNumeric();
        boolean bl = isRightNumeric = rightType.isPrimitive() && rightType.asPrimitive().isNumeric();
        if (isLeftNumeric && isRightNumeric) {
            return leftType.asPrimitive().bnp(rightType.asPrimitive());
        }
        if (rightType.isAssignableBy(leftType)) {
            return rightType;
        }
        return leftType;
    }

    private ResolvedType getTypeConcrete(Node node, boolean solveLambdas) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        return (ResolvedType)node.accept((GenericVisitor)this.typeExtractor, (Object)solveLambdas);
    }

    protected TypeDeclaration<?> findContainingTypeDecl(Node node) {
        Node parent = node;
        while (!((parent = Navigator.demandParentNode((Node)parent)) instanceof TypeDeclaration)) {
        }
        return (TypeDeclaration)parent;
    }

    protected Node findContainingTypeDeclOrObjectCreationExpr(Node node) {
        Node parent = node;
        boolean detachFlag = false;
        while (true) {
            if ((parent = Navigator.demandParentNode((Node)parent)) instanceof BodyDeclaration) {
                if (parent instanceof TypeDeclaration) {
                    return parent;
                }
                detachFlag = true;
                continue;
            }
            if (parent instanceof ObjectCreationExpr && detachFlag) break;
        }
        return parent;
    }

    protected Node findContainingTypeDeclOrObjectCreationExpr(Node node, String className) {
        Node parent = node;
        boolean detachFlag = false;
        while (true) {
            if ((parent = Navigator.demandParentNode((Node)parent)) instanceof BodyDeclaration) {
                if (parent instanceof TypeDeclaration && ((String)((TypeDeclaration)parent).getFullyQualifiedName().get()).endsWith(className)) {
                    return parent;
                }
                detachFlag = true;
                continue;
            }
            if (parent instanceof ObjectCreationExpr && ((ObjectCreationExpr)parent).getType().getName().asString().equals(className) && detachFlag) break;
        }
        return parent;
    }

    protected ResolvedType convertToUsage(Type type, Context context) {
        if (context == null) {
            throw new NullPointerException("Context should not be null");
        }
        return type.convertToUsage(context);
    }

    public ResolvedType convertToUsage(Type type) {
        return this.convertToUsage(type, JavaParserFactory.getContext((Node)type, this.typeSolver));
    }

    private Optional<ForEachStmt> forEachStmtWithVariableDeclarator(VariableDeclarator variableDeclarator) {
        Optional node = variableDeclarator.getParentNode();
        if (!node.isPresent() || !(node.get() instanceof VariableDeclarationExpr)) {
            return Optional.empty();
        }
        if (!(node = ((Node)node.get()).getParentNode()).isPresent() || !(node.get() instanceof ForEachStmt)) {
            return Optional.empty();
        }
        return Optional.of((ForEachStmt)node.get());
    }

    public ResolvedType convert(Type type, Node node) {
        return this.convert(type, JavaParserFactory.getContext(node, this.typeSolver));
    }

    public ResolvedType convert(Type type, Context context) {
        return this.convertToUsage(type, context);
    }

    public MethodUsage solveMethodAsUsage(MethodCallExpr call) {
        Context context;
        Optional methodUsage;
        ArrayList<ResolvedType> params = new ArrayList<ResolvedType>();
        if (call.getArguments() != null) {
            for (Expression param : call.getArguments()) {
                try {
                    params.add(this.getType((Node)param, false));
                }
                catch (Exception e) {
                    throw this.failureHandler.handle(e, String.format("Error calculating the type of parameter %s of method call %s", param, call));
                }
            }
        }
        if (!(methodUsage = (context = JavaParserFactory.getContext((Node)call, this.typeSolver)).solveMethodAsUsage(call.getName().getId(), params)).isPresent()) {
            throw new RuntimeException("Method '" + call.getName() + "' cannot be resolved in context " + call + " (line: " + call.getRange().map(r -> "" + r.begin.line).orElse("??") + ") " + context + ". Parameter types: " + params);
        }
        return (MethodUsage)methodUsage.get();
    }

    public ResolvedReferenceTypeDeclaration getTypeDeclaration(Node node) {
        if (node instanceof TypeDeclaration) {
            return this.getTypeDeclaration((TypeDeclaration)node);
        }
        if (node instanceof ObjectCreationExpr) {
            return new JavaParserAnonymousClassDeclaration((ObjectCreationExpr)node, this.typeSolver);
        }
        throw new IllegalArgumentException();
    }

    public ResolvedReferenceTypeDeclaration getTypeDeclaration(ClassOrInterfaceDeclaration classOrInterfaceDeclaration) {
        return JavaParserFactory.toTypeDeclaration((Node)classOrInterfaceDeclaration, this.typeSolver);
    }

    public ResolvedType getTypeOfThisIn(Node node) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            return new ReferenceTypeImpl(this.getTypeDeclaration((ClassOrInterfaceDeclaration)node));
        }
        if (node instanceof EnumDeclaration) {
            JavaParserEnumDeclaration enumDeclaration = new JavaParserEnumDeclaration((EnumDeclaration)node, this.typeSolver);
            return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)enumDeclaration);
        }
        if (node instanceof ObjectCreationExpr && ((ObjectCreationExpr)node).getAnonymousClassBody().isPresent()) {
            JavaParserAnonymousClassDeclaration anonymousDeclaration = new JavaParserAnonymousClassDeclaration((ObjectCreationExpr)node, this.typeSolver);
            return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)anonymousDeclaration);
        }
        return this.getTypeOfThisIn(Navigator.demandParentNode((Node)node));
    }

    public ResolvedReferenceTypeDeclaration getTypeDeclaration(TypeDeclaration<?> typeDeclaration) {
        return JavaParserFactory.toTypeDeclaration(typeDeclaration, this.typeSolver);
    }

    @Deprecated
    public ResolvedType classToResolvedType(Class<?> clazz) {
        SymbolSolver symbolSolver = new SymbolSolver(new ReflectionTypeSolver());
        return symbolSolver.classToResolvedType(clazz);
    }
}

