/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typesolvers;

import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.symbolsolver.cache.Cache;
import com.github.javaparser.symbolsolver.cache.NoCache;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CombinedTypeSolver
implements TypeSolver {
    private final Cache<String, SymbolReference<ResolvedReferenceTypeDeclaration>> typeCache;
    private TypeSolver parent;
    private List<TypeSolver> elements = new ArrayList<TypeSolver>();
    private Predicate<Exception> exceptionHandler;

    public CombinedTypeSolver(TypeSolver ... elements) {
        this(Arrays.asList(elements));
    }

    public CombinedTypeSolver(Predicate<Exception> exceptionHandler, TypeSolver ... elements) {
        this(exceptionHandler, Arrays.asList(elements));
    }

    public CombinedTypeSolver(Iterable<TypeSolver> elements) {
        this(ExceptionHandlers.IGNORE_NONE, elements);
    }

    public CombinedTypeSolver(Predicate<Exception> exceptionHandler, Iterable<TypeSolver> elements) {
        this(exceptionHandler, elements, NoCache.create());
    }

    public CombinedTypeSolver(Predicate<Exception> exceptionHandler, Iterable<TypeSolver> elements, Cache<String, SymbolReference<ResolvedReferenceTypeDeclaration>> typeCache) {
        Objects.requireNonNull(typeCache, "The typeCache can't be null.");
        this.setExceptionHandler(exceptionHandler);
        this.typeCache = typeCache;
        for (TypeSolver el : elements) {
            this.add(el, false);
        }
    }

    public void setExceptionHandler(Predicate<Exception> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public TypeSolver getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TypeSolver parent) {
        Objects.requireNonNull(parent);
        if (this.parent != null) {
            throw new IllegalStateException("This TypeSolver already has a parent.");
        }
        if (parent == this) {
            throw new IllegalStateException("The parent of this TypeSolver cannot be itself.");
        }
        this.parent = parent;
    }

    public void add(TypeSolver typeSolver, boolean resetCache) {
        Objects.requireNonNull(typeSolver, "The type solver can't be null");
        this.elements.add(typeSolver);
        typeSolver.setParent(this);
        if (resetCache) {
            this.typeCache.removeAll();
        }
    }

    public void add(TypeSolver typeSolver) {
        this.add(typeSolver, true);
    }

    @Override
    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
        Optional<SymbolReference<ResolvedReferenceTypeDeclaration>> cachedSymbol = this.typeCache.get(name);
        if (cachedSymbol.isPresent()) {
            return cachedSymbol.get();
        }
        for (TypeSolver ts : this.elements) {
            try {
                SymbolReference<ResolvedReferenceTypeDeclaration> res = ts.tryToSolveType(name);
                if (!res.isSolved()) continue;
                this.typeCache.put(name, res);
                return res;
            }
            catch (Exception e) {
                if (this.exceptionHandler.test(e)) continue;
                throw e;
            }
        }
        SymbolReference<ResolvedReferenceTypeDeclaration> unsolvedSymbol = SymbolReference.unsolved();
        this.typeCache.put(name, unsolvedSymbol);
        return unsolvedSymbol;
    }

    @Override
    public ResolvedReferenceTypeDeclaration solveType(String name) throws UnsolvedSymbolException {
        SymbolReference<ResolvedReferenceTypeDeclaration> res = this.tryToSolveType(name);
        if (res.isSolved()) {
            return res.getCorrespondingDeclaration();
        }
        throw new UnsolvedSymbolException(name);
    }

    public static class ExceptionHandlers {
        public static final Predicate<Exception> IGNORE_NONE = e -> false;
        public static final Predicate<Exception> IGNORE_ALL = e -> true;
        public static final Predicate<Exception> IGNORE_UNSUPPORTED_OPERATION = ExceptionHandlers.getTypeBasedWhitelist(UnsupportedOperationException.class);
        public static final Predicate<Exception> IGNORE_UNSOLVED_SYMBOL = ExceptionHandlers.getTypeBasedWhitelist(UnsolvedSymbolException.class);
        public static final Predicate<Exception> IGNORE_UNSUPPORTED_AND_UNSOLVED = ExceptionHandlers.getTypeBasedWhitelist(UnsupportedOperationException.class, UnsolvedSymbolException.class);

        public static Predicate<Exception> getTypeBasedBlacklist(Class<? extends Exception> ... blacklist) {
            return e -> {
                for (Class clazz : blacklist) {
                    if (!clazz.isAssignableFrom(e.getClass())) continue;
                    return false;
                }
                return true;
            };
        }

        public static Predicate<Exception> getTypeBasedWhitelist(Class<? extends Exception> ... whitelist) {
            return e -> {
                for (Class clazz : whitelist) {
                    if (!clazz.isAssignableFrom(e.getClass())) continue;
                    return true;
                }
                return false;
            };
        }
    }
}

