/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithExtends;
import com.github.javaparser.ast.nodeTypes.NodeWithImplements;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.resolution.declarations.HasAccessSpecifier;
import com.github.javaparser.resolution.declarations.ResolvedClassDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeParameter;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.resolution.ConstructorResolutionLogic;
import com.github.javaparser.symbolsolver.resolution.MethodResolutionLogic;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class JavaParserTypeDeclarationAdapter {
    private TypeDeclaration<?> wrappedNode;
    private TypeSolver typeSolver;
    private Context context;
    private ResolvedReferenceTypeDeclaration typeDeclaration;

    public JavaParserTypeDeclarationAdapter(TypeDeclaration<?> wrappedNode, TypeSolver typeSolver, ResolvedReferenceTypeDeclaration typeDeclaration, Context context) {
        this.wrappedNode = wrappedNode;
        this.typeSolver = typeSolver;
        this.typeDeclaration = typeDeclaration;
        this.context = context;
    }

    public SymbolReference<ResolvedTypeDeclaration> solveType(String name) {
        ResolvedTypeDeclaration type;
        if (this.wrappedNode.getName().getId().equals(name)) {
            return SymbolReference.solved(JavaParserFacade.get(this.typeSolver).getTypeDeclaration(this.wrappedNode));
        }
        for (BodyDeclaration member : this.wrappedNode.getMembers()) {
            if (!(member instanceof TypeDeclaration)) continue;
            TypeDeclaration internalType = (TypeDeclaration)member;
            if (internalType.getName().getId().equals(name)) {
                return SymbolReference.solved(JavaParserFacade.get(this.typeSolver).getTypeDeclaration(internalType));
            }
            if (name.startsWith(this.wrappedNode.getName().getId() + "." + internalType.getName().getId())) {
                return JavaParserFactory.getContext((Node)internalType, this.typeSolver).solveType(name.substring(this.wrappedNode.getName().getId().length() + 1));
            }
            if (!name.startsWith(internalType.getName().getId() + ".")) continue;
            return JavaParserFactory.getContext((Node)internalType, this.typeSolver).solveType(name.substring(internalType.getName().getId().length() + 1));
        }
        if (this.wrappedNode instanceof NodeWithTypeParameters) {
            NodeWithTypeParameters nodeWithTypeParameters = (NodeWithTypeParameters)this.wrappedNode;
            for (TypeParameter astTpRaw : nodeWithTypeParameters.getTypeParameters()) {
                TypeParameter astTp = astTpRaw;
                if (!astTp.getName().getId().equals(name)) continue;
                return SymbolReference.solved(new JavaParserTypeParameter(astTp, this.typeSolver));
            }
        }
        if (this.wrappedNode instanceof NodeWithImplements) {
            NodeWithImplements nodeWithImplements = (NodeWithImplements)this.wrappedNode;
            for (ClassOrInterfaceType implementedType : nodeWithImplements.getImplementedTypes()) {
                if (!implementedType.getName().getId().equals(name)) continue;
                return this.context.getParent().orElseThrow(() -> new RuntimeException("Parent context unexpectedly empty.")).solveType(implementedType.getNameWithScope());
            }
        }
        if (this.wrappedNode instanceof NodeWithExtends) {
            NodeWithExtends nodeWithExtends = (NodeWithExtends)this.wrappedNode;
            for (ClassOrInterfaceType extendedType : nodeWithExtends.getExtendedTypes()) {
                if (!extendedType.getName().getId().equals(name)) continue;
                return this.context.getParent().orElseThrow(() -> new RuntimeException("Parent context unexpectedly empty.")).solveType(extendedType.getNameWithScope());
            }
        }
        if ((type = this.checkAncestorsForType(name, this.typeDeclaration)) != null) {
            return SymbolReference.solved(type);
        }
        return this.context.getParent().orElseThrow(() -> new RuntimeException("Parent context unexpectedly empty.")).solveType(name);
    }

    private ResolvedTypeDeclaration checkAncestorsForType(String name, ResolvedReferenceTypeDeclaration declaration) {
        for (ResolvedReferenceType ancestor : declaration.getAncestors(true)) {
            try {
                ResolvedReferenceTypeDeclaration ancestorReferenceTypeDeclaration = (ResolvedReferenceTypeDeclaration)ancestor.getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty."));
                for (ResolvedTypeDeclaration internalTypeDeclaration : ancestorReferenceTypeDeclaration.internalTypes()) {
                    ResolvedReferenceTypeDeclaration resolvedReferenceTypeDeclaration;
                    boolean visible = true;
                    if (internalTypeDeclaration instanceof ResolvedReferenceTypeDeclaration && (resolvedReferenceTypeDeclaration = internalTypeDeclaration.asReferenceType()) instanceof HasAccessSpecifier) {
                        boolean bl = visible = ((HasAccessSpecifier)resolvedReferenceTypeDeclaration).accessSpecifier() != AccessSpecifier.PRIVATE;
                    }
                    if (!internalTypeDeclaration.getName().equals(name)) continue;
                    if (visible) {
                        return internalTypeDeclaration;
                    }
                    return null;
                }
                ResolvedTypeDeclaration ancestorTypeDeclaration = this.checkAncestorsForType(name, ancestorReferenceTypeDeclaration);
                if (ancestorTypeDeclaration == null) continue;
                return ancestorTypeDeclaration;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        return null;
    }

    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        SymbolReference<ResolvedMethodDeclaration> res;
        SymbolReference<ResolvedMethodDeclaration> parentSolution;
        List<ResolvedMethodDeclaration> candidateMethods = this.typeDeclaration.getDeclaredMethods().stream().filter(m -> m.getName().equals(name)).filter(m -> !staticOnly || m.isStatic()).collect(Collectors.toList());
        if (!this.typeDeclaration.isJavaLangObject()) {
            for (ResolvedReferenceType ancestor : this.typeDeclaration.getAncestors(true)) {
                Optional ancestorTypeDeclaration = ancestor.getTypeDeclaration();
                if (!ancestor.getTypeDeclaration().isPresent() || this.typeDeclaration == ancestorTypeDeclaration.get()) continue;
                candidateMethods.addAll(ancestor.getAllMethodsVisibleToInheritors().stream().filter(m -> m.getName().equals(name)).collect(Collectors.toList()));
                SymbolReference<ResolvedMethodDeclaration> res2 = MethodResolutionLogic.solveMethodInType((ResolvedTypeDeclaration)ancestorTypeDeclaration.get(), name, argumentsTypes, staticOnly);
                if (!res2.isSolved()) continue;
                candidateMethods.add(res2.getCorrespondingDeclaration());
            }
        }
        if (candidateMethods.isEmpty() && (parentSolution = this.context.getParent().orElseThrow(() -> new RuntimeException("Parent context unexpectedly empty.")).solveMethod(name, argumentsTypes, staticOnly)).isSolved()) {
            candidateMethods.add(parentSolution.getCorrespondingDeclaration());
        }
        if (candidateMethods.isEmpty() && this.typeDeclaration.isInterface() && (res = MethodResolutionLogic.solveMethodInType((ResolvedTypeDeclaration)new ReflectionClassDeclaration(Object.class, this.typeSolver), name, argumentsTypes, false)).isSolved()) {
            candidateMethods.add(res.getCorrespondingDeclaration());
        }
        return MethodResolutionLogic.findMostApplicable(candidateMethods, name, argumentsTypes, this.typeSolver);
    }

    public SymbolReference<ResolvedConstructorDeclaration> solveConstructor(List<ResolvedType> argumentsTypes) {
        if (this.typeDeclaration instanceof ResolvedClassDeclaration) {
            return ConstructorResolutionLogic.findMostApplicable(this.typeDeclaration.getConstructors(), argumentsTypes, this.typeSolver);
        }
        return SymbolReference.unsolved(ResolvedConstructorDeclaration.class);
    }
}

