/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typesolvers;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseStart;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Providers;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.symbolsolver.cache.Cache;
import com.github.javaparser.symbolsolver.cache.GuavaCache;
import com.github.javaparser.symbolsolver.javaparser.Navigator;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.utils.FileUtils;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JavaParserTypeSolver
implements TypeSolver {
    private final Path srcDir;
    private final JavaParser javaParser;
    private TypeSolver parent;
    private final Cache<Path, Optional<CompilationUnit>> parsedFiles;
    private final Cache<Path, List<CompilationUnit>> parsedDirectories;
    private final Cache<String, SymbolReference<ResolvedReferenceTypeDeclaration>> foundTypes;
    private static final int CACHE_SIZE_UNSET = -1;

    public JavaParserTypeSolver(File srcDir) {
        this(srcDir.toPath());
    }

    public JavaParserTypeSolver(String srcDir) {
        this(new File(srcDir));
    }

    public JavaParserTypeSolver(Path srcDir) {
        this(srcDir, new ParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.BLEEDING_EDGE));
    }

    public JavaParserTypeSolver(File srcDir, ParserConfiguration parserConfiguration) {
        this(srcDir.toPath(), parserConfiguration);
    }

    public JavaParserTypeSolver(String srcDir, ParserConfiguration parserConfiguration) {
        this(new File(srcDir), parserConfiguration);
    }

    public JavaParserTypeSolver(Path srcDir, ParserConfiguration parserConfiguration) {
        this(srcDir, parserConfiguration, -1L);
    }

    private <TKey, TValue> Cache<TKey, TValue> BuildCache(long cacheSizeLimit) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().softValues();
        if (cacheSizeLimit != -1L) {
            cacheBuilder.maximumSize(cacheSizeLimit);
        }
        return new GuavaCache(cacheBuilder.build());
    }

    public JavaParserTypeSolver(Path srcDir, ParserConfiguration parserConfiguration, long cacheSizeLimit) {
        if (!Files.exists(srcDir, new LinkOption[0]) || !Files.isDirectory(srcDir, new LinkOption[0])) {
            throw new IllegalStateException("SrcDir does not exist or is not a directory: " + srcDir);
        }
        this.srcDir = srcDir;
        this.javaParser = new JavaParser(parserConfiguration);
        this.parsedFiles = this.BuildCache(cacheSizeLimit);
        this.parsedDirectories = this.BuildCache(cacheSizeLimit);
        this.foundTypes = this.BuildCache(cacheSizeLimit);
    }

    public JavaParserTypeSolver(Path srcDir, JavaParser javaParser, Cache<Path, Optional<CompilationUnit>> parsedFilesCache, Cache<Path, List<CompilationUnit>> parsedDirectoriesCache, Cache<String, SymbolReference<ResolvedReferenceTypeDeclaration>> foundTypesCache) {
        Objects.requireNonNull(srcDir, "The srcDir can't be null.");
        Objects.requireNonNull(javaParser, "The javaParser can't be null.");
        Objects.requireNonNull(parsedFilesCache, "The parsedFilesCache can't be null.");
        Objects.requireNonNull(parsedDirectoriesCache, "The parsedDirectoriesCache can't be null.");
        Objects.requireNonNull(foundTypesCache, "The foundTypesCache can't be null.");
        if (!Files.exists(srcDir, new LinkOption[0]) || !Files.isDirectory(srcDir, new LinkOption[0])) {
            throw new IllegalStateException("SrcDir does not exist or is not a directory: " + srcDir);
        }
        this.srcDir = srcDir;
        this.javaParser = javaParser;
        this.parsedFiles = parsedFilesCache;
        this.parsedDirectories = parsedDirectoriesCache;
        this.foundTypes = foundTypesCache;
    }

    public String toString() {
        return "JavaParserTypeSolver{srcDir=" + this.srcDir + ", parent=" + this.parent + '}';
    }

    @Override
    public TypeSolver getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TypeSolver parent) {
        Objects.requireNonNull(parent);
        if (this.parent != null) {
            throw new IllegalStateException("This TypeSolver already has a parent.");
        }
        if (parent == this) {
            throw new IllegalStateException("The parent of this TypeSolver cannot be itself.");
        }
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CompilationUnit> parse(Path srcFile) {
        try {
            Optional<Optional<CompilationUnit>> cachedParsedFile = this.parsedFiles.get(srcFile.toAbsolutePath());
            if (cachedParsedFile.isPresent()) {
                return cachedParsedFile.get();
            }
            if (!Files.exists(srcFile, new LinkOption[0]) || !Files.isRegularFile(srcFile, new LinkOption[0])) {
                this.parsedFiles.put(srcFile.toAbsolutePath(), Optional.empty());
                return Optional.empty();
            }
            JavaParser javaParser = this.javaParser;
            synchronized (javaParser) {
                Optional<CompilationUnit> compilationUnit = this.javaParser.parse(ParseStart.COMPILATION_UNIT, Providers.provider((Path)srcFile)).getResult().map(cu -> cu.setStorage(srcFile));
                this.parsedFiles.put(srcFile.toAbsolutePath(), compilationUnit);
                return compilationUnit;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Issue while parsing while type solving: " + srcFile.toAbsolutePath(), e);
        }
    }

    private List<CompilationUnit> parseDirectory(Path srcDirectory) {
        return this.parseDirectory(srcDirectory, false);
    }

    private List<CompilationUnit> parseDirectoryRecursively(Path srcDirectory) {
        return this.parseDirectory(srcDirectory, true);
    }

    private List<CompilationUnit> parseDirectory(Path srcDirectory, boolean recursively) {
        try {
            Optional<List<CompilationUnit>> cachedValue = this.parsedDirectories.get(srcDirectory.toAbsolutePath());
            if (cachedValue.isPresent()) {
                return cachedValue.get();
            }
            ArrayList<CompilationUnit> units = new ArrayList<CompilationUnit>();
            if (Files.exists(srcDirectory, new LinkOption[0])) {
                try (DirectoryStream<Path> srcDirectoryStream = Files.newDirectoryStream(srcDirectory);){
                    srcDirectoryStream.forEach(file -> {
                        if (file.getFileName().toString().toLowerCase().endsWith(".java")) {
                            this.parse((Path)file).ifPresent(units::add);
                        } else if (recursively && file.toFile().isDirectory()) {
                            units.addAll(this.parseDirectoryRecursively((Path)file));
                        }
                    });
                }
            }
            this.parsedDirectories.put(srcDirectory.toAbsolutePath(), units);
            return units;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse directory due to an exception. Directory:" + srcDirectory.toAbsolutePath(), e);
        }
    }

    @Override
    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
        Optional<SymbolReference<ResolvedReferenceTypeDeclaration>> cachedValue = this.foundTypes.get(name);
        if (cachedValue.isPresent()) {
            return cachedValue.get();
        }
        SymbolReference<ResolvedReferenceTypeDeclaration> result = this.tryToSolveTypeUncached(name);
        this.foundTypes.put(name, result);
        return result;
    }

    private SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveTypeUncached(String name) {
        String[] nameElements = name.split("\\.");
        for (int i = nameElements.length; i > 0; --i) {
            StringBuilder filePath = new StringBuilder(this.srcDir.toAbsolutePath().toString());
            for (int j = 0; j < i; ++j) {
                filePath.append(File.separator).append(nameElements[j]);
            }
            filePath.append(".java");
            StringBuilder typeName = new StringBuilder();
            for (int j = i - 1; j < nameElements.length; ++j) {
                if (j != i - 1) {
                    typeName.append(".");
                }
                typeName.append(nameElements[j]);
            }
            String dirToParse = null;
            if (FileUtils.isValidPath(filePath.toString())) {
                Optional<TypeDeclaration<?>> astTypeDeclaration;
                Path srcFile = Paths.get(filePath.toString(), new String[0]);
                Optional<CompilationUnit> compilationUnit = this.parse(srcFile);
                if (compilationUnit.isPresent() && (astTypeDeclaration = Navigator.findType(compilationUnit.get(), typeName.toString())).isPresent()) {
                    return SymbolReference.solved(JavaParserFacade.get(this).getTypeDeclaration(astTypeDeclaration.get()));
                }
                dirToParse = srcFile.getParent().normalize().toString();
            } else {
                dirToParse = FileUtils.getParentPath(filePath.toString());
            }
            if (!FileUtils.isValidPath(dirToParse)) continue;
            List<CompilationUnit> compilationUnits = this.parseDirectory(Paths.get(dirToParse, new String[0]));
            for (CompilationUnit compilationUnit : compilationUnits) {
                Optional<TypeDeclaration<?>> astTypeDeclaration = Navigator.findType(compilationUnit, typeName.toString());
                if (!astTypeDeclaration.isPresent()) continue;
                return SymbolReference.solved(JavaParserFacade.get(this).getTypeDeclaration(astTypeDeclaration.get()));
            }
        }
        return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
    }
}

