/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.PatternExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithStatements;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.AbstractJavaParserContext;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserSymbolDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.resolution.Value;
import com.github.javaparser.symbolsolver.resolution.SymbolDeclarator;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;

public class StatementContext<N extends Statement>
extends AbstractJavaParserContext<N> {
    public StatementContext(N wrappedNode, TypeSolver typeSolver) {
        super(wrappedNode, typeSolver);
    }

    public static SymbolReference<? extends ResolvedValueDeclaration> solveInBlock(String name, TypeSolver typeSolver, Statement stmt) {
        int i;
        Optional optionalParentNode = stmt.getParentNode();
        if (!optionalParentNode.isPresent()) {
            return SymbolReference.unsolved(ResolvedValueDeclaration.class);
        }
        Node parentOfWrappedNode = (Node)optionalParentNode.get();
        if (!(parentOfWrappedNode instanceof NodeWithStatements)) {
            throw new IllegalArgumentException();
        }
        NodeWithStatements blockStmt = (NodeWithStatements)parentOfWrappedNode;
        int position = -1;
        for (i = 0; i < blockStmt.getStatements().size(); ++i) {
            if (!((Statement)blockStmt.getStatements().get(i)).equals((Object)stmt)) continue;
            position = i;
        }
        if (position == -1) {
            throw new RuntimeException();
        }
        for (i = position - 1; i >= 0; --i) {
            SymbolDeclarator symbolDeclarator = JavaParserFactory.getSymbolDeclarator(blockStmt.getStatements().get(i), typeSolver);
            SymbolReference<ResolvedValueDeclaration> symbolReference = StatementContext.solveWith(symbolDeclarator, name);
            if (!symbolReference.isSolved()) continue;
            return symbolReference;
        }
        return JavaParserFactory.getContext(parentOfWrappedNode, typeSolver).solveSymbol(name);
    }

    public static Optional<Value> solveInBlockAsValue(String name, TypeSolver typeSolver, Statement stmt) {
        int i;
        Optional optionalParentNode = stmt.getParentNode();
        if (!optionalParentNode.isPresent()) {
            return Optional.empty();
        }
        Node parentOfWrappedNode = (Node)optionalParentNode.get();
        if (!(parentOfWrappedNode instanceof NodeWithStatements)) {
            throw new IllegalArgumentException();
        }
        NodeWithStatements blockStmt = (NodeWithStatements)parentOfWrappedNode;
        int position = -1;
        for (i = 0; i < blockStmt.getStatements().size(); ++i) {
            if (!((Statement)blockStmt.getStatements().get(i)).equals((Object)stmt)) continue;
            position = i;
        }
        if (position == -1) {
            throw new RuntimeException();
        }
        for (i = position - 1; i >= 0; --i) {
            SymbolDeclarator symbolDeclarator = JavaParserFactory.getSymbolDeclarator(blockStmt.getStatements().get(i), typeSolver);
            SymbolReference<ResolvedValueDeclaration> symbolReference = StatementContext.solveWith(symbolDeclarator, name);
            if (!symbolReference.isSolved()) continue;
            return Optional.of(Value.from(symbolReference.getCorrespondingDeclaration()));
        }
        return JavaParserFactory.getContext(parentOfWrappedNode, typeSolver).solveSymbolAsValue(name);
    }

    @Override
    public Optional<Value> solveSymbolAsValue(String name) {
        SymbolDeclarator symbolDeclarator = JavaParserFactory.getSymbolDeclarator(this.wrappedNode, this.typeSolver);
        Optional<Value> symbolReference = this.solveWithAsValue(symbolDeclarator, name);
        if (symbolReference.isPresent()) {
            return symbolReference;
        }
        if (!this.getParent().isPresent()) {
            return Optional.empty();
        }
        Context parentContext = this.getParent().get();
        Optional optionalParentNode = ((Statement)this.wrappedNode).getParentNode();
        if (!optionalParentNode.isPresent()) {
            return Optional.empty();
        }
        Node parentOfWrappedNode = (Node)optionalParentNode.get();
        if (parentOfWrappedNode instanceof MethodDeclaration) {
            return parentContext.solveSymbolAsValue(name);
        }
        if (parentOfWrappedNode instanceof LambdaExpr) {
            return parentContext.solveSymbolAsValue(name);
        }
        if (!(parentOfWrappedNode instanceof NodeWithStatements)) {
            return parentContext.solveSymbolAsValue(name);
        }
        NodeWithStatements nodeWithStmt = (NodeWithStatements)parentOfWrappedNode;
        int position = -1;
        for (int i = 0; i < nodeWithStmt.getStatements().size(); ++i) {
            if (!((Statement)nodeWithStmt.getStatements().get(i)).equals((Object)this.wrappedNode)) continue;
            position = i;
        }
        if (position == -1) {
            throw new RuntimeException();
        }
        for (int statementIndex = position - 1; statementIndex >= 0; --statementIndex) {
            Statement statement = (Statement)nodeWithStmt.getStatements().get(statementIndex);
            symbolDeclarator = JavaParserFactory.getSymbolDeclarator((Node)statement, this.typeSolver);
            symbolReference = this.solveWithAsValue(symbolDeclarator, name);
            if (!symbolReference.isPresent()) continue;
            return symbolReference;
        }
        return this.solveSymbolAsValueInParentContext(name);
    }

    @Override
    protected Optional<Value> solveWithAsValue(SymbolDeclarator symbolDeclarator, String name) {
        return super.solveWithAsValue(symbolDeclarator, name);
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name) {
        return this.solveSymbol(name, true);
    }

    private SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, boolean iterateAdjacentStmts) {
        SymbolDeclarator symbolDeclarator = JavaParserFactory.getSymbolDeclarator(this.wrappedNode, this.typeSolver);
        SymbolReference<Object> symbolReference = StatementContext.solveWith(symbolDeclarator, name);
        if (symbolReference.isSolved()) {
            return symbolReference;
        }
        List<PatternExpr> patternExprs = this.patternExprsExposedFromChildren();
        for (int i = 0; i < patternExprs.size(); ++i) {
            PatternExpr patternExpr = patternExprs.get(i);
            if (!patternExpr.getNameAsString().equals(name)) continue;
            return SymbolReference.solved(JavaParserSymbolDeclaration.patternVar(patternExpr, this.typeSolver));
        }
        Optional optionalParentNode = ((Statement)this.wrappedNode).getParentNode();
        if (!optionalParentNode.isPresent()) {
            return SymbolReference.unsolved(ResolvedValueDeclaration.class);
        }
        Node parentOfWrappedNode = (Node)optionalParentNode.get();
        if (parentOfWrappedNode instanceof MethodDeclaration) {
            return this.solveSymbolInParentContext(name);
        }
        if (parentOfWrappedNode instanceof ConstructorDeclaration) {
            return this.solveSymbolInParentContext(name);
        }
        if (parentOfWrappedNode instanceof LambdaExpr) {
            return this.solveSymbolInParentContext(name);
        }
        if (parentOfWrappedNode instanceof NodeWithStatements) {
            if (!iterateAdjacentStmts) {
                return SymbolReference.unsolved(ResolvedValueDeclaration.class);
            }
            NodeWithStatements nodeWithStmt = (NodeWithStatements)parentOfWrappedNode;
            int position = nodeWithStmt.getStatements().indexOf((Object)this.wrappedNode);
            if (position == -1) {
                throw new IllegalStateException("This node is not a statement within the current NodeWithStatements");
            }
            ListIterator statementListIterator = nodeWithStmt.getStatements().listIterator(position);
            while (statementListIterator.hasPrevious()) {
                Context prevContext = JavaParserFactory.getContext((Node)statementListIterator.previous(), this.typeSolver);
                symbolReference = prevContext instanceof StatementContext ? ((StatementContext)prevContext).solveSymbol(name, false) : prevContext.solveSymbol(name);
                if (!symbolReference.isSolved()) continue;
                return symbolReference;
            }
        }
        return this.solveSymbolInParentContext(name);
    }

    @Override
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        return this.solveMethodInParentContext(name, argumentsTypes, false);
    }

    @Override
    public List<PatternExpr> patternExprsExposedFromChildren() {
        return Collections.emptyList();
    }

    @Override
    public List<PatternExpr> negatedPatternExprsExposedFromChildren() {
        return Collections.emptyList();
    }
}

