/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javassistmodel;

import com.github.javaparser.resolution.declarations.ResolvedMethodLikeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParametrizable;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistParameterDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistTypeParameter;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javassist.CtBehavior;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;

public class JavassistMethodLikeDeclarationAdapter {
    private CtBehavior ctBehavior;
    private TypeSolver typeSolver;
    private ResolvedMethodLikeDeclaration declaration;
    private SignatureAttribute.MethodSignature methodSignature;

    public JavassistMethodLikeDeclarationAdapter(CtBehavior ctBehavior, TypeSolver typeSolver, ResolvedMethodLikeDeclaration declaration) {
        this.ctBehavior = ctBehavior;
        this.typeSolver = typeSolver;
        this.declaration = declaration;
        try {
            String signature = ctBehavior.getGenericSignature();
            if (signature == null) {
                signature = ctBehavior.getSignature();
            }
            this.methodSignature = SignatureAttribute.toMethodSignature((String)signature);
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
    }

    public int getNumberOfParams() {
        return this.methodSignature.getParameterTypes().length;
    }

    public ResolvedParameterDeclaration getParam(int i) {
        boolean variadic = false;
        if ((this.ctBehavior.getModifiers() & 0x80) > 0) {
            variadic = i == this.methodSignature.getParameterTypes().length - 1;
        }
        Optional<String> paramName = JavassistUtils.extractParameterName(this.ctBehavior, i);
        ResolvedType type = JavassistUtils.signatureTypeToType(this.methodSignature.getParameterTypes()[i], this.typeSolver, (ResolvedTypeParametrizable)this.declaration);
        return new JavassistParameterDeclaration(type, this.typeSolver, variadic, (String)paramName.orElse(null));
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        if (this.ctBehavior.getGenericSignature() == null) {
            return new ArrayList<ResolvedTypeParameterDeclaration>();
        }
        return Arrays.stream(this.methodSignature.getTypeParameters()).map(jasTp -> new JavassistTypeParameter((SignatureAttribute.TypeParameter)jasTp, (ResolvedTypeParametrizable)this.declaration, this.typeSolver)).collect(Collectors.toList());
    }

    public int getNumberOfSpecifiedExceptions() {
        return this.methodSignature.getExceptionTypes().length;
    }

    public ResolvedType getSpecifiedException(int index) {
        if (index < 0 || index >= this.getNumberOfSpecifiedExceptions()) {
            throw new IllegalArgumentException(String.format("No exception with index %d. Number of exceptions: %d", index, this.getNumberOfSpecifiedExceptions()));
        }
        return JavassistUtils.signatureTypeToType((SignatureAttribute.Type)this.methodSignature.getExceptionTypes()[index], this.typeSolver, (ResolvedTypeParametrizable)this.declaration);
    }

    public ResolvedType getReturnType() {
        return JavassistUtils.signatureTypeToType(this.methodSignature.getReturnType(), this.typeSolver, (ResolvedTypeParametrizable)this.declaration);
    }
}

