/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.naming;

import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.ReceiverParameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.SuperExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.modules.ModuleDeclaration;
import com.github.javaparser.ast.modules.ModuleExportsDirective;
import com.github.javaparser.ast.modules.ModuleOpensDirective;
import com.github.javaparser.ast.modules.ModuleProvidesDirective;
import com.github.javaparser.ast.modules.ModuleRequiresDirective;
import com.github.javaparser.ast.modules.ModuleUsesDirective;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.resolution.naming.NameCategory;
import com.github.javaparser.symbolsolver.resolution.naming.NameRole;

public class NameLogic {
    public static boolean isSimpleName(Node node) {
        return !NameLogic.isQualifiedName(node);
    }

    public static boolean isQualifiedName(Node node) {
        if (!NameLogic.isAName(node)) {
            throw new IllegalArgumentException();
        }
        return NameLogic.nameAsString(node).contains(".");
    }

    public static boolean isAName(Node node) {
        if (node instanceof FieldAccessExpr) {
            FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)node;
            return NameLogic.isAName((Node)fieldAccessExpr.getScope());
        }
        return node instanceof SimpleName || node instanceof Name || node instanceof ClassOrInterfaceType || node instanceof NameExpr;
    }

    private static Node getQualifier(Node node) {
        if (node instanceof FieldAccessExpr) {
            FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)node;
            return fieldAccessExpr.getScope();
        }
        throw new UnsupportedOperationException(node.getClass().getCanonicalName());
    }

    private static Node getRightMostName(Node node) {
        if (node instanceof FieldAccessExpr) {
            FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)node;
            return fieldAccessExpr.getName();
        }
        throw new UnsupportedOperationException(node.getClass().getCanonicalName());
    }

    public static NameRole classifyRole(Node name) {
        if (!NameLogic.isAName(name)) {
            throw new IllegalArgumentException("The given node is not a name");
        }
        if (!name.getParentNode().isPresent()) {
            throw new IllegalArgumentException("We cannot understand the role of a name if it has no parent");
        }
        if (NameLogic.whenParentIs(Name.class, name, (p, c) -> p.getQualifier().isPresent() && p.getQualifier().get() == c)) {
            return NameLogic.classifyRole((Node)name.getParentNode().get());
        }
        if (NameLogic.whenParentIs(PackageDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(ImportDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(MarkerAnnotationExpr.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ClassOrInterfaceDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(ClassOrInterfaceDeclaration.class, name, (p, c) -> p.getExtendedTypes().contains((Object)c) || p.getImplementedTypes().contains((Object)c))) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ClassOrInterfaceType.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(VariableDeclarator.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(NameExpr.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(FieldAccessExpr.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(MethodDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(Parameter.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(MethodCallExpr.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ConstructorDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(AnnotationDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(AnnotationMemberDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(AnnotationMemberDeclaration.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(MethodDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(MethodDeclaration.class, name, (p, c) -> p.getType() == c || p.getThrownExceptions().contains((Object)c))) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(Parameter.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(Parameter.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ReceiverParameter.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(MethodCallExpr.class, name, (p, c) -> p.getName() == c || p.getTypeArguments().isPresent() && ((NodeList)p.getTypeArguments().get()).contains((Object)c) || p.getScope().isPresent() && p.getScope().get() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ConstructorDeclaration.class, name, (p, c) -> p.getName() == c || p.getThrownExceptions().contains((Object)c))) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(TypeParameter.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(EnumDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(EnumConstantDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(FieldAccessExpr.class, name, (p, c) -> p.getName() == c || p.getScope() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ObjectCreationExpr.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ReturnStmt.class, name, (p, c) -> p.getExpression().isPresent() && p.getExpression().get() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ModuleDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(ModuleRequiresDirective.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ModuleExportsDirective.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ModuleExportsDirective.class, name, (p, c) -> p.getModuleNames().contains((Object)c))) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ModuleOpensDirective.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ModuleOpensDirective.class, name, (p, c) -> p.getModuleNames().contains((Object)c))) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ModuleUsesDirective.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ModuleProvidesDirective.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ClassExpr.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ThisExpr.class, name, (p, c) -> p.getTypeName().isPresent() && p.getTypeName().get() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(SuperExpr.class, name, (p, c) -> p.getTypeName().isPresent() && p.getTypeName().get() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(VariableDeclarator.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(VariableDeclarator.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ArrayCreationExpr.class, name, (p, c) -> p.getElementType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(CastExpr.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(InstanceOfExpr.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(TypeExpr.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ArrayAccessExpr.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(UnaryExpr.class, name, (p, c) -> p.getExpression() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(AssignExpr.class, name, (p, c) -> p.getTarget() == c || p.getValue() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(TryStmt.class, name, (p, c) -> p.getResources().contains((Object)c))) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(VariableDeclarator.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(VariableDeclarator.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(VariableDeclarator.class, name, (p, c) -> p.getInitializer().isPresent() && p.getInitializer().get() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(MemberValuePair.class, name, (p, c) -> p.getValue() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(MemberValuePair.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(ExplicitConstructorInvocationStmt.class, name, (p, c) -> p.getExpression().isPresent() && p.getExpression().get() == c || p.getTypeArguments().isPresent() && ((NodeList)p.getTypeArguments().get()).contains((Object)c))) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ObjectCreationExpr.class, name, (p, c) -> p.getType() == c || p.getScope().isPresent() && p.getScope().get() == c)) {
            return NameRole.REFERENCE;
        }
        if (name.getParentNode().isPresent() && NameLogic.isAName((Node)name.getParentNode().get())) {
            return NameLogic.classifyRole((Node)name.getParentNode().get());
        }
        throw new UnsupportedOperationException("Unable to classify role of name contained in " + ((Node)name.getParentNode().get()).getClass().getSimpleName());
    }

    public static NameCategory classifyReference(Node name, TypeSolver typeSolver) {
        if (!name.getParentNode().isPresent()) {
            throw new IllegalArgumentException("We cannot understand the category of a name if it has no parent");
        }
        if (NameLogic.classifyRole(name) != NameRole.REFERENCE) {
            throw new IllegalArgumentException("This method can be used only to classify names used as references");
        }
        NameCategory first = NameLogic.syntacticClassificationAccordingToContext(name);
        if (first.isNeedingDisambiguation()) {
            NameCategory second = NameLogic.reclassificationOfContextuallyAmbiguousNames(name, first, typeSolver);
            assert (!second.isNeedingDisambiguation());
            return second;
        }
        return first;
    }

    private static NameCategory reclassificationOfContextuallyAmbiguousNames(Node name, NameCategory ambiguousCategory, TypeSolver typeSolver) {
        if (!ambiguousCategory.isNeedingDisambiguation()) {
            throw new IllegalArgumentException("The Name Category is not ambiguous: " + (Object)((Object)ambiguousCategory));
        }
        if (ambiguousCategory == NameCategory.AMBIGUOUS_NAME && NameLogic.isSimpleName(name)) {
            return NameLogic.reclassificationOfContextuallyAmbiguousSimpleAmbiguousName(name, typeSolver);
        }
        if (ambiguousCategory == NameCategory.AMBIGUOUS_NAME && NameLogic.isQualifiedName(name)) {
            return NameLogic.reclassificationOfContextuallyAmbiguousQualifiedAmbiguousName(name, typeSolver);
        }
        if (ambiguousCategory == NameCategory.PACKAGE_OR_TYPE_NAME) {
            return NameLogic.reclassificationOfContextuallyAmbiguosPackageOrTypeName(name, typeSolver);
        }
        throw new UnsupportedOperationException("I do not know how to handle this semantic reclassification of ambiguous name categories");
    }

    private static NameCategory reclassificationOfContextuallyAmbiguosPackageOrTypeName(Node name, TypeSolver typeSolver) {
        if (NameLogic.isSimpleName(name)) {
            if (JavaParserFactory.getContext(name, typeSolver).solveType(NameLogic.nameAsString(name)).isSolved()) {
                return NameCategory.TYPE_NAME;
            }
            return NameCategory.PACKAGE_NAME;
        }
        if (NameLogic.isQualifiedName(name)) {
            if (JavaParserFactory.getContext(name, typeSolver).solveType(NameLogic.nameAsString(name)).isSolved()) {
                return NameCategory.TYPE_NAME;
            }
            return NameCategory.PACKAGE_NAME;
        }
        throw new UnsupportedOperationException("This is unexpected: the name is neither simple or qualified");
    }

    private static NameCategory reclassificationOfContextuallyAmbiguousQualifiedAmbiguousName(Node nameNode, TypeSolver typeSolver) {
        Node leftName = NameLogic.getQualifier(nameNode);
        String rightName = NameLogic.nameAsString(NameLogic.getRightMostName(nameNode));
        NameCategory leftNameCategory = NameLogic.classifyReference(leftName, typeSolver);
        if (leftNameCategory == NameCategory.PACKAGE_NAME) {
            if (typeSolver.hasType(NameLogic.nameAsString(nameNode))) {
                return NameCategory.TYPE_NAME;
            }
            return NameCategory.PACKAGE_NAME;
        }
        if (leftNameCategory == NameCategory.TYPE_NAME) {
            SymbolReference<ResolvedTypeDeclaration> scopeTypeRef = JavaParserFactory.getContext(leftName, typeSolver).solveType(NameLogic.nameAsString(leftName));
            if (scopeTypeRef.isSolved()) {
                ResolvedTypeDeclaration scopeType = scopeTypeRef.getCorrespondingDeclaration();
                if (scopeType instanceof ResolvedReferenceTypeDeclaration) {
                    ResolvedReferenceTypeDeclaration scopeRefType = scopeType.asReferenceType();
                    if (scopeRefType.getAllMethods().stream().anyMatch(m -> m.getName().equals(rightName))) {
                        return NameCategory.EXPRESSION_NAME;
                    }
                    if (scopeRefType.getAllFields().stream().anyMatch(f -> f.isStatic() && f.getName().equals(rightName))) {
                        return NameCategory.EXPRESSION_NAME;
                    }
                    if (scopeRefType.hasInternalType(rightName)) {
                        return NameCategory.TYPE_NAME;
                    }
                    return NameCategory.COMPILATION_ERROR;
                }
                throw new UnsupportedOperationException("The name is a type but it has been resolved to something that is not a reference type");
            }
            throw new UnsolvedSymbolException("Unable to solve context type: " + NameLogic.nameAsString(leftName));
        }
        if (leftNameCategory == NameCategory.EXPRESSION_NAME) {
            return NameCategory.EXPRESSION_NAME;
        }
        throw new UnsupportedOperationException("I do not know how to handle this semantic reclassification of ambiguous name categories");
    }

    private static NameCategory reclassificationOfContextuallyAmbiguousSimpleAmbiguousName(Node nameNode, TypeSolver typeSolver) {
        String name = NameLogic.nameAsString(nameNode);
        Context context = JavaParserFactory.getContext(nameNode, typeSolver);
        if (context.localVariableDeclarationInScope(name).isPresent()) {
            return NameCategory.EXPRESSION_NAME;
        }
        if (context.parameterDeclarationInScope(name).isPresent()) {
            return NameCategory.EXPRESSION_NAME;
        }
        if (context.fieldDeclarationInScope(name).isPresent()) {
            return NameCategory.EXPRESSION_NAME;
        }
        return NameCategory.PACKAGE_NAME;
    }

    public static NameCategory syntacticClassificationAccordingToContext(Node name) {
        Node parent;
        if (name.getParentNode().isPresent() && NameLogic.isAName(parent = (Node)name.getParentNode().get()) && NameLogic.nameAsString(name).equals(NameLogic.nameAsString(parent))) {
            return NameLogic.syntacticClassificationAccordingToContext(parent);
        }
        if (NameLogic.isSyntacticallyATypeName(name)) {
            return NameCategory.TYPE_NAME;
        }
        if (NameLogic.isSyntacticallyAnExpressionName(name)) {
            return NameCategory.EXPRESSION_NAME;
        }
        if (NameLogic.isSyntacticallyAMethodName(name)) {
            return NameCategory.METHOD_NAME;
        }
        if (NameLogic.isSyntacticallyAPackageOrTypeName(name)) {
            return NameCategory.PACKAGE_OR_TYPE_NAME;
        }
        if (NameLogic.isSyntacticallyAAmbiguousName(name)) {
            return NameCategory.AMBIGUOUS_NAME;
        }
        if (NameLogic.isSyntacticallyAModuleName(name)) {
            return NameCategory.MODULE_NAME;
        }
        if (NameLogic.isSyntacticallyAPackageName(name)) {
            return NameCategory.PACKAGE_NAME;
        }
        if (name instanceof NameExpr) {
            return NameCategory.EXPRESSION_NAME;
        }
        if (name instanceof FieldAccessExpr) {
            return NameCategory.EXPRESSION_NAME;
        }
        if (name instanceof ClassOrInterfaceType) {
            return NameCategory.TYPE_NAME;
        }
        if (name.getParentNode().isPresent() && name.getParentNode().get() instanceof ClassOrInterfaceType) {
            return NameCategory.TYPE_NAME;
        }
        if (name.getParentNode().isPresent() && name.getParentNode().get() instanceof FieldAccessExpr) {
            return NameCategory.EXPRESSION_NAME;
        }
        throw new UnsupportedOperationException("Unable to classify category of name contained in " + ((Node)name.getParentNode().get()).getClass().getSimpleName() + ". See " + name + " at " + name.getRange());
    }

    private static boolean isSyntacticallyAAmbiguousName(Node name) {
        if (NameLogic.whenParentIs(FieldAccessExpr.class, name, (p, c) -> p.getScope() == c)) {
            return true;
        }
        if (NameLogic.whenParentIs(MethodCallExpr.class, name, (p, c) -> p.getScope().isPresent() && p.getScope().get() == c)) {
            return true;
        }
        return NameLogic.whenParentIs(MemberValuePair.class, name, (p, c) -> p.getValue() == c);
    }

    private static boolean isSyntacticallyAPackageOrTypeName(Node name) {
        if (NameLogic.whenParentIs(ClassOrInterfaceType.class, name, (p, c) -> p.getScope().isPresent() && p.getScope().get() == c && (NameLogic.isSyntacticallyATypeName(p) || NameLogic.isSyntacticallyAPackageOrTypeName(p)))) {
            return true;
        }
        return NameLogic.whenParentIs(ImportDeclaration.class, name, (p, c) -> !p.isStatic() && p.isAsterisk() && p.getName() == name);
    }

    private static boolean isSyntacticallyAMethodName(Node name) {
        return NameLogic.whenParentIs(MethodCallExpr.class, name, (p, c) -> p.getName() == c);
    }

    private static boolean isSyntacticallyAModuleName(Node name) {
        if (NameLogic.whenParentIs(ModuleRequiresDirective.class, name, (p, c) -> p.getName() == name)) {
            return true;
        }
        if (NameLogic.whenParentIs(ModuleExportsDirective.class, name, (p, c) -> p.getModuleNames().contains((Object)name))) {
            return true;
        }
        return NameLogic.whenParentIs(ModuleOpensDirective.class, name, (p, c) -> p.getModuleNames().contains((Object)name));
    }

    private static boolean isSyntacticallyAPackageName(Node name) {
        if (NameLogic.whenParentIs(ModuleExportsDirective.class, name, (p, c) -> p.getName() == name)) {
            return true;
        }
        if (NameLogic.whenParentIs(ModuleOpensDirective.class, name, (p, c) -> p.getName() == name)) {
            return true;
        }
        return NameLogic.whenParentIs(Name.class, name, (p, c) -> p.getQualifier().isPresent() && p.getQualifier().get() == name && NameLogic.isSyntacticallyAPackageName(p));
    }

    private static boolean isSyntacticallyATypeName(Node name) {
        if (NameLogic.whenParentIs(ModuleUsesDirective.class, name, (p, c) -> p.getName() == c)) {
            return true;
        }
        if (NameLogic.whenParentIs(ModuleProvidesDirective.class, name, (p, c) -> p.getName() == c)) {
            return true;
        }
        if (NameLogic.whenParentIs(ImportDeclaration.class, name, (p, c) -> !p.isStatic() && !p.isAsterisk() && p.getName() == name)) {
            return true;
        }
        if (NameLogic.whenParentIs(Name.class, name, (largerName, c) -> NameLogic.whenParentIs(ImportDeclaration.class, largerName, (importDecl, c2) -> importDecl.isStatic() && !importDecl.isAsterisk() && importDecl.getName() == c2))) {
            return true;
        }
        if (NameLogic.whenParentIs(ImportDeclaration.class, name, (importDecl, c2) -> importDecl.isStatic() && !importDecl.isAsterisk() && importDecl.getName() == c2)) {
            return true;
        }
        if (NameLogic.whenParentIs(ImportDeclaration.class, name, (p, c) -> p.isStatic() && p.isAsterisk() && p.getName() == name)) {
            return true;
        }
        if (NameLogic.whenParentIs(ConstructorDeclaration.class, name, (p, c) -> p.getName() == name)) {
            return true;
        }
        if (NameLogic.whenParentIs(AnnotationExpr.class, name, (p, c) -> p.getName() == name)) {
            return true;
        }
        if (NameLogic.whenParentIs(ClassExpr.class, name, (p, c) -> p.getType() == c)) {
            return true;
        }
        if (NameLogic.whenParentIs(ThisExpr.class, name, (ne, c2) -> ne.getTypeName().isPresent() && ne.getTypeName().get() == c2)) {
            return true;
        }
        if (NameLogic.whenParentIs(SuperExpr.class, name, (ne, c2) -> ne.getTypeName().isPresent() && ne.getTypeName().get() == c2)) {
            return true;
        }
        if (NameLogic.whenParentIs(ClassOrInterfaceDeclaration.class, name, (p, c) -> p.getExtendedTypes().contains((Object)c) || p.getImplementedTypes().contains((Object)c))) {
            return true;
        }
        if (NameLogic.whenParentIs(MethodDeclaration.class, name, (p, c) -> p.getType() == c)) {
            return true;
        }
        if (NameLogic.whenParentIs(AnnotationMemberDeclaration.class, name, (p, c) -> p.getType() == c)) {
            return true;
        }
        if (NameLogic.whenParentIs(MethodDeclaration.class, name, (p, c) -> p.getThrownExceptions().contains((Object)c))) {
            return true;
        }
        if (NameLogic.whenParentIs(ConstructorDeclaration.class, name, (p, c) -> p.getThrownExceptions().contains((Object)c))) {
            return true;
        }
        if (NameLogic.whenParentIs(VariableDeclarator.class, name, (p1, c1) -> p1.getType() == c1 && NameLogic.whenParentIs(FieldDeclaration.class, p1, (p2, c2) -> p2.getVariables().contains(c2)))) {
            return true;
        }
        if (NameLogic.whenParentIs(Parameter.class, name, (p, c) -> p.getType() == c)) {
            return true;
        }
        if (NameLogic.whenParentIs(ReceiverParameter.class, name, (p, c) -> p.getType() == c)) {
            return true;
        }
        if (NameLogic.whenParentIs(VariableDeclarator.class, name, (p1, c1) -> p1.getType() == c1 && NameLogic.whenParentIs(VariableDeclarationExpr.class, p1, (p2, c2) -> p2.getVariables().contains(c2)))) {
            return true;
        }
        if (NameLogic.whenParentIs(ClassOrInterfaceType.class, name, (p, c) -> p.getTypeArguments().isPresent() && ((NodeList)p.getTypeArguments().get()).contains((Object)c))) {
            return true;
        }
        if (NameLogic.whenParentIs(MethodCallExpr.class, name, (p, c) -> p.getTypeArguments().isPresent() && ((NodeList)p.getTypeArguments().get()).contains((Object)c))) {
            return true;
        }
        if (NameLogic.whenParentIs(ObjectCreationExpr.class, name, (p, c) -> p.getType() == c)) {
            return true;
        }
        if (NameLogic.whenParentIs(ArrayCreationExpr.class, name, (p, c) -> p.getElementType() == c)) {
            return true;
        }
        if (NameLogic.whenParentIs(CastExpr.class, name, (p, c) -> p.getType() == c)) {
            return true;
        }
        if (NameLogic.whenParentIs(InstanceOfExpr.class, name, (p, c) -> p.getType() == c)) {
            return true;
        }
        return NameLogic.whenParentIs(TypeExpr.class, name, (p1, c1) -> p1.getType() == c1 && NameLogic.whenParentIs(MethodReferenceExpr.class, p1, (p2, c2) -> p2.getScope() == c2));
    }

    private static boolean isSyntacticallyAnExpressionName(Node name) {
        if (NameLogic.whenParentIs(NameExpr.class, name, (nameExpr, c) -> nameExpr.getName() == c && NameLogic.whenParentIs(ExplicitConstructorInvocationStmt.class, nameExpr, (ne, c2) -> ne.getExpression().isPresent() && ne.getExpression().get() == c2))) {
            return true;
        }
        if (NameLogic.whenParentIs(ExplicitConstructorInvocationStmt.class, name, (ne, c2) -> ne.getExpression().isPresent() && ne.getExpression().get() == c2)) {
            return true;
        }
        if (NameLogic.whenParentIs(NameExpr.class, name, (nameExpr, c) -> nameExpr.getName() == c && NameLogic.whenParentIs(ObjectCreationExpr.class, nameExpr, (ne, c2) -> ne.getScope().isPresent() && ne.getScope().get() == c2))) {
            return true;
        }
        if (NameLogic.whenParentIs(ObjectCreationExpr.class, name, (ne, c2) -> ne.getScope().isPresent() && ne.getScope().get() == c2)) {
            return true;
        }
        if (NameLogic.whenParentIs(NameExpr.class, name, (nameExpr, c) -> nameExpr.getName() == c && NameLogic.whenParentIs(ArrayAccessExpr.class, nameExpr, (ne, c2) -> ne.getName() == c2))) {
            return true;
        }
        if (NameLogic.whenParentIs(ArrayAccessExpr.class, name, (ne, c2) -> ne.getName() == c2)) {
            return true;
        }
        if (NameLogic.whenParentIs(NameExpr.class, name, (nameExpr, c) -> nameExpr.getName() == c && NameLogic.whenParentIs(UnaryExpr.class, nameExpr, (ne, c2) -> ne.getExpression() == c2 && ne.isPostfix()))) {
            return true;
        }
        if (NameLogic.whenParentIs(UnaryExpr.class, name, (ne, c2) -> ne.getExpression() == c2 && ne.isPostfix())) {
            return true;
        }
        if (NameLogic.whenParentIs(NameExpr.class, name, (nameExpr, c) -> nameExpr.getName() == c && NameLogic.whenParentIs(AssignExpr.class, nameExpr, (ne, c2) -> ne.getTarget() == c2))) {
            return true;
        }
        if (NameLogic.whenParentIs(AssignExpr.class, name, (ne, c2) -> ne.getTarget() == c2)) {
            return true;
        }
        if (NameLogic.whenParentIs(NameExpr.class, name, (nameExpr, c) -> nameExpr.getName() == c && NameLogic.whenParentIs(TryStmt.class, nameExpr, (ne, c2) -> ne.getResources().contains(c2)))) {
            return true;
        }
        if (NameLogic.whenParentIs(NameExpr.class, name, (p1, c1) -> p1.getName() == c1 && NameLogic.whenParentIs(VariableDeclarator.class, p1, (p2, c2) -> p2.getInitializer().isPresent() && p2.getInitializer().get() == c2 && NameLogic.whenParentIs(VariableDeclarationExpr.class, p2, (p3, c3) -> p3.getVariables().contains(c3) && NameLogic.whenParentIs(TryStmt.class, p3, (p4, c4) -> p4.getResources().contains(c4)))))) {
            return true;
        }
        if (NameLogic.whenParentIs(TryStmt.class, name, (ne, c2) -> ne.getResources().contains((Object)c2))) {
            return true;
        }
        return NameLogic.whenParentIs(VariableDeclarator.class, name, (p2, c2) -> p2.getInitializer().isPresent() && p2.getInitializer().get() == c2 && NameLogic.whenParentIs(VariableDeclarationExpr.class, p2, (p3, c3) -> p3.getVariables().contains(c3) && NameLogic.whenParentIs(TryStmt.class, p3, (p4, c4) -> p4.getResources().contains(c4))));
    }

    public static String nameAsString(Node name) {
        if (!NameLogic.isAName(name)) {
            throw new IllegalArgumentException("A name was expected");
        }
        if (name instanceof Name) {
            return ((Name)name).asString();
        }
        if (name instanceof SimpleName) {
            return ((SimpleName)name).getIdentifier();
        }
        if (name instanceof ClassOrInterfaceType) {
            return ((ClassOrInterfaceType)name).asString();
        }
        if (name instanceof FieldAccessExpr) {
            FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)name;
            if (NameLogic.isAName((Node)fieldAccessExpr.getScope())) {
                return NameLogic.nameAsString((Node)fieldAccessExpr.getScope()) + "." + NameLogic.nameAsString((Node)fieldAccessExpr.getName());
            }
            throw new IllegalArgumentException();
        }
        if (name instanceof NameExpr) {
            return ((NameExpr)name).getNameAsString();
        }
        throw new UnsupportedOperationException("Unknown type of name found: " + name + " (" + name.getClass().getCanonicalName() + ")");
    }

    private static <P extends Node, C extends Node> boolean whenParentIs(Class<P> parentClass, C child) {
        return NameLogic.whenParentIs(parentClass, child, (p, c) -> true);
    }

    private static <P extends Node, C extends Node> boolean whenParentIs(Class<P> parentClass, C child, PredicateOnParentAndChild<P, C> predicate) {
        if (child.getParentNode().isPresent()) {
            Node parent = (Node)child.getParentNode().get();
            return parentClass.isInstance(parent) && predicate.isSatisfied((Node)parentClass.cast(parent), child);
        }
        return false;
    }

    private static interface PredicateOnParentAndChild<P extends Node, C extends Node> {
        public boolean isSatisfied(P var1, C var2);
    }
}

