/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javassistmodel;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParametrizable;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import com.github.javaparser.symbolsolver.javaparsermodel.LambdaArgumentTypePlaceholder;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFieldDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistInterfaceDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistMethodDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistTypeDeclarationAdapter;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import com.github.javaparser.symbolsolver.logic.AbstractClassDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.resolution.MethodResolutionLogic;
import com.github.javaparser.symbolsolver.resolution.SymbolSolver;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;

public class JavassistClassDeclaration
extends AbstractClassDeclaration
implements MethodUsageResolutionCapability {
    private CtClass ctClass;
    private TypeSolver typeSolver;
    private JavassistTypeDeclarationAdapter javassistTypeDeclarationAdapter;

    public JavassistClassDeclaration(CtClass ctClass, TypeSolver typeSolver) {
        if (ctClass == null) {
            throw new IllegalArgumentException();
        }
        if (ctClass.isInterface() || ctClass.isAnnotation() || ctClass.isPrimitive() || ctClass.isEnum()) {
            throw new IllegalArgumentException("Trying to instantiate a JavassistClassDeclaration with something which is not a class: " + ctClass.toString());
        }
        this.ctClass = ctClass;
        this.typeSolver = typeSolver;
        this.javassistTypeDeclarationAdapter = new JavassistTypeDeclarationAdapter(ctClass, typeSolver);
    }

    @Override
    protected ResolvedReferenceType object() {
        return new ReferenceTypeImpl(this.typeSolver.getSolvedJavaLangObject(), this.typeSolver);
    }

    public boolean hasDirectlyAnnotation(String canonicalName) {
        return this.ctClass.hasAnnotation(canonicalName);
    }

    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return this.javassistTypeDeclarationAdapter.getDeclaredMethods();
    }

    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        return this.isAssignableBy((ResolvedType)new ReferenceTypeImpl(other, this.typeSolver));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavassistClassDeclaration that = (JavassistClassDeclaration)o;
        return this.ctClass.equals(that.ctClass);
    }

    public int hashCode() {
        return this.ctClass.hashCode();
    }

    public String getPackageName() {
        return this.ctClass.getPackageName();
    }

    public String getClassName() {
        String className = this.ctClass.getName().replace('$', '.');
        if (this.getPackageName() != null) {
            return className.substring(this.getPackageName().length() + 1);
        }
        return className;
    }

    public String getQualifiedName() {
        return this.ctClass.getName().replace('$', '.');
    }

    @Override
    @Deprecated
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentsTypes, Context invokationContext, List<ResolvedType> typeParameterValues) {
        return JavassistUtils.getMethodUsage(this.ctClass, name, argumentsTypes, this.typeSolver, this.getTypeParameters(), typeParameterValues);
    }

    @Deprecated
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        String[] interfaceFQNs;
        for (CtField field : this.ctClass.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return SymbolReference.solved(new JavassistFieldDeclaration(field, typeSolver));
        }
        String superclassFQN = this.getSuperclassFQN();
        SymbolReference<? extends ResolvedValueDeclaration> ref = this.solveSymbolForFQN(name, superclassFQN);
        if (ref.isSolved()) {
            return ref;
        }
        for (String interfaceFQN : interfaceFQNs = this.getInterfaceFQNs()) {
            SymbolReference<? extends ResolvedValueDeclaration> interfaceRef = this.solveSymbolForFQN(name, interfaceFQN);
            if (!interfaceRef.isSolved()) continue;
            return interfaceRef;
        }
        return SymbolReference.unsolved(ResolvedValueDeclaration.class);
    }

    private SymbolReference<? extends ResolvedValueDeclaration> solveSymbolForFQN(String symbolName, String fqn) {
        if (fqn == null) {
            return SymbolReference.unsolved(ResolvedValueDeclaration.class);
        }
        ResolvedReferenceTypeDeclaration fqnTypeDeclaration = this.typeSolver.solveType(fqn);
        return new SymbolSolver(this.typeSolver).solveSymbolInType((ResolvedTypeDeclaration)fqnTypeDeclaration, symbolName);
    }

    private String[] getInterfaceFQNs() {
        return this.ctClass.getClassFile().getInterfaces();
    }

    private String getSuperclassFQN() {
        return this.ctClass.getClassFile().getSuperclass();
    }

    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        ArrayList<ResolvedReferenceType> ancestors;
        block5: {
            block4: {
                ancestors = new ArrayList<ResolvedReferenceType>();
                try {
                    this.getSuperClass().ifPresent(superClass -> ancestors.add((ResolvedReferenceType)superClass));
                }
                catch (UnsolvedSymbolException e) {
                    if (acceptIncompleteList) break block4;
                    throw e;
                }
            }
            try {
                ancestors.addAll(this.getInterfaces());
            }
            catch (UnsolvedSymbolException e) {
                if (acceptIncompleteList) break block5;
                throw e;
            }
        }
        return ancestors;
    }

    @Override
    @Deprecated
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        ArrayList<ResolvedMethodDeclaration> candidates = new ArrayList<ResolvedMethodDeclaration>();
        Predicate<CtMethod> staticOnlyCheck = m -> !staticOnly || staticOnly && Modifier.isStatic(m.getModifiers());
        for (CtMethod method : this.ctClass.getDeclaredMethods()) {
            boolean isNotBridge;
            boolean isSynthetic = method.getMethodInfo().getAttribute("Synthetic") != null;
            boolean bl = isNotBridge = (method.getMethodInfo().getAccessFlags() & 0x40) == 0;
            if (!method.getName().equals(name) || isSynthetic || !isNotBridge || !staticOnlyCheck.test(method)) continue;
            JavassistMethodDeclaration candidate = new JavassistMethodDeclaration(method, this.typeSolver);
            candidates.add(candidate);
            if (!argumentsTypes.isEmpty() || candidate.getNumberOfParams() != 0) continue;
            return SymbolReference.solved(candidate);
        }
        this.getSuperClass().flatMap(ResolvedReferenceType::getTypeDeclaration).ifPresent(superclassTypeDeclaration -> {
            SymbolReference<ResolvedMethodDeclaration> superClassMethodRef = MethodResolutionLogic.solveMethodInType((ResolvedTypeDeclaration)superclassTypeDeclaration, name, argumentsTypes, staticOnly);
            if (superClassMethodRef.isSolved()) {
                candidates.add(superClassMethodRef.getCorrespondingDeclaration());
            }
        });
        for (ResolvedReferenceType interfaceRef : this.getInterfaces()) {
            SymbolReference<ResolvedMethodDeclaration> interfaceMethodRef;
            if (!interfaceRef.getTypeDeclaration().isPresent() || !(interfaceMethodRef = MethodResolutionLogic.solveMethodInType((ResolvedTypeDeclaration)interfaceRef.getTypeDeclaration().get(), name, argumentsTypes, staticOnly)).isSolved()) continue;
            candidates.add(interfaceMethodRef.getCorrespondingDeclaration());
        }
        return MethodResolutionLogic.findMostApplicable(candidates, name, argumentsTypes, this.typeSolver);
    }

    public ResolvedType getUsage(Node node) {
        return new ReferenceTypeImpl(this, this.typeSolver);
    }

    public boolean isAssignableBy(ResolvedType type) {
        if (type.isNull()) {
            return true;
        }
        if (type instanceof LambdaArgumentTypePlaceholder) {
            return this.isFunctionalInterface();
        }
        if (type.describe().equals(this.getQualifiedName())) {
            return true;
        }
        try {
            if (this.ctClass.getSuperclass() != null && new JavassistClassDeclaration(this.ctClass.getSuperclass(), this.typeSolver).isAssignableBy(type)) {
                return true;
            }
            for (CtClass interfaze : this.ctClass.getInterfaces()) {
                if (!new JavassistInterfaceDeclaration(interfaze, this.typeSolver).isAssignableBy(type)) continue;
                return true;
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public boolean isTypeParameter() {
        return false;
    }

    public List<ResolvedFieldDeclaration> getAllFields() {
        return this.javassistTypeDeclarationAdapter.getDeclaredFields();
    }

    public String getName() {
        String[] nameElements = this.ctClass.getSimpleName().replace('$', '.').split("\\.");
        return nameElements[nameElements.length - 1];
    }

    public boolean isField() {
        return false;
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isType() {
        return true;
    }

    public boolean isClass() {
        return !this.ctClass.isInterface();
    }

    public Optional<ResolvedReferenceType> getSuperClass() {
        try {
            if ("java.lang.Object".equals(this.ctClass.getClassFile().getName())) {
                return Optional.empty();
            }
            if (this.ctClass.getGenericSignature() == null) {
                return Optional.of(new ReferenceTypeImpl(this.typeSolver.solveType(JavassistUtils.internalNameToCanonicalName(this.ctClass.getClassFile().getSuperclass())), this.typeSolver));
            }
            SignatureAttribute.ClassSignature classSignature = SignatureAttribute.toClassSignature((String)this.ctClass.getGenericSignature());
            return Optional.ofNullable(JavassistUtils.signatureTypeToType((SignatureAttribute.Type)classSignature.getSuperClass(), this.typeSolver, (ResolvedTypeParametrizable)this).asReferenceType());
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
    }

    public List<ResolvedReferenceType> getInterfaces() {
        try {
            if (this.ctClass.getGenericSignature() == null) {
                return Arrays.stream(this.ctClass.getClassFile().getInterfaces()).map(i -> this.typeSolver.solveType(JavassistUtils.internalNameToCanonicalName(i))).map(i -> new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)i, this.typeSolver)).collect(Collectors.toList());
            }
            SignatureAttribute.ClassSignature classSignature = SignatureAttribute.toClassSignature((String)this.ctClass.getGenericSignature());
            return Arrays.stream(classSignature.getInterfaces()).map(i -> JavassistUtils.signatureTypeToType((SignatureAttribute.Type)i, this.typeSolver, (ResolvedTypeParametrizable)this).asReferenceType()).collect(Collectors.toList());
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isInterface() {
        return this.ctClass.isInterface();
    }

    public String toString() {
        return "JavassistClassDeclaration {" + this.ctClass.getName() + '}';
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return this.javassistTypeDeclarationAdapter.getTypeParameters();
    }

    public AccessSpecifier accessSpecifier() {
        return JavassistFactory.modifiersToAccessLevel(this.ctClass.getModifiers());
    }

    public List<ResolvedConstructorDeclaration> getConstructors() {
        return this.javassistTypeDeclarationAdapter.getConstructors();
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return this.javassistTypeDeclarationAdapter.containerType();
    }

    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        try {
            return Arrays.stream(this.ctClass.getDeclaredClasses()).map(itype -> JavassistFactory.toTypeDeclaration(itype, this.typeSolver)).collect(Collectors.toSet());
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ResolvedReferenceTypeDeclaration getInternalType(String name) {
        Optional<ResolvedReferenceTypeDeclaration> type = this.internalTypes().stream().filter(f -> f.getName().endsWith(name)).findFirst();
        return type.orElseThrow(() -> new UnsolvedSymbolException("Internal type not found: " + name));
    }

    public boolean hasInternalType(String name) {
        return this.internalTypes().stream().anyMatch(f -> f.getName().endsWith(name));
    }

    public Optional<Node> toAst() {
        return Optional.empty();
    }
}

