/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.javaparser.Navigator;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.resolution.Value;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.resolution.SymbolDeclarator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

public abstract class AbstractJavaParserContext<N extends Node>
implements Context {
    protected N wrappedNode;
    protected TypeSolver typeSolver;

    public static SymbolReference<ResolvedValueDeclaration> solveWith(SymbolDeclarator symbolDeclarator, String name) {
        for (ResolvedValueDeclaration decl : symbolDeclarator.getSymbolDeclarations()) {
            if (!decl.getName().equals(name)) continue;
            return SymbolReference.solved(decl);
        }
        return SymbolReference.unsolved(ResolvedValueDeclaration.class);
    }

    public AbstractJavaParserContext(N wrappedNode, TypeSolver typeSolver) {
        if (wrappedNode == null) {
            throw new NullPointerException();
        }
        this.wrappedNode = wrappedNode;
        this.typeSolver = typeSolver;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractJavaParserContext that = (AbstractJavaParserContext)o;
        return this.wrappedNode != null ? this.wrappedNode.equals(that.wrappedNode) : that.wrappedNode == null;
    }

    public int hashCode() {
        return this.wrappedNode != null ? this.wrappedNode.hashCode() : 0;
    }

    @Override
    public Optional<ResolvedType> solveGenericType(String name) {
        Optional<Context> optionalParent = this.getParent();
        if (!optionalParent.isPresent()) {
            return Optional.empty();
        }
        return optionalParent.get().solveGenericType(name);
    }

    @Override
    public final Optional<Context> getParent() {
        Node parent = this.wrappedNode.getParentNode().orElse(null);
        if (parent instanceof MethodCallExpr) {
            MethodCallExpr parentCall = (MethodCallExpr)parent;
            boolean found = false;
            if (parentCall.getArguments() != null) {
                for (Expression expression : parentCall.getArguments()) {
                    if (expression != this.wrappedNode) continue;
                    found = true;
                    break;
                }
            }
            if (found) {
                Node notMethod = parent;
                while (notMethod instanceof MethodCallExpr) {
                    notMethod = Navigator.demandParentNode(notMethod);
                }
                return Optional.of(JavaParserFactory.getContext(notMethod, this.typeSolver));
            }
        }
        Node notMethod = parent;
        while (notMethod instanceof MethodCallExpr || notMethod instanceof FieldAccessExpr) {
            notMethod = notMethod.getParentNode().orElse(null);
        }
        if (notMethod == null) {
            return Optional.empty();
        }
        return Optional.of(JavaParserFactory.getContext(notMethod, this.typeSolver));
    }

    protected Optional<Value> solveWithAsValue(SymbolDeclarator symbolDeclarator, String name) {
        return symbolDeclarator.getSymbolDeclarations().stream().filter(d -> d.getName().equals(name)).map(Value::from).findFirst();
    }

    protected Collection<ResolvedReferenceTypeDeclaration> findTypeDeclarations(Optional<Expression> optScope) {
        if (optScope.isPresent()) {
            ResolvedType typeOfScope;
            NameExpr scopeAsName;
            SymbolReference<ResolvedTypeDeclaration> symbolReference;
            Expression scope = optScope.get();
            if (scope instanceof NameExpr && (symbolReference = this.solveType((scopeAsName = scope.asNameExpr()).getName().getId())).isSolved() && symbolReference.getCorrespondingDeclaration().isType()) {
                return Collections.singletonList(symbolReference.getCorrespondingDeclaration().asReferenceType());
            }
            try {
                typeOfScope = JavaParserFacade.get(this.typeSolver).getType((Node)scope);
            }
            catch (Exception e) {
                FieldAccessExpr scopeName;
                if (scope instanceof FieldAccessExpr && this.solveType((scopeName = (FieldAccessExpr)scope).toString()).isSolved()) {
                    return Collections.emptyList();
                }
                throw new UnsolvedSymbolException(scope.toString(), this.wrappedNode.toString(), (Throwable)e);
            }
            if (typeOfScope.isWildcard()) {
                if (typeOfScope.asWildcard().isExtends() || typeOfScope.asWildcard().isSuper()) {
                    return Collections.singletonList(typeOfScope.asWildcard().getBoundedType().asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty.")));
                }
                return Collections.singletonList(new ReflectionClassDeclaration(Object.class, this.typeSolver).asReferenceType());
            }
            if (typeOfScope.isArray()) {
                return Collections.singletonList(new ReflectionClassDeclaration(Object.class, this.typeSolver).asReferenceType());
            }
            if (typeOfScope.isTypeVariable()) {
                ArrayList<ResolvedReferenceTypeDeclaration> result = new ArrayList<ResolvedReferenceTypeDeclaration>();
                for (ResolvedTypeParameterDeclaration.Bound bound : typeOfScope.asTypeParameter().getBounds()) {
                    result.add((ResolvedReferenceTypeDeclaration)bound.getType().asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty.")));
                }
                return result;
            }
            if (typeOfScope.isConstraint()) {
                return Collections.singletonList(typeOfScope.asConstraintType().getBound().asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty.")));
            }
            if (typeOfScope.isUnionType()) {
                return typeOfScope.asUnionType().getCommonAncestor().flatMap(ResolvedReferenceType::getTypeDeclaration).map(Collections::singletonList).orElseThrow(() -> new UnsolvedSymbolException("No common ancestor available for UnionType" + typeOfScope.describe()));
            }
            return Collections.singletonList(typeOfScope.asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty.")));
        }
        ResolvedType typeOfScope = JavaParserFacade.get(this.typeSolver).getTypeOfThisIn((Node)this.wrappedNode);
        return Collections.singletonList(typeOfScope.asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty.")));
    }

    public N getWrappedNode() {
        return this.wrappedNode;
    }
}

