/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javassistmodel;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParametrizable;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.core.resolution.TypeVariableResolutionCapability;
import com.github.javaparser.symbolsolver.declarations.common.MethodDeclarationCommonLogic;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistClassDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistEnumDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistInterfaceDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistParameterDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistTypeParameter;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javassist.CtBehavior;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;

public class JavassistMethodDeclaration
implements ResolvedMethodDeclaration,
TypeVariableResolutionCapability {
    private CtMethod ctMethod;
    private TypeSolver typeSolver;

    public JavassistMethodDeclaration(CtMethod ctMethod, TypeSolver typeSolver) {
        this.ctMethod = ctMethod;
        this.typeSolver = typeSolver;
    }

    public boolean isDefaultMethod() {
        return this.ctMethod.getDeclaringClass().isInterface() && !this.isAbstract();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.ctMethod.getModifiers());
    }

    public String toString() {
        return "JavassistMethodDeclaration{ctMethod=" + this.ctMethod + '}';
    }

    public String getName() {
        return this.ctMethod.getName();
    }

    public boolean isField() {
        return false;
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isType() {
        return false;
    }

    public ResolvedReferenceTypeDeclaration declaringType() {
        if (this.ctMethod.getDeclaringClass().isInterface()) {
            return new JavassistInterfaceDeclaration(this.ctMethod.getDeclaringClass(), this.typeSolver);
        }
        if (this.ctMethod.getDeclaringClass().isEnum()) {
            return new JavassistEnumDeclaration(this.ctMethod.getDeclaringClass(), this.typeSolver);
        }
        return new JavassistClassDeclaration(this.ctMethod.getDeclaringClass(), this.typeSolver);
    }

    public ResolvedType getReturnType() {
        try {
            if (this.ctMethod.getGenericSignature() != null) {
                SignatureAttribute.Type genericSignatureType = SignatureAttribute.toMethodSignature((String)this.ctMethod.getGenericSignature()).getReturnType();
                return JavassistUtils.signatureTypeToType(genericSignatureType, this.typeSolver, (ResolvedTypeParametrizable)this);
            }
            try {
                return JavassistFactory.typeUsageFor(this.ctMethod.getReturnType(), this.typeSolver);
            }
            catch (NotFoundException e) {
                String returnTypeClassRefPath = this.toClassRefPath(this.ctMethod.getMethodInfo());
                ResolvedReferenceTypeDeclaration typeDeclaration = this.typeSolver.solveType(returnTypeClassRefPath);
                return new ReferenceTypeImpl(typeDeclaration, this.typeSolver);
            }
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
    }

    public int getNumberOfParams() {
        try {
            return this.ctMethod.getParameterTypes().length;
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ResolvedParameterDeclaration getParam(int i) {
        try {
            boolean variadic = false;
            if ((this.ctMethod.getModifiers() & 0x80) > 0) {
                variadic = i == this.ctMethod.getParameterTypes().length - 1;
            }
            Optional<String> paramName = JavassistUtils.extractParameterName((CtBehavior)this.ctMethod, i);
            String signature = this.ctMethod.getGenericSignature() == null ? this.ctMethod.getSignature() : this.ctMethod.getGenericSignature();
            SignatureAttribute.MethodSignature methodSignature = SignatureAttribute.toMethodSignature((String)signature);
            SignatureAttribute.Type signatureType = methodSignature.getParameterTypes()[i];
            return new JavassistParameterDeclaration(JavassistUtils.signatureTypeToType(signatureType, this.typeSolver, (ResolvedTypeParametrizable)this), this.typeSolver, variadic, (String)paramName.orElse(null));
        }
        catch (NotFoundException | BadBytecode e) {
            throw new RuntimeException(e);
        }
    }

    public MethodUsage getUsage(Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MethodUsage resolveTypeVariables(Context context, List<ResolvedType> parameterTypes) {
        return new MethodDeclarationCommonLogic(this, this.typeSolver).resolveTypeVariables(context, parameterTypes);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.ctMethod.getModifiers());
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        try {
            if (this.ctMethod.getGenericSignature() == null) {
                return new ArrayList<ResolvedTypeParameterDeclaration>();
            }
            SignatureAttribute.MethodSignature methodSignature = SignatureAttribute.toMethodSignature((String)this.ctMethod.getGenericSignature());
            return Arrays.stream(methodSignature.getTypeParameters()).map(jasTp -> new JavassistTypeParameter((SignatureAttribute.TypeParameter)jasTp, (ResolvedTypeParametrizable)this, this.typeSolver)).collect(Collectors.toList());
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
    }

    public AccessSpecifier accessSpecifier() {
        return JavassistFactory.modifiersToAccessLevel(this.ctMethod.getModifiers());
    }

    public int getNumberOfSpecifiedExceptions() {
        try {
            return this.ctMethod.getExceptionTypes().length;
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ResolvedType getSpecifiedException(int index) {
        if (index < 0 || index >= this.getNumberOfSpecifiedExceptions()) {
            throw new IllegalArgumentException(String.format("No exception with index %d. Number of exceptions: %d", index, this.getNumberOfSpecifiedExceptions()));
        }
        try {
            return JavassistFactory.typeUsageFor(this.ctMethod.getExceptionTypes()[index], this.typeSolver);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<MethodDeclaration> toAst() {
        return Optional.empty();
    }

    private String toClassRefPath(MethodInfo methodInfo) {
        String desc = methodInfo.getDescriptor();
        int i = desc.indexOf(41);
        String classRefPath = null;
        if (i < 0) {
            throw new RuntimeException("parse descriptor error:" + desc);
        }
        char c = desc.charAt(++i);
        int arrayDim = 0;
        while (c == '[') {
            ++arrayDim;
            c = desc.charAt(++i);
        }
        if (c == 'L') {
            int i2 = desc.indexOf(59, ++i);
            classRefPath = desc.substring(i, i2++).replace('/', '.');
        }
        if (arrayDim > 0) {
            StringBuffer sbuf = new StringBuffer(classRefPath);
            while (arrayDim-- > 0) {
                sbuf.append("[]");
            }
            classRefPath = sbuf.toString();
        }
        return classRefPath;
    }
}

