/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.reflectionmodel;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import com.github.javaparser.symbolsolver.javaparsermodel.LambdaArgumentTypePlaceholder;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.ContextHelper;
import com.github.javaparser.symbolsolver.logic.AbstractClassDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassAdapter;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFieldDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionInterfaceDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionMethodDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.comparators.MethodComparator;
import com.github.javaparser.symbolsolver.resolution.MethodResolutionLogic;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ReflectionClassDeclaration
extends AbstractClassDeclaration
implements MethodUsageResolutionCapability {
    private Class<?> clazz;
    private TypeSolver typeSolver;
    private ReflectionClassAdapter reflectionClassAdapter;

    public ReflectionClassDeclaration(Class<?> clazz, TypeSolver typeSolver) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class should not be null");
        }
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Class should not be an interface");
        }
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("Class should not represent a primitive class");
        }
        if (clazz.isArray()) {
            throw new IllegalArgumentException("Class should not be an array");
        }
        if (clazz.isEnum()) {
            throw new IllegalArgumentException("Class should not be an enum");
        }
        this.clazz = clazz;
        this.typeSolver = typeSolver;
        this.reflectionClassAdapter = new ReflectionClassAdapter(clazz, typeSolver, this);
    }

    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return this.reflectionClassAdapter.getDeclaredMethods();
    }

    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        return this.reflectionClassAdapter.getAncestors();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReflectionClassDeclaration that = (ReflectionClassDeclaration)o;
        return this.clazz.getCanonicalName().equals(that.clazz.getCanonicalName());
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public String getPackageName() {
        if (this.clazz.getPackage() != null) {
            return this.clazz.getPackage().getName();
        }
        return null;
    }

    public String getClassName() {
        String canonicalName = this.clazz.getCanonicalName();
        if (canonicalName != null && this.getPackageName() != null) {
            return canonicalName.substring(this.getPackageName().length() + 1, canonicalName.length());
        }
        return null;
    }

    public String getQualifiedName() {
        return this.clazz.getCanonicalName();
    }

    @Override
    @Deprecated
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        Predicate<Method> staticFilter = m -> !staticOnly || staticOnly && Modifier.isStatic(m.getModifiers());
        ArrayList<ResolvedMethodDeclaration> candidateSolvedMethods = new ArrayList<ResolvedMethodDeclaration>();
        List methods = Arrays.stream(this.clazz.getDeclaredMethods()).filter(m -> m.getName().equals(name)).filter(staticFilter).filter(method -> !method.isBridge()).filter(method -> !method.isSynthetic()).sorted(new MethodComparator()).collect(Collectors.toList());
        for (Method method2 : methods) {
            ReflectionMethodDeclaration methodDeclaration = new ReflectionMethodDeclaration(method2, this.typeSolver);
            candidateSolvedMethods.add(methodDeclaration);
            if (!argumentsTypes.isEmpty() || methodDeclaration.getNumberOfParams() != 0) continue;
            return SymbolReference.solved(methodDeclaration);
        }
        this.getSuperClass().flatMap(ResolvedReferenceType::getTypeDeclaration).ifPresent(superClassTypeDeclaration -> {
            SymbolReference<ResolvedMethodDeclaration> ref = MethodResolutionLogic.solveMethodInType((ResolvedTypeDeclaration)superClassTypeDeclaration, name, argumentsTypes, staticOnly);
            if (ref.isSolved()) {
                candidateSolvedMethods.add(ref.getCorrespondingDeclaration());
            }
        });
        for (ResolvedReferenceType interfaceDeclaration : this.getInterfaces()) {
            interfaceDeclaration.getTypeDeclaration().ifPresent(interfaceTypeDeclaration -> {
                SymbolReference<ResolvedMethodDeclaration> ref = MethodResolutionLogic.solveMethodInType((ResolvedTypeDeclaration)interfaceTypeDeclaration, name, argumentsTypes, staticOnly);
                if (ref.isSolved()) {
                    candidateSolvedMethods.add(ref.getCorrespondingDeclaration());
                }
            });
        }
        if (candidateSolvedMethods.isEmpty()) {
            return SymbolReference.unsolved(ResolvedMethodDeclaration.class);
        }
        return MethodResolutionLogic.findMostApplicable(candidateSolvedMethods, name, argumentsTypes, this.typeSolver);
    }

    public String toString() {
        return "ReflectionClassDeclaration{clazz=" + this.getId() + '}';
    }

    public ResolvedType getUsage(Node node) {
        return new ReferenceTypeImpl(this, this.typeSolver);
    }

    @Override
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentsTypes, Context invokationContext, List<ResolvedType> typeParameterValues) {
        ArrayList<MethodUsage> methodUsages = new ArrayList<MethodUsage>();
        List allMethods = Arrays.stream(this.clazz.getDeclaredMethods()).filter(m -> m.getName().equals(name)).sorted(new MethodComparator()).collect(Collectors.toList());
        for (Method method : allMethods) {
            if (method.isBridge() || method.isSynthetic()) continue;
            ReflectionMethodDeclaration methodDeclaration = new ReflectionMethodDeclaration(method, this.typeSolver);
            MethodUsage methodUsage = new MethodUsage((ResolvedMethodDeclaration)methodDeclaration);
            for (int i = 0; i < this.getTypeParameters().size() && i < typeParameterValues.size(); ++i) {
                ResolvedTypeParameterDeclaration tpToReplace = this.getTypeParameters().get(i);
                ResolvedType newValue = typeParameterValues.get(i);
                methodUsage = methodUsage.replaceTypeParameter(tpToReplace, newValue);
            }
            methodUsages.add(methodUsage);
            if (!argumentsTypes.isEmpty() || methodUsage.getNoParams() != 0) continue;
            return Optional.of(methodUsage);
        }
        this.getSuperClass().ifPresent(superClass -> superClass.getTypeDeclaration().ifPresent(superClassTypeDeclaration -> ContextHelper.solveMethodAsUsage((ResolvedTypeDeclaration)superClassTypeDeclaration, name, argumentsTypes, invokationContext, typeParameterValues).ifPresent(methodUsages::add)));
        for (ResolvedReferenceType interfaceDeclaration : this.getInterfaces()) {
            interfaceDeclaration.getTypeDeclaration().flatMap(superClassTypeDeclaration -> interfaceDeclaration.getTypeDeclaration()).flatMap(interfaceTypeDeclaration -> ContextHelper.solveMethodAsUsage((ResolvedTypeDeclaration)interfaceTypeDeclaration, name, argumentsTypes, invokationContext, typeParameterValues)).ifPresent(methodUsages::add);
        }
        Optional<MethodUsage> ref = MethodResolutionLogic.findMostApplicableUsage(methodUsages, name, argumentsTypes, this.typeSolver);
        return ref;
    }

    public boolean canBeAssignedTo(ResolvedReferenceTypeDeclaration other) {
        if (other instanceof LambdaArgumentTypePlaceholder) {
            return this.isFunctionalInterface();
        }
        if (other.getQualifiedName().equals(this.getQualifiedName())) {
            return true;
        }
        if (this.clazz.getSuperclass() != null && new ReflectionClassDeclaration(this.clazz.getSuperclass(), this.typeSolver).canBeAssignedTo(other)) {
            return true;
        }
        for (Class<?> interfaze : this.clazz.getInterfaces()) {
            if (!new ReflectionInterfaceDeclaration(interfaze, this.typeSolver).canBeAssignedTo(other)) continue;
            return true;
        }
        return false;
    }

    public boolean isAssignableBy(ResolvedType type) {
        return this.reflectionClassAdapter.isAssignableBy(type);
    }

    public boolean isTypeParameter() {
        return false;
    }

    public ResolvedFieldDeclaration getField(String name) {
        return this.reflectionClassAdapter.getField(name);
    }

    public List<ResolvedFieldDeclaration> getAllFields() {
        return this.reflectionClassAdapter.getAllFields();
    }

    @Deprecated
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        for (Field field : this.clazz.getFields()) {
            if (!field.getName().equals(name)) continue;
            return SymbolReference.solved(new ReflectionFieldDeclaration(field, typeSolver));
        }
        return SymbolReference.unsolved(ResolvedValueDeclaration.class);
    }

    public boolean hasDirectlyAnnotation(String canonicalName) {
        return this.reflectionClassAdapter.hasDirectlyAnnotation(canonicalName);
    }

    public boolean hasField(String name) {
        return this.reflectionClassAdapter.hasField(name);
    }

    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        return this.isAssignableBy((ResolvedType)new ReferenceTypeImpl(other, this.typeSolver));
    }

    public String getName() {
        return this.clazz.getSimpleName();
    }

    public boolean isField() {
        return false;
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isType() {
        return true;
    }

    public boolean isClass() {
        return !this.clazz.isInterface();
    }

    public Optional<ResolvedReferenceType> getSuperClass() {
        if (!this.reflectionClassAdapter.getSuperClass().isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.reflectionClassAdapter.getSuperClass().get());
    }

    public List<ResolvedReferenceType> getInterfaces() {
        return this.reflectionClassAdapter.getInterfaces();
    }

    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return this.reflectionClassAdapter.getTypeParameters();
    }

    public AccessSpecifier accessSpecifier() {
        return ReflectionFactory.modifiersToAccessLevel(this.clazz.getModifiers());
    }

    public List<ResolvedConstructorDeclaration> getConstructors() {
        return this.reflectionClassAdapter.getConstructors();
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return this.reflectionClassAdapter.containerType();
    }

    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        return Arrays.stream(this.clazz.getDeclaredClasses()).map(ic -> ReflectionFactory.typeDeclarationFor(ic, this.typeSolver)).collect(Collectors.toSet());
    }

    public Optional<Node> toAst() {
        return Optional.empty();
    }

    @Override
    protected ResolvedReferenceType object() {
        return new ReferenceTypeImpl(this.typeSolver.getSolvedJavaLangObject(), this.typeSolver);
    }
}

