/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typesolvers;

import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CombinedTypeSolver
implements TypeSolver {
    private TypeSolver parent;
    private List<TypeSolver> elements = new ArrayList<TypeSolver>();
    private Predicate<Exception> exceptionHandler;

    public CombinedTypeSolver(TypeSolver ... elements) {
        this(ExceptionHandlers.IGNORE_NONE, elements);
    }

    public CombinedTypeSolver(Predicate<Exception> exceptionHandler, TypeSolver ... elements) {
        this.setExceptionHandler(exceptionHandler);
        for (TypeSolver el : elements) {
            this.add(el);
        }
    }

    public void setExceptionHandler(Predicate<Exception> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public TypeSolver getParent() {
        return this.parent;
    }

    public void setParent(TypeSolver parent) {
        Objects.requireNonNull(parent);
        if (this.parent != null) {
            throw new IllegalStateException("This TypeSolver already has a parent.");
        }
        if (parent == this) {
            throw new IllegalStateException("The parent of this TypeSolver cannot be itself.");
        }
        this.parent = parent;
    }

    public void add(TypeSolver typeSolver) {
        this.elements.add(typeSolver);
        typeSolver.setParent((TypeSolver)this);
    }

    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
        for (TypeSolver ts : this.elements) {
            try {
                SymbolReference res = ts.tryToSolveType(name);
                if (!res.isSolved()) continue;
                return res;
            }
            catch (Exception e) {
                if (this.exceptionHandler.test(e)) continue;
                throw e;
            }
        }
        return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
    }

    public ResolvedReferenceTypeDeclaration solveType(String name) throws UnsolvedSymbolException {
        SymbolReference<ResolvedReferenceTypeDeclaration> res = this.tryToSolveType(name);
        if (res.isSolved()) {
            return (ResolvedReferenceTypeDeclaration)res.getCorrespondingDeclaration();
        }
        throw new UnsolvedSymbolException(name);
    }

    public static class ExceptionHandlers {
        public static final Predicate<Exception> IGNORE_NONE = e -> false;
        public static final Predicate<Exception> IGNORE_ALL = e -> true;
        public static final Predicate<Exception> IGNORE_UNSUPPORTED_OPERATION = ExceptionHandlers.getTypeBasedWhitelist(UnsupportedOperationException.class);
        public static final Predicate<Exception> IGNORE_UNSOLVED_SYMBOL = ExceptionHandlers.getTypeBasedWhitelist(UnsolvedSymbolException.class);
        public static final Predicate<Exception> IGNORE_UNSUPPORTED_AND_UNSOLVED = ExceptionHandlers.getTypeBasedWhitelist(UnsupportedOperationException.class, UnsolvedSymbolException.class);

        public static Predicate<Exception> getTypeBasedBlacklist(Class<? extends Exception> ... blacklist) {
            return e -> {
                for (Class clazz : blacklist) {
                    if (!clazz.isAssignableFrom(e.getClass())) continue;
                    return false;
                }
                return true;
            };
        }

        public static Predicate<Exception> getTypeBasedWhitelist(Class<? extends Exception> ... whitelist) {
            return e -> {
                for (Class clazz : whitelist) {
                    if (!clazz.isAssignableFrom(e.getClass())) continue;
                    return true;
                }
                return false;
            };
        }
    }
}

