/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver;

import com.github.javaparser.Position;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.SwitchEntry;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparser.Navigator;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class SourceFileInfoExtractor {
    private final TypeSolver typeSolver;
    private int successes = 0;
    private int failures = 0;
    private int unsupported = 0;
    private boolean printFileName = true;
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private boolean verbose = false;

    public SourceFileInfoExtractor(TypeSolver typeSolver) {
        this.typeSolver = typeSolver;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setPrintFileName(boolean printFileName) {
        this.printFileName = printFileName;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setErr(PrintStream err) {
        this.err = err;
    }

    public int getSuccesses() {
        return this.successes;
    }

    public int getUnsupported() {
        return this.unsupported;
    }

    public int getFailures() {
        return this.failures;
    }

    private void solveTypeDecl(ClassOrInterfaceDeclaration node) {
        ResolvedReferenceTypeDeclaration typeDeclaration = JavaParserFacade.get(this.typeSolver).getTypeDeclaration(node);
        if (typeDeclaration.isClass()) {
            this.out.println("\n[ Class " + typeDeclaration.getQualifiedName() + " ]");
            for (ResolvedReferenceType sc : typeDeclaration.asClass().getAllSuperClasses()) {
                this.out.println("  superclass: " + sc.getQualifiedName());
            }
            for (ResolvedReferenceType sc : typeDeclaration.asClass().getAllInterfaces()) {
                this.out.println("  interface: " + sc.getQualifiedName());
            }
        }
    }

    private void solve(Node node) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            this.solveTypeDecl((ClassOrInterfaceDeclaration)node);
        } else if (node instanceof Expression) {
            Node parentNode = Navigator.requireParentNode(node);
            if (parentNode instanceof ImportDeclaration || parentNode instanceof Expression || parentNode instanceof MethodDeclaration || parentNode instanceof PackageDeclaration) {
                return;
            }
            if (parentNode instanceof Statement || parentNode instanceof VariableDeclarator || parentNode instanceof SwitchEntry) {
                try {
                    ResolvedType ref = JavaParserFacade.get(this.typeSolver).getType(node);
                    this.out.println("  Line " + this.lineNr(node) + ") " + node + " ==> " + ref.describe());
                    ++this.successes;
                }
                catch (UnsupportedOperationException upe) {
                    ++this.unsupported;
                    this.err.println(upe.getMessage());
                    throw upe;
                }
                catch (RuntimeException re) {
                    ++this.failures;
                    this.err.println(re.getMessage());
                    throw re;
                }
            }
        }
    }

    private void solveMethodCalls(Node node) {
        if (node instanceof MethodCallExpr) {
            this.out.println("  Line " + this.lineNr(node) + ") " + node + " ==> " + this.toString((MethodCallExpr)node));
        }
        for (Node child : node.getChildNodes()) {
            this.solveMethodCalls(child);
        }
    }

    private String toString(MethodCallExpr node) {
        try {
            return this.toString(JavaParserFacade.get(this.typeSolver).solve(node));
        }
        catch (Exception e) {
            if (this.verbose) {
                System.err.println("Error resolving call at L" + this.lineNr((Node)node) + ": " + node);
                e.printStackTrace();
            }
            return "ERROR";
        }
    }

    private String toString(SymbolReference<ResolvedMethodDeclaration> methodDeclarationSymbolReference) {
        if (methodDeclarationSymbolReference.isSolved()) {
            return ((ResolvedMethodDeclaration)methodDeclarationSymbolReference.getCorrespondingDeclaration()).getQualifiedSignature();
        }
        return "UNSOLVED";
    }

    private List<Node> collectAllNodes(Node node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        node.walk(nodes::add);
        nodes.sort(Comparator.comparing(n -> (Position)n.getBegin().get()));
        return nodes;
    }

    public void solve(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().endsWith(".java")) {
                    if (SourceFileInfoExtractor.this.printFileName) {
                        SourceFileInfoExtractor.this.out.println("- parsing " + file.toAbsolutePath());
                    }
                    CompilationUnit cu = StaticJavaParser.parse((Path)file);
                    List nodes = SourceFileInfoExtractor.this.collectAllNodes((Node)cu);
                    nodes.forEach(n -> SourceFileInfoExtractor.this.solve(n));
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void solveMethodCalls(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().endsWith(".java")) {
                    if (SourceFileInfoExtractor.this.printFileName) {
                        SourceFileInfoExtractor.this.out.println("- parsing " + file.toAbsolutePath());
                    }
                    CompilationUnit cu = StaticJavaParser.parse((Path)file);
                    SourceFileInfoExtractor.this.solveMethodCalls((Node)cu);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private int lineNr(Node node) {
        return node.getRange().map(range -> range.begin.line).orElseThrow(IllegalStateException::new);
    }
}

