/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.AbstractJavaParserContext;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserAnonymousClassDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeParameter;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.resolution.MethodResolutionLogic;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class AnonymousClassDeclarationContext
extends AbstractJavaParserContext<ObjectCreationExpr> {
    private final JavaParserAnonymousClassDeclaration myDeclaration;

    public AnonymousClassDeclarationContext(ObjectCreationExpr node, TypeSolver typeSolver) {
        super(node, typeSolver);
        this.myDeclaration = new JavaParserAnonymousClassDeclaration((ObjectCreationExpr)this.wrappedNode, this.typeSolver);
        Preconditions.checkArgument((boolean)node.getAnonymousClassBody().isPresent(), (Object)"An anonymous class must have a body");
    }

    @Override
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        SymbolReference<ResolvedMethodDeclaration> res;
        SymbolReference<ResolvedMethodDeclaration> parentSolution;
        List<ResolvedMethodDeclaration> candidateMethods = this.myDeclaration.getDeclaredMethods().stream().filter(m -> m.getName().equals(name) && (!staticOnly || m.isStatic())).collect(Collectors.toList());
        if (!Object.class.getCanonicalName().equals(this.myDeclaration.getQualifiedName())) {
            for (ResolvedReferenceType ancestor : this.myDeclaration.getAncestors()) {
                SymbolReference<ResolvedMethodDeclaration> res2 = MethodResolutionLogic.solveMethodInType((ResolvedTypeDeclaration)ancestor.getTypeDeclaration(), name, argumentsTypes, staticOnly);
                if (!res2.isSolved()) continue;
                candidateMethods.add((ResolvedMethodDeclaration)res2.getCorrespondingDeclaration());
            }
        }
        if (candidateMethods.isEmpty() && (parentSolution = this.getParent().solveMethod(name, argumentsTypes, staticOnly)).isSolved()) {
            candidateMethods.add((ResolvedMethodDeclaration)parentSolution.getCorrespondingDeclaration());
        }
        if (candidateMethods.isEmpty() && this.myDeclaration.getSuperTypeDeclaration().isInterface() && (res = MethodResolutionLogic.solveMethodInType((ResolvedTypeDeclaration)new ReflectionClassDeclaration(Object.class, this.typeSolver), name, argumentsTypes, false)).isSolved()) {
            candidateMethods.add((ResolvedMethodDeclaration)res.getCorrespondingDeclaration());
        }
        return MethodResolutionLogic.findMostApplicable(candidateMethods, name, argumentsTypes, this.typeSolver);
    }

    @Override
    public SymbolReference<ResolvedTypeDeclaration> solveType(String name) {
        List<TypeDeclaration> typeDeclarations = this.myDeclaration.findMembersOfKind(TypeDeclaration.class);
        Optional<SymbolReference> exactMatch = typeDeclarations.stream().filter(internalType -> internalType.getName().getId().equals(name)).findFirst().map(internalType -> SymbolReference.solved((ResolvedDeclaration)JavaParserFacade.get(this.typeSolver).getTypeDeclaration((TypeDeclaration<?>)internalType)));
        if (exactMatch.isPresent()) {
            return exactMatch.get();
        }
        Optional<SymbolReference> recursiveMatch = typeDeclarations.stream().filter(internalType -> name.startsWith(String.format("%s.", internalType.getName()))).findFirst().map(internalType -> JavaParserFactory.getContext((Node)internalType, this.typeSolver).solveType(name.substring(internalType.getName().getId().length() + 1)));
        if (recursiveMatch.isPresent()) {
            return recursiveMatch.get();
        }
        Optional<SymbolReference> typeArgumentsMatch = ((ObjectCreationExpr)this.wrappedNode).getTypeArguments().map(nodes -> ((NodeWithTypeArguments)nodes).getTypeArguments().orElse(new NodeList())).orElse(new NodeList()).stream().filter(type -> type.toString().equals(name)).findFirst().map(matchingType -> SymbolReference.solved((ResolvedDeclaration)new JavaParserTypeParameter(new TypeParameter(matchingType.toString()), this.typeSolver)));
        if (typeArgumentsMatch.isPresent()) {
            return typeArgumentsMatch.get();
        }
        for (ResolvedReferenceType ancestor : this.myDeclaration.getAncestors()) {
            if (ancestor.getTypeDeclaration().getName().equals(name)) {
                return SymbolReference.solved((ResolvedDeclaration)ancestor.getTypeDeclaration());
            }
            try {
                for (ResolvedTypeDeclaration internalTypeDeclaration : ancestor.getTypeDeclaration().internalTypes()) {
                    if (!internalTypeDeclaration.getName().equals(name)) continue;
                    return SymbolReference.solved((ResolvedDeclaration)internalTypeDeclaration);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        return this.getParent().solveType(name);
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name) {
        Preconditions.checkArgument((this.typeSolver != null ? 1 : 0) != 0);
        if (this.myDeclaration.hasVisibleField(name)) {
            return SymbolReference.solved((ResolvedDeclaration)this.myDeclaration.getVisibleField(name));
        }
        return this.getParent().solveSymbol(name);
    }
}

