/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javassistmodel;

import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParametrizable;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistConstructorDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFieldDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistMethodDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistTypeParameter;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;

public class JavassistTypeDeclarationAdapter {
    private CtClass ctClass;
    private TypeSolver typeSolver;

    public JavassistTypeDeclarationAdapter(CtClass ctClass, TypeSolver typeSolver) {
        this.ctClass = ctClass;
        this.typeSolver = typeSolver;
    }

    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return Arrays.stream(this.ctClass.getDeclaredMethods()).filter(m -> (m.getMethodInfo().getAccessFlags() & 0x40) == 0 && (m.getMethodInfo().getAccessFlags() & 0x1000) == 0).map(m -> new JavassistMethodDeclaration((CtMethod)m, this.typeSolver)).collect(Collectors.toSet());
    }

    public List<ResolvedConstructorDeclaration> getConstructors() {
        return Arrays.stream(this.ctClass.getConstructors()).map(m -> new JavassistConstructorDeclaration((CtConstructor)m, this.typeSolver)).collect(Collectors.toList());
    }

    public List<ResolvedFieldDeclaration> getDeclaredFields() {
        ArrayList<ResolvedFieldDeclaration> fieldDecls = new ArrayList<ResolvedFieldDeclaration>();
        this.collectDeclaredFields(this.ctClass, fieldDecls);
        return fieldDecls;
    }

    private void collectDeclaredFields(CtClass ctClass, List<ResolvedFieldDeclaration> fieldDecls) {
        if (ctClass != null) {
            Arrays.stream(ctClass.getDeclaredFields()).forEach(f -> fieldDecls.add(new JavassistFieldDeclaration((CtField)f, this.typeSolver)));
            try {
                this.collectDeclaredFields(ctClass.getSuperclass(), fieldDecls);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        if (null == this.ctClass.getGenericSignature()) {
            return Collections.emptyList();
        }
        try {
            SignatureAttribute.ClassSignature classSignature = SignatureAttribute.toClassSignature((String)this.ctClass.getGenericSignature());
            return Arrays.stream(classSignature.getParameters()).map(tp -> new JavassistTypeParameter((SignatureAttribute.TypeParameter)tp, (ResolvedTypeParametrizable)JavassistFactory.toTypeDeclaration(this.ctClass, this.typeSolver), this.typeSolver)).collect(Collectors.toList());
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        try {
            return this.ctClass.getDeclaringClass() == null ? Optional.empty() : Optional.of(JavassistFactory.toTypeDeclaration(this.ctClass.getDeclaringClass(), this.typeSolver));
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

