/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javassistmodel;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedEnumConstantDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedEnumDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistClassDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistEnumConstantDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFieldDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistMethodDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistTypeDeclarationAdapter;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import com.github.javaparser.symbolsolver.logic.AbstractTypeDeclaration;
import com.github.javaparser.symbolsolver.logic.MethodResolutionCapability;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.resolution.MethodResolutionLogic;
import com.github.javaparser.symbolsolver.resolution.SymbolSolver;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;

public class JavassistEnumDeclaration
extends AbstractTypeDeclaration
implements ResolvedEnumDeclaration,
MethodResolutionCapability,
MethodUsageResolutionCapability {
    private CtClass ctClass;
    private TypeSolver typeSolver;
    private JavassistTypeDeclarationAdapter javassistTypeDeclarationAdapter;

    public JavassistEnumDeclaration(CtClass ctClass, TypeSolver typeSolver) {
        if (ctClass == null) {
            throw new IllegalArgumentException();
        }
        if (!ctClass.isEnum()) {
            throw new IllegalArgumentException("Trying to instantiate a JavassistEnumDeclaration with something which is not an enum: " + ctClass.toString());
        }
        this.ctClass = ctClass;
        this.typeSolver = typeSolver;
        this.javassistTypeDeclarationAdapter = new JavassistTypeDeclarationAdapter(ctClass, typeSolver);
    }

    public Modifier.Keyword accessSpecifier() {
        return JavassistFactory.modifiersToAccessLevel(this.ctClass.getModifiers());
    }

    public String getPackageName() {
        return this.ctClass.getPackageName();
    }

    public String getClassName() {
        String name = this.ctClass.getName().replace('$', '.');
        if (this.getPackageName() != null) {
            return name.substring(this.getPackageName().length() + 1, name.length());
        }
        return name;
    }

    public String getQualifiedName() {
        return this.ctClass.getName().replace('$', '.');
    }

    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        ArrayList<ResolvedReferenceType> ancestors;
        block6: {
            ancestors = new ArrayList<ResolvedReferenceType>();
            String superClassName = this.ctClass.getClassFile().getSuperclass();
            if (superClassName != null) {
                try {
                    ancestors.add(new ReferenceTypeImpl(this.typeSolver.solveType(superClassName), this.typeSolver));
                }
                catch (UnsolvedSymbolException e) {
                    if (acceptIncompleteList) break block6;
                    throw e;
                }
            }
        }
        for (String interfazeName : this.ctClass.getClassFile().getInterfaces()) {
            try {
                ancestors.add(new ReferenceTypeImpl(this.typeSolver.solveType(interfazeName), this.typeSolver));
            }
            catch (UnsolvedSymbolException e) {
                if (acceptIncompleteList) continue;
                throw e;
            }
        }
        return ancestors;
    }

    public ResolvedFieldDeclaration getField(String name) {
        Optional<ResolvedFieldDeclaration> field = this.javassistTypeDeclarationAdapter.getDeclaredFields().stream().filter(f -> f.getName().equals(name)).findFirst();
        return field.orElseThrow(() -> new RuntimeException("Field " + name + " does not exist in " + this.ctClass.getName() + "."));
    }

    public boolean hasField(String name) {
        return this.javassistTypeDeclarationAdapter.getDeclaredFields().stream().anyMatch(f -> f.getName().equals(name));
    }

    public List<ResolvedFieldDeclaration> getAllFields() {
        return this.javassistTypeDeclarationAdapter.getDeclaredFields();
    }

    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return this.javassistTypeDeclarationAdapter.getDeclaredMethods();
    }

    public boolean isAssignableBy(ResolvedType type) {
        throw new UnsupportedOperationException();
    }

    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        throw new UnsupportedOperationException();
    }

    public boolean hasDirectlyAnnotation(String canonicalName) {
        return this.ctClass.hasAnnotation(canonicalName);
    }

    public String getName() {
        String[] nameElements = this.ctClass.getSimpleName().replace('$', '.').split("\\.");
        return nameElements[nameElements.length - 1];
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return this.javassistTypeDeclarationAdapter.getTypeParameters();
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return this.javassistTypeDeclarationAdapter.containerType();
    }

    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        ArrayList<ResolvedMethodDeclaration> candidates = new ArrayList<ResolvedMethodDeclaration>();
        Predicate<CtMethod> staticOnlyCheck = m -> !staticOnly || staticOnly && Modifier.isStatic(m.getModifiers());
        for (CtMethod method : this.ctClass.getDeclaredMethods()) {
            boolean isNotBridge;
            boolean isSynthetic = method.getMethodInfo().getAttribute("Synthetic") != null;
            boolean bl = isNotBridge = (method.getMethodInfo().getAccessFlags() & 0x40) == 0;
            if (!method.getName().equals(name) || isSynthetic || !isNotBridge || !staticOnlyCheck.test(method)) continue;
            candidates.add(new JavassistMethodDeclaration(method, this.typeSolver));
        }
        try {
            SymbolReference<ResolvedMethodDeclaration> ref;
            CtClass superClass = this.ctClass.getSuperclass();
            if (superClass != null && (ref = new JavassistClassDeclaration(superClass, this.typeSolver).solveMethod(name, argumentsTypes, staticOnly)).isSolved()) {
                candidates.add((ResolvedMethodDeclaration)ref.getCorrespondingDeclaration());
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return MethodResolutionLogic.findMostApplicable(candidates, name, argumentsTypes, this.typeSolver);
    }

    @Override
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentsTypes, Context invokationContext, List<ResolvedType> typeParameterValues) {
        return JavassistUtils.getMethodUsage(this.ctClass, name, argumentsTypes, this.typeSolver, this.getTypeParameters(), typeParameterValues);
    }

    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        try {
            return Arrays.stream(this.ctClass.getDeclaredClasses()).map(itype -> JavassistFactory.toTypeDeclaration(itype, this.typeSolver)).collect(Collectors.toSet());
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ResolvedReferenceTypeDeclaration getInternalType(String name) {
        Optional<ResolvedReferenceTypeDeclaration> type = this.internalTypes().stream().filter(f -> f.getName().endsWith(name)).findFirst();
        return type.orElseThrow(() -> new UnsolvedSymbolException("Internal type not found: " + name));
    }

    public boolean hasInternalType(String name) {
        return this.internalTypes().stream().anyMatch(f -> f.getName().endsWith(name));
    }

    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        String[] interfaceFQNs;
        for (CtField field : this.ctClass.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return SymbolReference.solved((ResolvedDeclaration)new JavassistFieldDeclaration(field, typeSolver));
        }
        for (String interfaceFQN : interfaceFQNs = this.getInterfaceFQNs()) {
            SymbolReference<? extends ResolvedValueDeclaration> interfaceRef = this.solveSymbolForFQN(name, interfaceFQN);
            if (!interfaceRef.isSolved()) continue;
            return interfaceRef;
        }
        return SymbolReference.unsolved(ResolvedValueDeclaration.class);
    }

    private SymbolReference<? extends ResolvedValueDeclaration> solveSymbolForFQN(String symbolName, String fqn) {
        if (fqn == null) {
            return SymbolReference.unsolved(ResolvedValueDeclaration.class);
        }
        ResolvedReferenceTypeDeclaration fqnTypeDeclaration = this.typeSolver.solveType(fqn);
        return new SymbolSolver(this.typeSolver).solveSymbolInType((ResolvedTypeDeclaration)fqnTypeDeclaration, symbolName);
    }

    private String[] getInterfaceFQNs() {
        return this.ctClass.getClassFile().getInterfaces();
    }

    public List<ResolvedEnumConstantDeclaration> getEnumConstants() {
        return Arrays.stream(this.ctClass.getFields()).filter(f -> (f.getFieldInfo2().getAccessFlags() & 0x4000) != 0).map(f -> new JavassistEnumConstantDeclaration((CtField)f, this.typeSolver)).collect(Collectors.toList());
    }

    public List<ResolvedConstructorDeclaration> getConstructors() {
        return this.javassistTypeDeclarationAdapter.getConstructors();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ctClass=" + this.ctClass.getName() + ", typeSolver=" + this.typeSolver + '}';
    }
}

