/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.utils;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.utils.SourceRoot;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ProjectRoot {
    private final Path projectRoot;
    private final Map<Path, SourceRoot> cache = new ConcurrentHashMap<Path, SourceRoot>();
    private ParserConfiguration parserConfiguration = new ParserConfiguration();

    public ProjectRoot(Path projectRoot) {
        this.projectRoot = projectRoot;
    }

    public ProjectRoot(Path projectRoot, ParserConfiguration parserConfiguration) {
        this.projectRoot = projectRoot;
        this.parserConfiguration = parserConfiguration;
    }

    public Optional<SourceRoot> getSourceRoot(Path sourceRoot) {
        return Optional.ofNullable(this.cache.get(sourceRoot));
    }

    public List<SourceRoot> getSourceRoots() {
        return new ArrayList<SourceRoot>(this.cache.values());
    }

    public void addSourceRoot(Path path) {
        this.cache.put(path, new SourceRoot(path).setParserConfiguration(this.parserConfiguration));
    }

    public Path getProjectRoot() {
        return this.projectRoot;
    }
}

