/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.resolution.types;

import com.github.javaparser.resolution.types.ResolvedType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ResolvedPrimitiveType
implements ResolvedType {
    public static final ResolvedPrimitiveType BYTE = new ResolvedPrimitiveType("byte", Byte.class.getCanonicalName(), Collections.emptyList());
    public static final ResolvedPrimitiveType SHORT = new ResolvedPrimitiveType("short", Short.class.getCanonicalName(), Collections.singletonList(BYTE));
    public static final ResolvedPrimitiveType CHAR = new ResolvedPrimitiveType("char", Character.class.getCanonicalName(), Collections.emptyList());
    public static final ResolvedPrimitiveType INT = new ResolvedPrimitiveType("int", Integer.class.getCanonicalName(), Arrays.asList(BYTE, SHORT, CHAR));
    public static final ResolvedPrimitiveType LONG = new ResolvedPrimitiveType("long", Long.class.getCanonicalName(), Arrays.asList(BYTE, SHORT, INT, CHAR));
    public static final ResolvedPrimitiveType BOOLEAN = new ResolvedPrimitiveType("boolean", Boolean.class.getCanonicalName(), Collections.emptyList());
    public static final ResolvedPrimitiveType FLOAT = new ResolvedPrimitiveType("float", Float.class.getCanonicalName(), Arrays.asList(LONG, INT, SHORT, BYTE, CHAR));
    public static final ResolvedPrimitiveType DOUBLE = new ResolvedPrimitiveType("double", Double.class.getCanonicalName(), Arrays.asList(FLOAT, LONG, INT, SHORT, BYTE, CHAR));
    public static final List<ResolvedPrimitiveType> ALL = Arrays.asList(INT, BOOLEAN, LONG, CHAR, FLOAT, DOUBLE, SHORT, BYTE);
    private String name;
    private String boxTypeQName;
    private List<ResolvedPrimitiveType> promotionTypes;

    private ResolvedPrimitiveType(String name, String boxTypeQName, List<ResolvedPrimitiveType> promotionTypes) {
        this.name = name;
        this.boxTypeQName = boxTypeQName;
        this.promotionTypes = promotionTypes;
    }

    public static ResolvedType byName(String name) {
        name = name.toLowerCase();
        for (ResolvedPrimitiveType ptu : ALL) {
            if (!ptu.describe().equals(name)) continue;
            return ptu;
        }
        throw new IllegalArgumentException("Name " + name);
    }

    public String toString() {
        return "PrimitiveTypeUsage{name='" + this.name + '\'' + '}';
    }

    @Override
    public ResolvedPrimitiveType asPrimitive() {
        return this;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public boolean isReferenceType() {
        return false;
    }

    @Override
    public String describe() {
        return this.name;
    }

    @Override
    public boolean isTypeVariable() {
        return false;
    }

    @Override
    public boolean isAssignableBy(ResolvedType other) {
        if (other.isPrimitive()) {
            return this == other || this.promotionTypes.contains(other);
        }
        if (other.isReferenceType()) {
            if (other.asReferenceType().getQualifiedName().equals(this.boxTypeQName)) {
                return true;
            }
            for (ResolvedPrimitiveType promotion : this.promotionTypes) {
                if (!other.asReferenceType().getQualifiedName().equals(promotion.boxTypeQName)) continue;
                return true;
            }
            return false;
        }
        if (other.isConstraint()) {
            return this.isAssignableBy(other.asConstraintType().getBound());
        }
        return false;
    }

    public String getBoxTypeQName() {
        return this.boxTypeQName;
    }
}

