/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.utils;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParseStart;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Problem;
import com.github.javaparser.Providers;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.printer.PrettyPrinter;
import com.github.javaparser.utils.CodeGenerationUtils;
import com.github.javaparser.utils.Log;
import com.github.javaparser.utils.Utils;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SourceRoot {
    private final Path root;
    private final Map<Path, ParseResult<CompilationUnit>> cache = new ConcurrentHashMap<Path, ParseResult<CompilationUnit>>();
    private ParserConfiguration parserConfiguration = new ParserConfiguration();
    private Function<CompilationUnit, String> printer = new PrettyPrinter()::print;
    private static final Pattern JAVA_IDENTIFIER = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");

    public SourceRoot(Path root) {
        Utils.assertNotNull(root);
        if (!Files.isDirectory(root, new LinkOption[0])) {
            throw new IllegalArgumentException("Only directories are allowed as root path: " + root);
        }
        this.root = root.normalize();
        Log.info("New source root at \"%s\"", this.root);
    }

    public SourceRoot(Path root, ParserConfiguration parserConfiguration) {
        this(root);
        this.setParserConfiguration(parserConfiguration);
    }

    @Deprecated
    public ParseResult<CompilationUnit> tryToParse(String startPackage, String filename, JavaParser javaParser) throws IOException {
        return this.tryToParse(startPackage, filename, javaParser.getParserConfiguration());
    }

    public ParseResult<CompilationUnit> tryToParse(String startPackage, String filename, ParserConfiguration configuration) throws IOException {
        Utils.assertNotNull(startPackage);
        Utils.assertNotNull(filename);
        Path relativePath = CodeGenerationUtils.fileInPackageRelativePath(startPackage, filename);
        if (this.cache.containsKey(relativePath)) {
            Log.trace("Retrieving cached %s", relativePath);
            return this.cache.get(relativePath);
        }
        Path path = this.root.resolve(relativePath);
        Log.trace("Parsing %s", path);
        ParseResult<CompilationUnit> result = new JavaParser(configuration).parse(ParseStart.COMPILATION_UNIT, Providers.provider(path));
        result.getResult().ifPresent(cu -> cu.setStorage(path));
        this.cache.put(relativePath, result);
        return result;
    }

    public ParseResult<CompilationUnit> tryToParse(String startPackage, String filename) throws IOException {
        return this.tryToParse(startPackage, filename, this.parserConfiguration);
    }

    public List<ParseResult<CompilationUnit>> tryToParse(String startPackage) throws IOException {
        Utils.assertNotNull(startPackage);
        this.logPackage(startPackage);
        Path path = CodeGenerationUtils.packageAbsolutePath(this.root, startPackage);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!attrs.isDirectory() && file.toString().endsWith(".java")) {
                    Path relative = SourceRoot.this.root.relativize(file.getParent());
                    SourceRoot.this.tryToParse(relative.toString(), file.getFileName().toString());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return SourceRoot.isSensibleDirectoryToEnter(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }
        });
        return this.getCache();
    }

    private static boolean isSensibleDirectoryToEnter(Path dir) throws IOException {
        String dirToEnter = dir.getFileName().toString();
        boolean directoryIsAValidJavaIdentifier = JAVA_IDENTIFIER.matcher(dirToEnter).matches();
        if (Files.isHidden(dir) || !directoryIsAValidJavaIdentifier) {
            Log.trace("Not processing directory \"%s\"", dirToEnter);
            return false;
        }
        return true;
    }

    public List<ParseResult<CompilationUnit>> tryToParse() throws IOException {
        return this.tryToParse("");
    }

    public List<ParseResult<CompilationUnit>> tryToParseParallelized(String startPackage) {
        Utils.assertNotNull(startPackage);
        this.logPackage(startPackage);
        Path path = CodeGenerationUtils.packageAbsolutePath(this.root, startPackage);
        ParallelParse parse = new ParallelParse(path, (file, attrs) -> {
            if (!attrs.isDirectory() && file.toString().endsWith(".java")) {
                Path relative = this.root.relativize(file.getParent());
                try {
                    this.tryToParse(relative.toString(), file.getFileName().toString(), this.parserConfiguration);
                }
                catch (IOException e) {
                    Log.error(e);
                }
            }
            return FileVisitResult.CONTINUE;
        });
        ForkJoinPool pool = new ForkJoinPool();
        pool.invoke(parse);
        return this.getCache();
    }

    public List<ParseResult<CompilationUnit>> tryToParseParallelized() throws IOException {
        return this.tryToParseParallelized("");
    }

    public CompilationUnit parse(String startPackage, String filename) {
        Utils.assertNotNull(startPackage);
        Utils.assertNotNull(filename);
        try {
            ParseResult<CompilationUnit> result = this.tryToParse(startPackage, filename);
            if (result.isSuccessful()) {
                return result.getResult().get();
            }
            throw new ParseProblemException(result.getProblems());
        }
        catch (IOException e) {
            throw new ParseProblemException(e);
        }
    }

    @Deprecated
    public SourceRoot parse(String startPackage, JavaParser javaParser, Callback callback) throws IOException {
        return this.parse(startPackage, javaParser.getParserConfiguration(), callback);
    }

    public SourceRoot parse(String startPackage, ParserConfiguration configuration, final Callback callback) throws IOException {
        Utils.assertNotNull(startPackage);
        Utils.assertNotNull(configuration);
        Utils.assertNotNull(callback);
        this.logPackage(startPackage);
        final JavaParser javaParser = new JavaParser(configuration);
        final Path path = CodeGenerationUtils.packageAbsolutePath(this.root, startPackage);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path absolutePath, BasicFileAttributes attrs) throws IOException {
                if (!attrs.isDirectory() && absolutePath.toString().endsWith(".java")) {
                    Path localPath = SourceRoot.this.root.relativize(absolutePath);
                    Log.trace("Parsing %s", localPath);
                    ParseResult<CompilationUnit> result = javaParser.parse(ParseStart.COMPILATION_UNIT, Providers.provider(absolutePath));
                    result.getResult().ifPresent(cu -> cu.setStorage(absolutePath));
                    if (callback.process(localPath, absolutePath, result) == Callback.Result.SAVE && result.getResult().isPresent()) {
                        SourceRoot.this.save(result.getResult().get(), path);
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return SourceRoot.isSensibleDirectoryToEnter(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }
        });
        return this;
    }

    private void logPackage(String startPackage) {
        if (startPackage.isEmpty()) {
            return;
        }
        Log.info("Parsing package \"%s\"", startPackage);
    }

    public SourceRoot parseParallelized(String startPackage, ParserConfiguration configuration, Callback callback) {
        Utils.assertNotNull(startPackage);
        Utils.assertNotNull(configuration);
        Utils.assertNotNull(callback);
        this.logPackage(startPackage);
        Path path = CodeGenerationUtils.packageAbsolutePath(this.root, startPackage);
        ParallelParse parse = new ParallelParse(path, (file, attrs) -> {
            if (!attrs.isDirectory() && file.toString().endsWith(".java")) {
                Path localPath = this.root.relativize(file);
                Log.trace("Parsing %s", localPath);
                try {
                    ParseResult<CompilationUnit> result = new JavaParser(configuration).parse(ParseStart.COMPILATION_UNIT, Providers.provider(file));
                    result.getResult().ifPresent(cu -> cu.setStorage(file));
                    if (callback.process(localPath, file, result) == Callback.Result.SAVE && result.getResult().isPresent()) {
                        this.save(result.getResult().get(), path);
                    }
                }
                catch (IOException e) {
                    Log.error(e);
                }
            }
            return FileVisitResult.CONTINUE;
        });
        ForkJoinPool pool = new ForkJoinPool();
        pool.invoke(parse);
        return this;
    }

    public SourceRoot parseParallelized(String startPackage, Callback callback) throws IOException {
        return this.parseParallelized(startPackage, new ParserConfiguration(), callback);
    }

    public SourceRoot parseParallelized(Callback callback) throws IOException {
        return this.parseParallelized("", new ParserConfiguration(), callback);
    }

    public SourceRoot add(String startPackage, String filename, CompilationUnit compilationUnit) {
        Utils.assertNotNull(startPackage);
        Utils.assertNotNull(filename);
        Utils.assertNotNull(compilationUnit);
        Log.trace("Adding new file %s.%s", startPackage, filename);
        Path path = CodeGenerationUtils.fileInPackageRelativePath(startPackage, filename);
        ParseResult<CompilationUnit> parseResult = new ParseResult<CompilationUnit>(compilationUnit, new ArrayList<Problem>(), null, null);
        this.cache.put(path, parseResult);
        return this;
    }

    public SourceRoot add(CompilationUnit compilationUnit) {
        Utils.assertNotNull(compilationUnit);
        if (!compilationUnit.getStorage().isPresent()) {
            throw new AssertionError((Object)"Files added with this method should have their path set.");
        }
        Path path = compilationUnit.getStorage().get().getPath();
        Log.trace("Adding new file %s", path);
        ParseResult<CompilationUnit> parseResult = new ParseResult<CompilationUnit>(compilationUnit, new ArrayList<Problem>(), null, null);
        this.cache.put(path, parseResult);
        return this;
    }

    private SourceRoot save(CompilationUnit cu, Path path) {
        Utils.assertNotNull(cu);
        Utils.assertNotNull(path);
        cu.setStorage(path);
        cu.getStorage().get().save(this.printer);
        return this;
    }

    public SourceRoot saveAll(Path root) {
        Utils.assertNotNull(root);
        Log.info("Saving all files (%s) to %s", this.cache.size(), root);
        for (Map.Entry<Path, ParseResult<CompilationUnit>> cu : this.cache.entrySet()) {
            Path path = root.resolve(cu.getKey());
            if (!cu.getValue().getResult().isPresent()) continue;
            Log.trace("Saving %s", path);
            this.save(cu.getValue().getResult().get(), path);
        }
        return this;
    }

    public SourceRoot saveAll() {
        return this.saveAll(this.root);
    }

    public List<ParseResult<CompilationUnit>> getCache() {
        return new ArrayList<ParseResult<CompilationUnit>>(this.cache.values());
    }

    public List<CompilationUnit> getCompilationUnits() {
        return this.cache.values().stream().filter(ParseResult::isSuccessful).map(p -> (CompilationUnit)p.getResult().get()).collect(Collectors.toList());
    }

    public Path getRoot() {
        return this.root;
    }

    @Deprecated
    public JavaParser getJavaParser() {
        return new JavaParser(this.parserConfiguration);
    }

    @Deprecated
    public SourceRoot setJavaParser(JavaParser javaParser) {
        Utils.assertNotNull(javaParser);
        this.parserConfiguration = javaParser.getParserConfiguration();
        return this;
    }

    public ParserConfiguration getParserConfiguration() {
        return this.parserConfiguration;
    }

    public SourceRoot setParserConfiguration(ParserConfiguration parserConfiguration) {
        Utils.assertNotNull(parserConfiguration);
        this.parserConfiguration = parserConfiguration;
        return this;
    }

    public SourceRoot setPrinter(Function<CompilationUnit, String> printer) {
        Utils.assertNotNull(printer);
        this.printer = printer;
        return this;
    }

    public Function<CompilationUnit, String> getPrinter() {
        return this.printer;
    }

    private static class ParallelParse
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final Path path;
        private final VisitFileCallback callback;

        ParallelParse(Path path, VisitFileCallback callback) {
            this.path = path;
            this.callback = callback;
        }

        @Override
        protected void compute() {
            final ArrayList walks = new ArrayList();
            try {
                Files.walkFileTree(this.path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        if (!SourceRoot.isSensibleDirectoryToEnter(dir)) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        if (!dir.equals(path)) {
                            ParallelParse w = new ParallelParse(dir, callback);
                            w.fork();
                            walks.add(w);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        return callback.process(file, attrs);
                    }
                });
            }
            catch (IOException e) {
                Log.error(e);
            }
            for (ParallelParse w : walks) {
                w.join();
            }
        }

        static interface VisitFileCallback {
            public FileVisitResult process(Path var1, BasicFileAttributes var2);
        }
    }

    @FunctionalInterface
    public static interface Callback {
        public Result process(Path var1, Path var2, ParseResult<CompilationUnit> var3);

        public static enum Result {
            SAVE,
            DONT_SAVE;

        }
    }
}

