/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.BinaryExprMetaModel;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.printer.Printable;
import com.github.javaparser.utils.Utils;
import java.util.Optional;
import java.util.function.Consumer;

public final class BinaryExpr
extends Expression {
    private Expression left;
    private Expression right;
    private Operator operator;

    public BinaryExpr() {
        this(null, new BooleanLiteralExpr(), new BooleanLiteralExpr(), Operator.EQUALS);
    }

    @AllFieldsConstructor
    public BinaryExpr(Expression left, Expression right, Operator operator) {
        this(null, left, right, operator);
    }

    public BinaryExpr(TokenRange tokenRange, Expression left, Expression right, Operator operator) {
        super(tokenRange);
        this.setLeft(left);
        this.setRight(right);
        this.setOperator(operator);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Expression getLeft() {
        return this.left;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getRight() {
        return this.right;
    }

    public BinaryExpr setLeft(Expression left) {
        Utils.assertNotNull(left);
        if (left == this.left) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.LEFT, this.left, left);
        if (this.left != null) {
            this.left.setParentNode(null);
        }
        this.left = left;
        this.setAsParentNodeOf(left);
        return this;
    }

    public BinaryExpr setOperator(Operator operator) {
        Utils.assertNotNull(operator);
        if (operator == this.operator) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.OPERATOR, this.operator, operator);
        this.operator = operator;
        return this;
    }

    public BinaryExpr setRight(Expression right) {
        Utils.assertNotNull(right);
        if (right == this.right) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.RIGHT, this.right, right);
        if (this.right != null) {
            this.right.setParentNode(null);
        }
        this.right = right;
        this.setAsParentNodeOf(right);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    @Override
    public BinaryExpr clone() {
        return (BinaryExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public BinaryExprMetaModel getMetaModel() {
        return JavaParserMetaModel.binaryExprMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (node == this.left) {
            this.setLeft((Expression)replacementNode);
            return true;
        }
        if (node == this.right) {
            this.setRight((Expression)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isBinaryExpr() {
        return true;
    }

    @Override
    public BinaryExpr asBinaryExpr() {
        return this;
    }

    @Override
    public void ifBinaryExpr(Consumer<BinaryExpr> action) {
        action.accept(this);
    }

    @Override
    public Optional<BinaryExpr> toBinaryExpr() {
        return Optional.of(this);
    }

    public static enum Operator implements Printable
    {
        OR("||", null),
        AND("&&", null),
        BINARY_OR("|", AssignExpr.Operator.BINARY_OR),
        BINARY_AND("&", AssignExpr.Operator.BINARY_AND),
        XOR("^", AssignExpr.Operator.XOR),
        EQUALS("==", null),
        NOT_EQUALS("!=", null),
        LESS("<", null),
        GREATER(">", null),
        LESS_EQUALS("<=", null),
        GREATER_EQUALS(">=", null),
        LEFT_SHIFT("<<", AssignExpr.Operator.LEFT_SHIFT),
        SIGNED_RIGHT_SHIFT(">>", AssignExpr.Operator.SIGNED_RIGHT_SHIFT),
        UNSIGNED_RIGHT_SHIFT(">>>", AssignExpr.Operator.UNSIGNED_RIGHT_SHIFT),
        PLUS("+", AssignExpr.Operator.PLUS),
        MINUS("-", AssignExpr.Operator.MINUS),
        MULTIPLY("*", AssignExpr.Operator.MULTIPLY),
        DIVIDE("/", AssignExpr.Operator.DIVIDE),
        REMAINDER("%", AssignExpr.Operator.REMAINDER);

        private final String codeRepresentation;
        private final AssignExpr.Operator assignOperatorEquivalent;

        private Operator(String codeRepresentation, AssignExpr.Operator assignOperatorEquivalent) {
            this.codeRepresentation = codeRepresentation;
            this.assignOperatorEquivalent = assignOperatorEquivalent;
        }

        @Override
        public String asString() {
            return this.codeRepresentation;
        }

        public Optional<AssignExpr.Operator> toAssignOperator() {
            return Optional.ofNullable(this.assignOperatorEquivalent);
        }
    }
}

