/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.type;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.WildcardTypeMetaModel;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public final class WildcardType
extends Type
implements NodeWithAnnotations<WildcardType> {
    private ReferenceType extendedType;
    private ReferenceType superType;

    public WildcardType() {
        this(null, null, null);
    }

    public WildcardType(ReferenceType extendedType) {
        this(null, extendedType, null);
    }

    @AllFieldsConstructor
    public WildcardType(ReferenceType extendedType, ReferenceType superType) {
        this(null, extendedType, superType);
    }

    public WildcardType(TokenRange tokenRange, ReferenceType extendedType, ReferenceType superType) {
        super(tokenRange);
        this.setExtendedType(extendedType);
        this.setSuperType(superType);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Optional<ReferenceType> getExtendedType() {
        return Optional.ofNullable(this.extendedType);
    }

    public Optional<ReferenceType> getSuperType() {
        return Optional.ofNullable(this.superType);
    }

    @Deprecated
    public Optional<ReferenceType> getExtendedTypes() {
        return this.getExtendedType();
    }

    @Deprecated
    public Optional<ReferenceType> getSuperTypes() {
        return this.getSuperType();
    }

    public WildcardType setExtendedType(ReferenceType extendedType) {
        if (extendedType == this.extendedType) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.EXTENDED_TYPE, this.extendedType, extendedType);
        if (this.extendedType != null) {
            this.extendedType.setParentNode(null);
        }
        this.extendedType = extendedType;
        this.setAsParentNodeOf(extendedType);
        return this;
    }

    @Deprecated
    public WildcardType setExtendedTypes(ReferenceType extendedType) {
        return this.setExtendedType(extendedType);
    }

    public WildcardType setSuperType(ReferenceType superType) {
        if (superType == this.superType) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.SUPER_TYPE, this.superType, superType);
        if (this.superType != null) {
            this.superType.setParentNode(null);
        }
        this.superType = superType;
        this.setAsParentNodeOf(superType);
        return this;
    }

    @Deprecated
    public WildcardType setSuperTypes(ReferenceType superType) {
        return this.setSuperType(superType);
    }

    @Override
    public WildcardType setAnnotations(NodeList<AnnotationExpr> annotations) {
        return (WildcardType)super.setAnnotations(annotations);
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        return Arrays.asList(this.getAnnotations());
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        if (this.extendedType != null && node == this.extendedType) {
            this.removeExtendedType();
            return true;
        }
        if (this.superType != null && node == this.superType) {
            this.removeSuperType();
            return true;
        }
        return super.remove(node);
    }

    @Override
    public String asString() {
        StringBuilder str = new StringBuilder("?");
        this.getExtendedType().ifPresent(t -> str.append(" extends ").append(t.asString()));
        this.getSuperType().ifPresent(t -> str.append(" super ").append(t.asString()));
        return str.toString();
    }

    @Deprecated
    public WildcardType removeExtendedTypes() {
        return this.removeExtendedType();
    }

    @Deprecated
    public WildcardType removeSuperTypes() {
        return this.removeSuperType();
    }

    public WildcardType removeExtendedType() {
        return this.setExtendedType(null);
    }

    public WildcardType removeSuperType() {
        return this.setSuperType(null);
    }

    @Override
    public WildcardType clone() {
        return (WildcardType)this.accept(new CloneVisitor(), null);
    }

    @Override
    public WildcardTypeMetaModel getMetaModel() {
        return JavaParserMetaModel.wildcardTypeMetaModel;
    }
}

