/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.Token;
import com.github.javaparser.utils.Utils;
import java.util.List;
import java.util.Optional;

public class JavaToken {
    public static final JavaToken INVALID = new JavaToken();
    private final Range range;
    private final int kind;
    private final String text;
    private final Optional<JavaToken> previousToken;
    private Optional<JavaToken> nextToken = Optional.empty();

    private JavaToken() {
        this.range = new Range(Position.pos(-1, -1), Position.pos(-1, -1));
        this.kind = 0;
        this.text = "INVALID";
        this.previousToken = Optional.empty();
    }

    public JavaToken(Token token, List<JavaToken> tokens) {
        Range range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.endColumn);
        String text = token.image;
        if (token.kind == 166) {
            range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.beginColumn);
            text = ">";
        } else if (token.kind == 165) {
            range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.beginColumn + 1);
            text = ">>";
        }
        this.range = range;
        this.kind = token.kind;
        this.text = text;
        if (!tokens.isEmpty()) {
            JavaToken previousToken = tokens.get(tokens.size() - 1);
            this.previousToken = Optional.of(previousToken);
            previousToken.nextToken = Optional.of(this);
        } else {
            this.previousToken = Optional.empty();
        }
    }

    public Range getRange() {
        return this.range;
    }

    public int getKind() {
        return this.kind;
    }

    public String getText() {
        return this.text;
    }

    public Optional<JavaToken> getNextToken() {
        return this.nextToken;
    }

    public Optional<JavaToken> getPreviousToken() {
        return this.previousToken;
    }

    public String toString() {
        return this.text;
    }

    public boolean valid() {
        return !this.invalid();
    }

    public boolean invalid() {
        return this == INVALID;
    }

    public JavaToken orIfInvalid(JavaToken anotherToken) {
        Utils.assertNotNull(anotherToken);
        if (this.valid() || anotherToken.invalid()) {
            return this;
        }
        return anotherToken;
    }
}

