/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.ConditionalExprMetaModel;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.utils.Utils;

public final class ConditionalExpr
extends Expression {
    private Expression condition;
    private Expression thenExpr;
    private Expression elseExpr;

    public ConditionalExpr() {
        this(null, new BooleanLiteralExpr(), new StringLiteralExpr(), new StringLiteralExpr());
    }

    @AllFieldsConstructor
    public ConditionalExpr(Expression condition, Expression thenExpr, Expression elseExpr) {
        this(null, condition, thenExpr, elseExpr);
    }

    public ConditionalExpr(Range range, Expression condition, Expression thenExpr, Expression elseExpr) {
        super(range);
        this.setCondition(condition);
        this.setThenExpr(thenExpr);
        this.setElseExpr(elseExpr);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getElseExpr() {
        return this.elseExpr;
    }

    public Expression getThenExpr() {
        return this.thenExpr;
    }

    public ConditionalExpr setCondition(Expression condition) {
        Utils.assertNotNull(condition);
        if (condition == this.condition) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.CONDITION, this.condition, condition);
        if (this.condition != null) {
            this.condition.setParentNode(null);
        }
        this.condition = condition;
        this.setAsParentNodeOf(condition);
        return this;
    }

    public ConditionalExpr setElseExpr(Expression elseExpr) {
        Utils.assertNotNull(elseExpr);
        if (elseExpr == this.elseExpr) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.ELSE_EXPR, this.elseExpr, elseExpr);
        if (this.elseExpr != null) {
            this.elseExpr.setParentNode(null);
        }
        this.elseExpr = elseExpr;
        this.setAsParentNodeOf(elseExpr);
        return this;
    }

    public ConditionalExpr setThenExpr(Expression thenExpr) {
        Utils.assertNotNull(thenExpr);
        if (thenExpr == this.thenExpr) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.THEN_EXPR, this.thenExpr, thenExpr);
        if (this.thenExpr != null) {
            this.thenExpr.setParentNode(null);
        }
        this.thenExpr = thenExpr;
        this.setAsParentNodeOf(thenExpr);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    @Override
    public ConditionalExpr clone() {
        return (ConditionalExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public ConditionalExprMetaModel getMetaModel() {
        return JavaParserMetaModel.conditionalExprMetaModel;
    }
}

