/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.type;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.TypeMetaModel;
import com.github.javaparser.utils.Utils;

public abstract class Type
extends Node {
    private NodeList<AnnotationExpr> annotations;

    public Type(Range range, NodeList<AnnotationExpr> annotations) {
        super(range);
        this.setAnnotations(annotations);
    }

    public NodeList<AnnotationExpr> getAnnotations() {
        return this.annotations;
    }

    public AnnotationExpr getAnnotation(int i) {
        return (AnnotationExpr)this.getAnnotations().get(i);
    }

    public Type setAnnotations(NodeList<AnnotationExpr> annotations) {
        Utils.assertNotNull(annotations);
        if (annotations == this.annotations) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.ANNOTATIONS, this.annotations, annotations);
        if (this.annotations != null) {
            this.annotations.setParentNode(null);
        }
        this.annotations = annotations;
        this.setAsParentNodeOf(annotations);
        return this;
    }

    public Type getElementType() {
        if (this instanceof ArrayType) {
            return ((ArrayType)this).getComponentType().getElementType();
        }
        return this;
    }

    public int getArrayLevel() {
        if (this instanceof ArrayType) {
            return 1 + ((ArrayType)this).getComponentType().getArrayLevel();
        }
        return 0;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (this.annotations.get(i) != node) continue;
            this.annotations.remove(i);
            return true;
        }
        return super.remove(node);
    }

    @Override
    public Type clone() {
        return (Type)this.accept(new CloneVisitor(), null);
    }

    @Override
    public TypeMetaModel getMetaModel() {
        return JavaParserMetaModel.typeMetaModel;
    }
}

