/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.JavaParser;
import com.github.javaparser.Range;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithIdentifier;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.NameMetaModel;
import com.github.javaparser.utils.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class Name
extends Node
implements NodeWithIdentifier<Name>,
NodeWithAnnotations<Name> {
    private String identifier;
    private Name qualifier;
    private NodeList<AnnotationExpr> annotations;

    public Name() {
        this(null, null, "empty", new NodeList<AnnotationExpr>());
    }

    public Name(String identifier) {
        this(null, null, identifier, new NodeList<AnnotationExpr>());
    }

    public Name(Name qualifier, String identifier) {
        this(null, qualifier, identifier, new NodeList<AnnotationExpr>());
    }

    @AllFieldsConstructor
    public Name(Name qualifier, String identifier, NodeList<AnnotationExpr> annotations) {
        this(null, qualifier, identifier, annotations);
    }

    public Name(Range range, Name qualifier, String identifier, NodeList<AnnotationExpr> annotations) {
        super(range);
        this.setIdentifier(identifier);
        this.setQualifier(qualifier);
        this.setAnnotations((NodeList)annotations);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public final String getIdentifier() {
        return this.identifier;
    }

    @Override
    public Name setIdentifier(String identifier) {
        Utils.assertNonEmpty(identifier);
        if (identifier == this.identifier) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.IDENTIFIER, this.identifier, identifier);
        this.identifier = identifier;
        return this;
    }

    @Deprecated
    public static Name parse(String qualifiedName) {
        Utils.assertNonEmpty(qualifiedName);
        return JavaParser.parseName(qualifiedName);
    }

    public String asString() {
        if (this.qualifier != null) {
            return this.qualifier.asString() + "." + this.identifier;
        }
        return this.identifier;
    }

    public Optional<Name> getQualifier() {
        return Optional.ofNullable(this.qualifier);
    }

    public Name setQualifier(Name qualifier) {
        if (qualifier == this.qualifier) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.QUALIFIER, this.qualifier, qualifier);
        if (this.qualifier != null) {
            this.qualifier.setParentNode(null);
        }
        this.qualifier = qualifier;
        this.setAsParentNodeOf(qualifier);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (this.annotations.get(i) != node) continue;
            this.annotations.remove(i);
            return true;
        }
        if (this.qualifier != null && node == this.qualifier) {
            this.removeQualifier();
            return true;
        }
        return super.remove(node);
    }

    public Name removeQualifier() {
        return this.setQualifier(null);
    }

    @Override
    public NodeList<AnnotationExpr> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Name setAnnotations(NodeList<AnnotationExpr> annotations) {
        Utils.assertNotNull(annotations);
        if (annotations == this.annotations) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.ANNOTATIONS, this.annotations, annotations);
        if (this.annotations != null) {
            this.annotations.setParentNode(null);
        }
        this.annotations = annotations;
        this.setAsParentNodeOf(annotations);
        return this;
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        return Arrays.asList(this.getAnnotations());
    }

    @Override
    public Name clone() {
        return (Name)this.accept(new CloneVisitor(), null);
    }

    @Override
    public NameMetaModel getMetaModel() {
        return JavaParserMetaModel.nameMetaModel;
    }
}

