/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.metamodel.CallableDeclarationMetaModel;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.utils.Utils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public abstract class CallableDeclaration<T extends Node>
extends BodyDeclaration<T> {
    private EnumSet<Modifier> modifiers;
    private NodeList<TypeParameter> typeParameters;
    private SimpleName name;
    private NodeList<Parameter> parameters;
    private NodeList<ReferenceType<?>> thrownExceptions;

    public CallableDeclaration(Range range, EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<TypeParameter> typeParameters, SimpleName name, NodeList<Parameter> parameters, NodeList<ReferenceType<?>> thrownExceptions) {
        super(range, annotations);
        this.setModifiers(modifiers);
        this.setTypeParameters(typeParameters);
        this.setName(name);
        this.setParameters(parameters);
        this.setThrownExceptions(thrownExceptions);
    }

    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    public T setModifiers(EnumSet<Modifier> modifiers) {
        Utils.assertNotNull(modifiers);
        if (modifiers == this.modifiers) {
            return (T)this;
        }
        this.notifyPropertyChange(ObservableProperty.MODIFIERS, this.modifiers, modifiers);
        this.modifiers = modifiers;
        return (T)this;
    }

    public SimpleName getName() {
        return this.name;
    }

    public T setName(SimpleName name) {
        Utils.assertNotNull(name);
        if (name == this.name) {
            return (T)this;
        }
        this.notifyPropertyChange(ObservableProperty.NAME, this.name, name);
        if (this.name != null) {
            this.name.setParentNode(null);
        }
        this.name = name;
        this.setAsParentNodeOf(name);
        return (T)this;
    }

    public NodeList<Parameter> getParameters() {
        return this.parameters;
    }

    public T setParameters(NodeList<Parameter> parameters) {
        Utils.assertNotNull(parameters);
        if (parameters == this.parameters) {
            return (T)this;
        }
        this.notifyPropertyChange(ObservableProperty.PARAMETERS, this.parameters, parameters);
        if (this.parameters != null) {
            this.parameters.setParentNode(null);
        }
        this.parameters = parameters;
        this.setAsParentNodeOf(parameters);
        return (T)this;
    }

    public NodeList<ReferenceType<?>> getThrownExceptions() {
        return this.thrownExceptions;
    }

    public T setThrownExceptions(NodeList<ReferenceType<?>> thrownExceptions) {
        Utils.assertNotNull(thrownExceptions);
        if (thrownExceptions == this.thrownExceptions) {
            return (T)this;
        }
        this.notifyPropertyChange(ObservableProperty.THROWN_EXCEPTIONS, this.thrownExceptions, thrownExceptions);
        if (this.thrownExceptions != null) {
            this.thrownExceptions.setParentNode(null);
        }
        this.thrownExceptions = thrownExceptions;
        this.setAsParentNodeOf(thrownExceptions);
        return (T)this;
    }

    public NodeList<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public T setTypeParameters(NodeList<TypeParameter> typeParameters) {
        Utils.assertNotNull(typeParameters);
        if (typeParameters == this.typeParameters) {
            return (T)this;
        }
        this.notifyPropertyChange(ObservableProperty.TYPE_PARAMETERS, this.typeParameters, typeParameters);
        if (this.typeParameters != null) {
            this.typeParameters.setParentNode(null);
        }
        this.typeParameters = typeParameters;
        this.setAsParentNodeOf(typeParameters);
        return (T)this;
    }

    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows) {
        return this.getDeclarationAsString(includingModifiers, includingThrows, true);
    }

    public String getDeclarationAsString() {
        return this.getDeclarationAsString(true, true, true);
    }

    public abstract String getDeclarationAsString(boolean var1, boolean var2, boolean var3);

    protected String appendThrowsIfRequested(boolean includingThrows) {
        StringBuilder sb = new StringBuilder();
        if (includingThrows) {
            boolean firstThrow = true;
            for (ReferenceType<?> thr : this.getThrownExceptions()) {
                if (firstThrow) {
                    firstThrow = false;
                    sb.append(" throws ");
                } else {
                    sb.append(", ");
                }
                sb.append(thr.toString(prettyPrinterNoCommentsConfiguration));
            }
        }
        return sb.toString();
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        return Arrays.asList(this.getParameters(), this.getThrownExceptions(), this.getTypeParameters(), this.getAnnotations());
    }

    @Override
    public boolean remove(Node node) {
        int i;
        if (node == null) {
            return false;
        }
        for (i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i) != node) continue;
            this.parameters.remove(i);
            return true;
        }
        for (i = 0; i < this.thrownExceptions.size(); ++i) {
            if (this.thrownExceptions.get(i) != node) continue;
            this.thrownExceptions.remove(i);
            return true;
        }
        for (i = 0; i < this.typeParameters.size(); ++i) {
            if (this.typeParameters.get(i) != node) continue;
            this.typeParameters.remove(i);
            return true;
        }
        return super.remove(node);
    }

    @Override
    public CallableDeclaration<?> clone() {
        return (CallableDeclaration)this.accept(new CloneVisitor(), null);
    }

    @Override
    public CallableDeclarationMetaModel getMetaModel() {
        return JavaParserMetaModel.callableDeclarationMetaModel;
    }
}

