/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.comments;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.comments.JavadocDescriptionElement;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.JavadocDescriptionMetaModel;
import com.github.javaparser.utils.Utils;

public class JavadocDescription
extends Node {
    private NodeList<JavadocDescriptionElement> elements;

    public JavadocDescription() {
        this(new NodeList<JavadocDescriptionElement>());
    }

    @AllFieldsConstructor
    public JavadocDescription(NodeList<JavadocDescriptionElement> elements) {
        super(null);
        this.setElements(elements);
    }

    public JavadocDescription(TokenRange tokenRange, NodeList<JavadocDescriptionElement> elements) {
        super(tokenRange);
        this.setElements(elements);
        this.customInitialization();
    }

    public String toText() {
        StringBuilder sb = new StringBuilder();
        this.elements.forEach(e -> sb.append(e.toText()));
        return sb.toString();
    }

    public JavadocDescription setElements(NodeList<JavadocDescriptionElement> elements) {
        Utils.assertNotNull(elements);
        if (elements == this.elements) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.ELEMENTS, this.elements, elements);
        if (this.elements != null) {
            this.elements.setParentNode(null);
        }
        this.elements = elements;
        this.setAsParentNodeOf(elements);
        return this;
    }

    public NodeList<JavadocDescriptionElement> getElements() {
        return this.elements;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.elements.get(i) != node) continue;
            this.elements.remove(i);
            return true;
        }
        return super.remove(node);
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.elements.get(i) != node) continue;
            this.elements.set(i, (JavadocDescriptionElement)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public JavadocDescription clone() {
        return (JavadocDescription)this.accept(new CloneVisitor(), null);
    }

    @Override
    public JavadocDescriptionMetaModel getMetaModel() {
        return JavaParserMetaModel.javadocDescriptionMetaModel;
    }
}

