/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.comments;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.comments.JavadocDescription;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.JavadocBlockTagMetaModel;
import com.github.javaparser.utils.Utils;

public class JavadocBlockTag
extends Node {
    private JavadocDescription description;
    private BlockTagType type;

    public JavadocBlockTag(TokenRange tokenRange, JavadocDescription description, BlockTagType type) {
        super(tokenRange);
        this.setDescription(description);
        this.setType(type);
        this.customInitialization();
    }

    public JavadocBlockTag() {
        this(null, new JavadocDescription(), BlockTagType.UNKNOWN);
    }

    @AllFieldsConstructor
    public JavadocBlockTag(JavadocDescription description, BlockTagType type) {
        this(null, description, type);
    }

    public String toText() {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(this.type.toString());
        if (!this.description.toText().isEmpty()) {
            sb.append(" ");
            sb.append(this.description.toText());
        }
        return sb.toString();
    }

    public JavadocBlockTag setDescription(JavadocDescription description) {
        Utils.assertNotNull(description);
        if (description == this.description) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.DESCRIPTION, this.description, description);
        if (this.description != null) {
            this.description.setParentNode(null);
        }
        this.description = description;
        this.setAsParentNodeOf(description);
        return this;
    }

    public JavadocBlockTag setType(BlockTagType type) {
        Utils.assertNotNull(type);
        if (type == this.type) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.TYPE, this.type, type);
        this.type = type;
        return this;
    }

    public JavadocDescription getDescription() {
        return this.description;
    }

    public BlockTagType getType() {
        return this.type;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (node == this.description) {
            this.setDescription((JavadocDescription)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public JavadocBlockTag clone() {
        return (JavadocBlockTag)this.accept(new CloneVisitor(), null);
    }

    @Override
    public JavadocBlockTagMetaModel getMetaModel() {
        return JavaParserMetaModel.javadocBlockTagMetaModel;
    }

    public static enum BlockTagType {
        AUTHOR,
        DEPRECATED,
        EXCEPTION,
        PARAM,
        RETURN,
        SEE,
        SERIAL,
        SERIAL_DATA,
        SERIAL_FIELD,
        SINCE,
        THROWS,
        VERSION,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

