/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.Provider;
import java.io.IOException;

public class UnicodeEscapeProcessingProvider
implements Provider {
    private static final char BACKSLASH = '\\';
    private static final int EOF = -1;
    private char[] _data;
    private int _len = 0;
    private int _pos = 0;
    private boolean _backslashSeen;
    private Provider _input;

    public UnicodeEscapeProcessingProvider(Provider input) {
        this(2048, input);
    }

    public UnicodeEscapeProcessingProvider(int bufferSize, Provider input) {
        this._input = input;
        this._data = new char[bufferSize];
    }

    @Override
    public int read(char[] buffer, int offset, int len) throws IOException {
        int pos = offset;
        int stop = offset + len;
        while (pos < stop) {
            int ch = this.nextOutputChar();
            if (ch < 0) {
                if (pos != offset) break;
                return -1;
            }
            buffer[pos++] = (char)ch;
        }
        return pos - offset;
    }

    @Override
    public void close() throws IOException {
        this._input.close();
    }

    private int nextOutputChar() throws IOException {
        int next = this.nextInputChar();
        switch (next) {
            case -1: {
                return -1;
            }
            case 92: {
                if (this._backslashSeen) {
                    this._backslashSeen = false;
                    return next;
                }
                return this.backSlashSeen();
            }
        }
        this._backslashSeen = false;
        return next;
    }

    private int backSlashSeen() throws IOException {
        this._backslashSeen = true;
        int next = this.nextInputChar();
        switch (next) {
            case -1: {
                return 92;
            }
            case 117: {
                return this.unicodeStartSeen();
            }
        }
        this.pushBack(next);
        return 92;
    }

    private int unicodeStartSeen() throws IOException {
        int next;
        int uCnt = 1;
        block4: while (true) {
            next = this.nextInputChar();
            switch (next) {
                case -1: {
                    this.pushBackUs(uCnt);
                    return 92;
                }
                case 117: {
                    ++uCnt;
                    continue block4;
                }
            }
            break;
        }
        return this.readDigits(uCnt, next);
    }

    private int readDigits(int uCnt, int next3) throws IOException {
        int digit3 = UnicodeEscapeProcessingProvider.digit(next3);
        if (digit3 < 0) {
            this.pushBack(next3);
            this.pushBackUs(uCnt);
            return 92;
        }
        int next2 = this.nextInputChar();
        int digit2 = UnicodeEscapeProcessingProvider.digit(next2);
        if (digit2 < 0) {
            this.pushBack(next2);
            this.pushBack(next3);
            this.pushBackUs(uCnt);
            return 92;
        }
        int next1 = this.nextInputChar();
        int digit1 = UnicodeEscapeProcessingProvider.digit(next1);
        if (digit1 < 0) {
            this.pushBack(next1);
            this.pushBack(next2);
            this.pushBack(next3);
            this.pushBackUs(uCnt);
            return 92;
        }
        int next0 = this.nextInputChar();
        int digit0 = UnicodeEscapeProcessingProvider.digit(next0);
        if (digit0 < 0) {
            this.pushBack(next0);
            this.pushBack(next1);
            this.pushBack(next2);
            this.pushBack(next3);
            this.pushBackUs(uCnt);
            return 92;
        }
        int ch = digit3 << 12 | digit2 << 8 | digit1 << 4 | digit0;
        this._backslashSeen = false;
        return ch;
    }

    private void pushBackUs(int cnt) {
        for (int n = 0; n < cnt; ++n) {
            this.pushBack(117);
        }
    }

    private static int digit(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 65 && ch <= 70) {
            return 10 + ch - 65;
        }
        if (ch >= 97 && ch <= 102) {
            return 10 + ch - 97;
        }
        return -1;
    }

    private int nextInputChar() throws IOException {
        while (this.isBufferEmpty()) {
            int direct = this.fillBuffer();
            if (direct >= 0) continue;
            return -1;
        }
        return this._data[this._pos++];
    }

    private boolean isBufferEmpty() {
        return this._pos >= this._len;
    }

    private int fillBuffer() throws IOException {
        this._pos = 0;
        int direct = this._input.read(this._data, 0, this._data.length);
        if (direct != 0) {
            this._len = direct;
        }
        return direct;
    }

    private void pushBack(int ch) {
        if (ch < 0) {
            return;
        }
        if (this.isBufferEmpty()) {
            this._pos = this._data.length;
            this._len = this._data.length;
        } else if (this._pos == 0) {
            if (this._len == this._data.length) {
                char[] newData = new char[this._data.length + 1024];
                this._len = newData.length;
                this._pos = newData.length - this._data.length;
                System.arraycopy(this._data, 0, newData, this._pos, this._data.length);
                this._data = newData;
            } else {
                int cnt = this._len - this._pos;
                this._pos = this._data.length - this._len;
                this._len = this._data.length;
                System.arraycopy(this._data, 0, this._data, this._pos, cnt);
            }
        }
        this._data[--this._pos] = (char)ch;
    }
}

