/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.CommentsInserter;
import com.github.javaparser.GeneratedJavaParser;
import com.github.javaparser.JavadocParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParseStart;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Problem;
import com.github.javaparser.Provider;
import com.github.javaparser.Providers;
import com.github.javaparser.Range;
import com.github.javaparser.Token;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.CommentsCollection;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.validator.ProblemReporter;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.TreeSet;

public final class JavaParser {
    private final CommentsInserter commentsInserter;
    private final ParserConfiguration configuration;
    private GeneratedJavaParser astParser = null;
    private static ParserConfiguration staticConfiguration = new ParserConfiguration();

    public JavaParser() {
        this(new ParserConfiguration());
    }

    public JavaParser(ParserConfiguration configuration) {
        this.configuration = configuration;
        this.commentsInserter = new CommentsInserter(configuration);
    }

    public static ParserConfiguration getStaticConfiguration() {
        return staticConfiguration;
    }

    public static void setStaticConfiguration(ParserConfiguration staticConfiguration) {
        JavaParser.staticConfiguration = staticConfiguration;
    }

    private GeneratedJavaParser getParserForProvider(Provider provider) {
        if (this.astParser == null) {
            this.astParser = new GeneratedJavaParser(provider);
        } else {
            this.astParser.reset(provider);
        }
        this.astParser.setTabSize(this.configuration.getTabSize());
        return this.astParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <N extends Node> ParseResult<N> parse(ParseStart<N> start, Provider provider) {
        Utils.assertNotNull(start);
        Utils.assertNotNull(provider);
        GeneratedJavaParser parser = this.getParserForProvider(provider);
        try {
            Object comments;
            Node resultNode = (Node)start.parse(parser);
            if (this.configuration.isAttributeComments()) {
                comments = parser.getCommentsCollection();
                this.commentsInserter.insertComments(resultNode, ((CommentsCollection)comments).copy().getComments());
            }
            this.configuration.getValidator().validate(resultNode, new ProblemReporter(parser.problems));
            parser.problems.sort(Problem.PROBLEM_BY_BEGIN_POSITION);
            comments = new ParseResult<Node>(resultNode, parser.problems, parser.getTokens(), parser.getCommentsCollection());
            return comments;
        }
        catch (ParseException p) {
            Token token = p.currentToken;
            Range range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.endColumn);
            parser.problems.add(new Problem(this.makeMessageForParseException(p), range, p));
            ParseResult<Object> parseResult = new ParseResult<Object>(null, parser.problems, parser.getTokens(), parser.getCommentsCollection());
            return parseResult;
        }
        catch (Exception e) {
            String message = e.getMessage() == null ? "Unknown error" : e.getMessage();
            parser.problems.add(new Problem(message, null, e));
            ParseResult<Object> parseResult = new ParseResult<Object>(null, parser.problems, parser.getTokens(), parser.getCommentsCollection());
            return parseResult;
        }
        finally {
            try {
                provider.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String makeMessageForParseException(ParseException exception) {
        StringBuilder sb = new StringBuilder("Parse error. Found ");
        StringBuilder expected = new StringBuilder();
        int maxExpectedTokenSequenceLength = 0;
        TreeSet<String> sortedOptions = new TreeSet<String>();
        for (int i = 0; i < exception.expectedTokenSequences.length; ++i) {
            if (maxExpectedTokenSequenceLength < exception.expectedTokenSequences[i].length) {
                maxExpectedTokenSequenceLength = exception.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < exception.expectedTokenSequences[i].length; ++j) {
                sortedOptions.add(exception.tokenImage[exception.expectedTokenSequences[i][j]]);
            }
        }
        for (String option : sortedOptions) {
            expected.append(" ").append(option);
        }
        sb.append("");
        Token token = exception.currentToken.next;
        for (int i = 0; i < maxExpectedTokenSequenceLength; ++i) {
            String tokenText = token.image;
            String escapedTokenText = ParseException.add_escapes(tokenText);
            if (i != 0) {
                sb.append(" ");
            }
            if (token.kind == 0) {
                sb.append(exception.tokenImage[0]);
                break;
            }
            String image = exception.tokenImage[token.kind];
            escapedTokenText = "\"" + escapedTokenText + "\"";
            if (image.equals(escapedTokenText)) {
                sb.append(image);
            } else {
                sb.append(" ").append(escapedTokenText).append(" ").append(image);
            }
            token = token.next;
        }
        if (exception.expectedTokenSequences.length != 0) {
            int numExpectedTokens = exception.expectedTokenSequences.length;
            sb.append(", expected").append(numExpectedTokens == 1 ? "" : " one of ").append(expected.toString());
        }
        return sb.toString();
    }

    public static CompilationUnit parse(InputStream in, Charset encoding) {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.provider(in, encoding));
    }

    public static CompilationUnit parse(InputStream in) {
        return JavaParser.parse(in, Providers.UTF8);
    }

    public static CompilationUnit parse(File file, Charset encoding) throws FileNotFoundException {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.provider(file, encoding));
    }

    public static CompilationUnit parse(File file) throws FileNotFoundException {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.provider(file));
    }

    public static CompilationUnit parse(Path path, Charset encoding) throws IOException {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.provider(path, encoding));
    }

    public static CompilationUnit parse(Path path) throws IOException {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.provider(path));
    }

    public static CompilationUnit parseResource(String path) throws IOException {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.resourceProvider(path));
    }

    public static CompilationUnit parseResource(String path, Charset encoding) throws IOException {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.resourceProvider(path, encoding));
    }

    public static CompilationUnit parseResource(ClassLoader classLoader, String path, Charset encoding) throws IOException {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.resourceProvider(classLoader, path, encoding));
    }

    public static CompilationUnit parse(Reader reader) {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.provider(reader));
    }

    public static CompilationUnit parse(String code) {
        return JavaParser.simplifiedParse(ParseStart.COMPILATION_UNIT, Providers.provider(code));
    }

    public static BlockStmt parseBlock(String blockStatement) {
        return JavaParser.simplifiedParse(ParseStart.BLOCK, Providers.provider(blockStatement));
    }

    public static Statement parseStatement(String statement) {
        return JavaParser.simplifiedParse(ParseStart.STATEMENT, Providers.provider(statement));
    }

    private static <T extends Node> T simplifiedParse(ParseStart<T> context, Provider provider) {
        ParseResult<T> result = new JavaParser(staticConfiguration).parse(context, provider);
        if (result.isSuccessful()) {
            return (T)((Node)result.getResult().get());
        }
        throw new ParseProblemException(result.getProblems());
    }

    public static ImportDeclaration parseImport(String importDeclaration) {
        return JavaParser.simplifiedParse(ParseStart.IMPORT_DECLARATION, Providers.provider(importDeclaration));
    }

    public static <T extends Expression> T parseExpression(String expression) {
        return (T)JavaParser.simplifiedParse(ParseStart.EXPRESSION, Providers.provider(expression));
    }

    public static AnnotationExpr parseAnnotation(String annotation) {
        return JavaParser.simplifiedParse(ParseStart.ANNOTATION, Providers.provider(annotation));
    }

    public static BodyDeclaration<?> parseAnnotationBodyDeclaration(String body) {
        return JavaParser.simplifiedParse(ParseStart.ANNOTATION_BODY, Providers.provider(body));
    }

    public static BodyDeclaration<?> parseClassBodyDeclaration(String body) {
        return JavaParser.simplifiedParse(ParseStart.CLASS_BODY, Providers.provider(body));
    }

    public static BodyDeclaration parseInterfaceBodyDeclaration(String body) {
        return JavaParser.simplifiedParse(ParseStart.INTERFACE_BODY, Providers.provider(body));
    }

    public static ClassOrInterfaceType parseClassOrInterfaceType(String type) {
        return JavaParser.simplifiedParse(ParseStart.CLASS_OR_INTERFACE_TYPE, Providers.provider(type));
    }

    public static VariableDeclarationExpr parseVariableDeclarationExpr(String declaration) {
        return JavaParser.simplifiedParse(ParseStart.VARIABLE_DECLARATION_EXPR, Providers.provider(declaration));
    }

    public static Javadoc parseJavadoc(String content) {
        return JavadocParser.parse(content);
    }

    public static ExplicitConstructorInvocationStmt parseExplicitConstructorInvocationStmt(String statement) {
        return JavaParser.simplifiedParse(ParseStart.EXPLICIT_CONSTRUCTOR_INVOCATION_STMT, Providers.provider(statement));
    }

    public static Name parseName(String qualifiedName) {
        return JavaParser.simplifiedParse(ParseStart.NAME, Providers.provider(qualifiedName));
    }

    public static Parameter parseParameter(String parameter) {
        return JavaParser.simplifiedParse(ParseStart.PARAMETER, Providers.provider(parameter));
    }
}

