/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.stmt;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithBody;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.ForeachStmtMetaModel;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.utils.Utils;

public final class ForeachStmt
extends Statement
implements NodeWithBody<ForeachStmt> {
    private VariableDeclarationExpr variable;
    private Expression iterable;
    private Statement body;

    public ForeachStmt() {
        this(null, new VariableDeclarationExpr(), new NameExpr(), new ReturnStmt());
    }

    @AllFieldsConstructor
    public ForeachStmt(VariableDeclarationExpr variable, Expression iterable, Statement body) {
        this(null, variable, iterable, body);
    }

    public ForeachStmt(Range range, VariableDeclarationExpr variable, Expression iterable, Statement body) {
        super(range);
        this.setVariable(variable);
        this.setIterable(iterable);
        this.setBody(body);
    }

    public ForeachStmt(VariableDeclarationExpr variable, String iterable, BlockStmt body) {
        this(null, variable, new NameExpr(iterable), body);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public Statement getBody() {
        return this.body;
    }

    public Expression getIterable() {
        return this.iterable;
    }

    public VariableDeclarationExpr getVariable() {
        return this.variable;
    }

    @Override
    public ForeachStmt setBody(Statement body) {
        Utils.assertNotNull(body);
        this.notifyPropertyChange(ObservableProperty.BODY, this.body, body);
        if (this.body != null) {
            this.body.setParentNode(null);
        }
        this.body = body;
        this.setAsParentNodeOf(body);
        return this;
    }

    public ForeachStmt setIterable(Expression iterable) {
        Utils.assertNotNull(iterable);
        this.notifyPropertyChange(ObservableProperty.ITERABLE, this.iterable, iterable);
        if (this.iterable != null) {
            this.iterable.setParentNode(null);
        }
        this.iterable = iterable;
        this.setAsParentNodeOf(iterable);
        return this;
    }

    public ForeachStmt setVariable(VariableDeclarationExpr variable) {
        Utils.assertNotNull(variable);
        this.notifyPropertyChange(ObservableProperty.VARIABLE, this.variable, variable);
        if (this.variable != null) {
            this.variable.setParentNode(null);
        }
        this.variable = variable;
        this.setAsParentNodeOf(variable);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    @Override
    public ForeachStmt clone() {
        return (ForeachStmt)this.accept(new CloneVisitor(), null);
    }

    @Override
    public ForeachStmtMetaModel getMetaModel() {
        return JavaParserMetaModel.foreachStmtMetaModel;
    }
}

