/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.Range;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public class Problem {
    private final String message;
    private final Range location;
    private final Throwable cause;

    public Problem(String message, Range location, Throwable cause) {
        Utils.assertNotNull(message);
        this.message = message;
        this.location = location;
        this.cause = cause;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getVerboseMessage());
        if (this.cause != null) {
            str.append(Utils.EOL).append("Problem stacktrace : ").append(Utils.EOL);
            for (int i = 0; i < this.cause.getStackTrace().length; ++i) {
                StackTraceElement ste = this.cause.getStackTrace()[i];
                str.append("  ").append(ste.toString());
                if (i + 1 == this.cause.getStackTrace().length) continue;
                str.append(Utils.EOL);
            }
        }
        return str.toString();
    }

    public String getMessage() {
        return this.message;
    }

    public String getVerboseMessage() {
        return this.getLocation().map(l -> l.begin + " " + this.message).orElse(this.message);
    }

    public Optional<Range> getLocation() {
        return Optional.ofNullable(this.location);
    }

    @Deprecated
    public Optional<Range> getRange() {
        return this.getLocation();
    }

    public Optional<Throwable> getCause() {
        return Optional.ofNullable(this.cause);
    }
}

