/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer.lexicalpreservation;

import com.github.javaparser.GeneratedJavaParserConstants;
import com.github.javaparser.JavaToken;
import com.github.javaparser.ast.Node;
import com.github.javaparser.printer.TokenConstants;
import com.github.javaparser.printer.lexicalpreservation.TextElement;
import com.github.javaparser.utils.Utils;

class TokenTextElement
extends TextElement {
    private int tokenKind;
    private String text;

    public static TokenTextElement newLine() {
        return new TokenTextElement(TokenConstants.NEWLINE_TOKEN, Utils.EOL);
    }

    TokenTextElement(JavaToken token) {
        this(token.getKind(), token.getText());
    }

    TokenTextElement(int tokenKind, String text) {
        this.tokenKind = tokenKind;
        this.text = text;
    }

    TokenTextElement(int tokenKind) {
        String content = GeneratedJavaParserConstants.tokenImage[tokenKind];
        if (content.startsWith("\"")) {
            content = content.substring(1, content.length() - 1);
        }
        if (tokenKind == TokenConstants.NEWLINE_TOKEN) {
            content = Utils.EOL;
        } else if (tokenKind == TokenConstants.SPACE_TOKEN) {
            content = " ";
        }
        this.tokenKind = tokenKind;
        this.text = content;
    }

    @Override
    String expand() {
        return this.text;
    }

    String getText() {
        return this.text;
    }

    public int getTokenKind() {
        return this.tokenKind;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenTextElement that = (TokenTextElement)o;
        if (this.tokenKind != that.tokenKind) {
            return false;
        }
        return this.text.equals(that.text);
    }

    public int hashCode() {
        int result = this.tokenKind;
        result = 31 * result + this.text.hashCode();
        return result;
    }

    public String toString() {
        return "TokenTextElement(" + this.tokenKind + ") {" + this.text + '}';
    }

    @Override
    boolean isToken(int tokenKind) {
        return this.tokenKind == tokenKind;
    }

    @Override
    boolean isNode(Node node) {
        return false;
    }

    @Override
    public boolean isWhiteSpace() {
        return TokenConstants.isWhitespace(this.tokenKind);
    }

    @Override
    public boolean isSpaceOrTab() {
        return TokenConstants.isSpaceOrTab(this.tokenKind);
    }

    boolean isWhiteSpaceOrComment() {
        return TokenConstants.isWhitespaceOrComment(this.tokenKind);
    }

    @Override
    public boolean isNewline() {
        return this.tokenKind == TokenConstants.NEWLINE_TOKEN;
    }
}

