/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer.concretesyntaxmodel;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.printer.SourcePrinter;
import com.github.javaparser.printer.concretesyntaxmodel.CsmElement;
import com.github.javaparser.printer.concretesyntaxmodel.CsmNone;

public class CsmConditional
implements CsmElement {
    private Condition condition;
    private ObservableProperty property;
    private CsmElement thenElement;
    private CsmElement elseElement;

    public CsmConditional(ObservableProperty property, Condition condition, CsmElement thenElement, CsmElement elseElement) {
        this.property = property;
        this.condition = condition;
        this.thenElement = thenElement;
        this.elseElement = elseElement;
    }

    public CsmConditional(ObservableProperty property, Condition condition, CsmElement thenElement) {
        this(property, condition, thenElement, new CsmNone());
    }

    @Override
    public void prettyPrint(Node node, SourcePrinter printer) {
        boolean test = this.condition.evaluate(node, this.property);
        if (test) {
            this.thenElement.prettyPrint(node, printer);
        } else {
            this.elseElement.prettyPrint(node, printer);
        }
    }

    public static enum Condition {
        IS_EMPTY,
        IS_NOT_EMPTY,
        IS_PRESENT,
        FLAG;


        boolean evaluate(Node node, ObservableProperty property) {
            if (this == IS_PRESENT) {
                return !property.isNullOrEmpty(node);
            }
            if (this == FLAG) {
                return (Boolean)property.singleValueFor(node);
            }
            if (this == IS_EMPTY) {
                return property.listValueFor(node).isEmpty();
            }
            if (this == IS_NOT_EMPTY) {
                NodeList<? extends Node> value = property.listValueFor(node);
                return value != null && !value.isEmpty();
            }
            throw new UnsupportedOperationException(this.name());
        }
    }
}

