/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer.concretesyntaxmodel;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.printer.SourcePrinter;
import com.github.javaparser.printer.concretesyntaxmodel.CsmElement;

public class CsmComment
implements CsmElement {
    static void process(Comment comment, SourcePrinter printer) {
        if (comment instanceof BlockComment) {
            printer.print("/*");
            printer.print(comment.getContent());
            printer.print("*/\n");
        } else if (comment instanceof JavadocComment) {
            printer.print("/**");
            printer.print(comment.getContent());
            printer.print("*/\n");
        } else if (comment instanceof LineComment) {
            printer.print("//");
            printer.print(comment.getContent());
            printer.println();
        } else {
            throw new UnsupportedOperationException(comment.getClass().getSimpleName());
        }
    }

    @Override
    public void prettyPrint(Node node, SourcePrinter printer) {
        if (node.hasComment()) {
            Comment comment = node.getComment().get();
            CsmComment.process(comment, printer);
        }
    }
}

