/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.type;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.WildcardTypeMetaModel;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public final class WildcardType
extends Type
implements NodeWithAnnotations<WildcardType> {
    private ReferenceType extendedTypes;
    private ReferenceType superTypes;

    public WildcardType() {
        this(null, null, null);
    }

    public WildcardType(ReferenceType extendedTypes) {
        this(null, extendedTypes, null);
    }

    @AllFieldsConstructor
    public WildcardType(ReferenceType extendedTypes, ReferenceType superTypes) {
        this(null, extendedTypes, superTypes);
    }

    public WildcardType(Range range, ReferenceType extendedTypes, ReferenceType superTypes) {
        super(range, new NodeList<AnnotationExpr>());
        this.setExtendedTypes(extendedTypes);
        this.setSuperTypes(superTypes);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Optional<ReferenceType> getExtendedTypes() {
        return Optional.ofNullable(this.extendedTypes);
    }

    public Optional<ReferenceType> getSuperTypes() {
        return Optional.ofNullable(this.superTypes);
    }

    public WildcardType setExtendedTypes(ReferenceType extendedTypes) {
        this.notifyPropertyChange(ObservableProperty.EXTENDED_TYPES, this.extendedTypes, extendedTypes);
        if (this.extendedTypes != null) {
            this.extendedTypes.setParentNode(null);
        }
        this.extendedTypes = extendedTypes;
        this.setAsParentNodeOf(extendedTypes);
        return this;
    }

    public WildcardType setSuperTypes(ReferenceType superTypes) {
        this.notifyPropertyChange(ObservableProperty.SUPER_TYPES, this.superTypes, superTypes);
        if (this.superTypes != null) {
            this.superTypes.setParentNode(null);
        }
        this.superTypes = superTypes;
        this.setAsParentNodeOf(superTypes);
        return this;
    }

    @Override
    public WildcardType setAnnotations(NodeList<AnnotationExpr> annotations) {
        return (WildcardType)super.setAnnotations(annotations);
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        return Arrays.asList(this.getAnnotations());
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        if (this.extendedTypes != null && node == this.extendedTypes) {
            this.removeExtendedTypes();
            return true;
        }
        if (this.superTypes != null && node == this.superTypes) {
            this.removeSuperTypes();
            return true;
        }
        return super.remove(node);
    }

    public WildcardType removeExtendedTypes() {
        return this.setExtendedTypes(null);
    }

    public WildcardType removeSuperTypes() {
        return this.setSuperTypes(null);
    }

    @Override
    public WildcardType clone() {
        return (WildcardType)this.accept(new CloneVisitor(), null);
    }

    @Override
    public WildcardTypeMetaModel getMetaModel() {
        return JavaParserMetaModel.wildcardTypeMetaModel;
    }
}

