/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.stmt;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.IfStmtMetaModel;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public final class IfStmt
extends Statement {
    private Expression condition;
    private Statement thenStmt;
    private Statement elseStmt;

    public IfStmt() {
        this(null, new BooleanLiteralExpr(), new ReturnStmt(), null);
    }

    @AllFieldsConstructor
    public IfStmt(Expression condition, Statement thenStmt, Statement elseStmt) {
        this(null, condition, thenStmt, elseStmt);
    }

    public IfStmt(Range range, Expression condition, Statement thenStmt, Statement elseStmt) {
        super(range);
        this.setCondition(condition);
        this.setThenStmt(thenStmt);
        this.setElseStmt(elseStmt);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Optional<Statement> getElseStmt() {
        return Optional.ofNullable(this.elseStmt);
    }

    public Statement getThenStmt() {
        return this.thenStmt;
    }

    public IfStmt setCondition(Expression condition) {
        Utils.assertNotNull(condition);
        this.notifyPropertyChange(ObservableProperty.CONDITION, this.condition, condition);
        if (this.condition != null) {
            this.condition.setParentNode(null);
        }
        this.condition = condition;
        this.setAsParentNodeOf(condition);
        return this;
    }

    public IfStmt setElseStmt(Statement elseStmt) {
        this.notifyPropertyChange(ObservableProperty.ELSE_STMT, this.elseStmt, elseStmt);
        if (this.elseStmt != null) {
            this.elseStmt.setParentNode(null);
        }
        this.elseStmt = elseStmt;
        this.setAsParentNodeOf(elseStmt);
        return this;
    }

    public IfStmt setThenStmt(Statement thenStmt) {
        Utils.assertNotNull(thenStmt);
        this.notifyPropertyChange(ObservableProperty.THEN_STMT, this.thenStmt, thenStmt);
        if (this.thenStmt != null) {
            this.thenStmt.setParentNode(null);
        }
        this.thenStmt = thenStmt;
        this.setAsParentNodeOf(thenStmt);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        if (this.elseStmt != null && node == this.elseStmt) {
            this.removeElseStmt();
            return true;
        }
        return super.remove(node);
    }

    public IfStmt removeElseStmt() {
        return this.setElseStmt(null);
    }

    @Override
    public IfStmt clone() {
        return (IfStmt)this.accept(new CloneVisitor(), null);
    }

    @Override
    public IfStmtMetaModel getMetaModel() {
        return JavaParserMetaModel.ifStmtMetaModel;
    }
}

