/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.utils.PositionUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

class CommentsInserter {
    private final ParserConfiguration configuration;

    CommentsInserter(ParserConfiguration configuration) {
        this.configuration = configuration;
    }

    private void insertComments(CompilationUnit cu, TreeSet<Comment> comments) {
        if (comments.isEmpty()) {
            return;
        }
        List<Node> children = cu.getChildNodes();
        Comment firstComment = comments.iterator().next();
        if (cu.getPackageDeclaration().isPresent() && (children.isEmpty() || PositionUtils.areInOrder(firstComment, cu.getPackageDeclaration().get()))) {
            cu.setComment(firstComment);
            comments.remove(firstComment);
        }
    }

    void insertComments(Node node, TreeSet<Comment> commentsToAttribute) {
        if (commentsToAttribute.isEmpty()) {
            return;
        }
        if (node instanceof CompilationUnit) {
            this.insertComments((CompilationUnit)node, commentsToAttribute);
        }
        List<Node> children = node.getChildNodes();
        for (Node child : children) {
            TreeSet<Node> commentsInsideChild = new TreeSet<Node>(Node.NODE_BY_BEGIN_POSITION);
            commentsInsideChild.addAll(commentsToAttribute.stream().filter(c -> c.getRange().isPresent()).filter(c -> PositionUtils.nodeContains(child, c, this.configuration.isDoNotConsiderAnnotationsAsNodeStartForCodeAttribution())).collect(Collectors.toList()));
            commentsToAttribute.removeAll(commentsInsideChild);
            this.insertComments(child, commentsInsideChild);
        }
        this.attributeLineCommentsOnSameLine(commentsToAttribute, children);
        Comment previousComment = null;
        LinkedList<Comment> attributedComments = new LinkedList<Comment>();
        LinkedList<Node> childrenAndComments = new LinkedList<Node>();
        childrenAndComments.addAll(children);
        commentsToAttribute.removeAll(attributedComments);
        childrenAndComments.addAll(commentsToAttribute);
        PositionUtils.sortByBeginPosition(childrenAndComments, this.configuration.isDoNotConsiderAnnotationsAsNodeStartForCodeAttribution());
        for (Node thing : childrenAndComments) {
            if (thing instanceof Comment) {
                previousComment = (Comment)thing;
                if (previousComment.isOrphan()) continue;
                previousComment = null;
                continue;
            }
            if (previousComment == null || thing.getComment().isPresent() || this.configuration.isDoNotAssignCommentsPrecedingEmptyLines() && this.thereAreLinesBetween(previousComment, thing)) continue;
            thing.setComment(previousComment);
            attributedComments.add(previousComment);
            previousComment = null;
        }
        commentsToAttribute.removeAll(attributedComments);
        for (Comment c2 : commentsToAttribute) {
            if (!c2.isOrphan()) continue;
            node.addOrphanComment(c2);
        }
    }

    private void attributeLineCommentsOnSameLine(TreeSet<Comment> commentsToAttribute, List<Node> children) {
        LinkedList attributedComments = new LinkedList();
        commentsToAttribute.stream().filter(comment -> comment.getRange().isPresent()).filter(Comment::isLineComment).forEach(comment -> children.stream().filter(child -> child.getRange().isPresent()).forEach(child -> {
            Range commentRange = comment.getRange().get();
            Range childRange = child.getRange().get();
            if (childRange.end.line == commentRange.begin.line && this.attributeLineCommentToNodeOrChild((Node)child, comment.asLineComment())) {
                attributedComments.add(comment);
            }
        }));
        commentsToAttribute.removeAll(attributedComments);
    }

    private boolean attributeLineCommentToNodeOrChild(Node node, LineComment lineComment) {
        if (!node.getRange().isPresent() || !lineComment.getRange().isPresent()) {
            return false;
        }
        if (node.getBegin().get().line == lineComment.getBegin().get().line && !node.getComment().isPresent()) {
            if (!(node instanceof Comment)) {
                node.setComment(lineComment);
            }
            return true;
        }
        LinkedList<Node> children = new LinkedList<Node>();
        children.addAll(node.getChildNodes());
        PositionUtils.sortByBeginPosition(children);
        Collections.reverse(children);
        for (Node child : children) {
            if (!this.attributeLineCommentToNodeOrChild(child, lineComment)) continue;
            return true;
        }
        return false;
    }

    private boolean thereAreLinesBetween(Node a, Node b) {
        if (!a.getRange().isPresent() || !b.getRange().isPresent()) {
            return true;
        }
        if (!PositionUtils.areInOrder(a, b)) {
            return this.thereAreLinesBetween(b, a);
        }
        int endOfA = a.getEnd().get().line;
        return b.getBegin().get().line > endOfA + 1;
    }
}

