/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.type;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Pair;
import com.github.javaparser.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class ArrayType
extends ReferenceType
implements NodeWithAnnotations<ArrayType> {
    private Type componentType;

    @AllFieldsConstructor
    public ArrayType(Type componentType, NodeList<AnnotationExpr> annotations) {
        this(null, componentType, annotations);
    }

    public ArrayType(Type type, AnnotationExpr ... annotations) {
        this(type, (NodeList<AnnotationExpr>)NodeList.nodeList((Node[])annotations));
    }

    public ArrayType(Range range, Type componentType, NodeList<AnnotationExpr> annotations) {
        super(range);
        this.setComponentType(componentType);
        this.setAnnotations((NodeList)annotations);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Type getComponentType() {
        return this.componentType;
    }

    public ArrayType setComponentType(Type componentType) {
        Utils.assertNotNull(componentType);
        this.notifyPropertyChange(ObservableProperty.COMPONENT_TYPE, this.componentType, componentType);
        if (this.componentType != null) {
            this.componentType.setParentNode(null);
        }
        this.componentType = componentType;
        this.setAsParentNodeOf(componentType);
        return this;
    }

    @SafeVarargs
    public static Type wrapInArrayTypes(Type type, List<ArrayBracketPair> ... arrayBracketPairLists) {
        for (int i = arrayBracketPairLists.length - 1; i >= 0; --i) {
            List<ArrayBracketPair> arrayBracketPairList = arrayBracketPairLists[i];
            if (arrayBracketPairList == null) continue;
            for (int j = arrayBracketPairList.size() - 1; j >= 0; --j) {
                ArrayBracketPair pair = arrayBracketPairList.get(j);
                Range range = null;
                if (type.getRange().isPresent() && pair.getRange().isPresent()) {
                    range = new Range(type.getBegin().get(), pair.getRange().get().end);
                }
                type = new ArrayType(range, type, pair.getAnnotations());
            }
        }
        return type;
    }

    public static Pair<Type, List<ArrayBracketPair>> unwrapArrayTypes(Type type) {
        ArrayList<ArrayBracketPair> arrayBracketPairs = new ArrayList<ArrayBracketPair>(0);
        while (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            arrayBracketPairs.add(new ArrayBracketPair(type.getRange().orElse(null), arrayType.getAnnotations()));
            type = arrayType.getComponentType();
        }
        return new Pair<Type, List<ArrayBracketPair>>(type, arrayBracketPairs);
    }

    @Override
    public ArrayType setAnnotations(NodeList<AnnotationExpr> annotations) {
        return (ArrayType)super.setAnnotations(annotations);
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        return Arrays.asList(this.getAnnotations());
    }

    public static class ArrayBracketPair {
        private Range range;
        private NodeList<AnnotationExpr> annotations = new NodeList();

        public ArrayBracketPair(Range range, NodeList<AnnotationExpr> annotations) {
            this.setRange(range);
            this.setAnnotations(annotations);
        }

        public NodeList<AnnotationExpr> getAnnotations() {
            return this.annotations;
        }

        public ArrayBracketPair setAnnotations(NodeList<AnnotationExpr> annotations) {
            this.annotations = Utils.assertNotNull(annotations);
            return this;
        }

        public ArrayBracketPair setRange(Range range) {
            this.range = range;
            return this;
        }

        public Optional<Range> getRange() {
            return Optional.ofNullable(this.range);
        }
    }
}

