/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.nodeTypes.NodeWithIdentifier;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public class Name
extends Node
implements NodeWithIdentifier<Name> {
    private String identifier;
    private Name qualifier;

    public Name() {
        this(null, null, "empty");
    }

    public Name(String identifier) {
        this(null, null, identifier);
    }

    @AllFieldsConstructor
    public Name(Name qualifier, String identifier) {
        this(null, qualifier, identifier);
    }

    public Name(Range range, Name qualifier, String identifier) {
        super(range);
        this.setIdentifier(identifier);
        this.setQualifier(qualifier);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public final String getIdentifier() {
        return this.identifier;
    }

    @Override
    public Name setIdentifier(String identifier) {
        Utils.assertNonEmpty(identifier);
        this.notifyPropertyChange(ObservableProperty.IDENTIFIER, this.identifier, identifier);
        this.identifier = identifier;
        return this;
    }

    public static Name parse(String qualifiedName) {
        Utils.assertNonEmpty(qualifiedName);
        String[] split = qualifiedName.split("\\.");
        Name ret = new Name(split[0]);
        for (int i = 1; i < split.length; ++i) {
            ret = new Name(ret, split[i]);
        }
        return ret;
    }

    public String asString() {
        if (this.qualifier != null) {
            return this.qualifier.asString() + "." + this.identifier;
        }
        return this.identifier;
    }

    public Optional<Name> getQualifier() {
        return Optional.ofNullable(this.qualifier);
    }

    public Name setQualifier(Name qualifier) {
        this.notifyPropertyChange(ObservableProperty.QUALIFIER, this.qualifier, qualifier);
        if (this.qualifier != null) {
            this.qualifier.setParentNode(null);
        }
        this.qualifier = qualifier;
        this.setAsParentNodeOf(qualifier);
        return this;
    }
}

