/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;

public final class ArrayAccessExpr
extends Expression {
    private Expression name;
    private Expression index;

    public ArrayAccessExpr() {
        this(null, new NameExpr(), new IntegerLiteralExpr());
    }

    @AllFieldsConstructor
    public ArrayAccessExpr(Expression name, Expression index) {
        this(null, name, index);
    }

    public ArrayAccessExpr(Range range, Expression name, Expression index) {
        super(range);
        this.setName(name);
        this.setIndex(index);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Expression getIndex() {
        return this.index;
    }

    public Expression getName() {
        return this.name;
    }

    public ArrayAccessExpr setIndex(Expression index) {
        Utils.assertNotNull(index);
        this.notifyPropertyChange(ObservableProperty.INDEX, this.index, index);
        if (this.index != null) {
            this.index.setParentNode(null);
        }
        this.index = index;
        this.setAsParentNodeOf(index);
        return this;
    }

    public ArrayAccessExpr setName(Expression name) {
        Utils.assertNotNull(name);
        this.notifyPropertyChange(ObservableProperty.NAME, this.name, name);
        if (this.name != null) {
            this.name.setParentNode(null);
        }
        this.name = name;
        this.setAsParentNodeOf(name);
        return this;
    }
}

