/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public final class VariableDeclarator
extends Node
implements NodeWithType<VariableDeclarator, Type>,
NodeWithSimpleName<VariableDeclarator> {
    private SimpleName name;
    private Expression initializer;
    private Type type;

    public VariableDeclarator() {
        this(null, new SimpleName(), null);
    }

    public VariableDeclarator(Type type, String variableName) {
        this(null, type, new SimpleName(variableName), null);
    }

    public VariableDeclarator(Type type, SimpleName name) {
        this(null, type, name, null);
    }

    public VariableDeclarator(Type type, String variableName, Expression initializer) {
        this(null, type, new SimpleName(variableName), initializer);
    }

    @AllFieldsConstructor
    public VariableDeclarator(Type type, SimpleName name, Expression initializer) {
        this(null, type, name, initializer);
    }

    public VariableDeclarator(Range range, Type type, SimpleName name, Expression initializer) {
        super(range);
        this.setName(name);
        this.setInitializer(initializer);
        this.setType(type);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Optional<Expression> getInitializer() {
        return Optional.ofNullable(this.initializer);
    }

    @Override
    public SimpleName getName() {
        return this.name;
    }

    @Override
    public VariableDeclarator setName(SimpleName name) {
        Utils.assertNotNull(name);
        this.notifyPropertyChange(ObservableProperty.NAME, this.name, name);
        if (this.name != null) {
            this.name.setParentNode(null);
        }
        this.name = name;
        this.setAsParentNodeOf(name);
        return this;
    }

    public VariableDeclarator setInitializer(Expression initializer) {
        this.notifyPropertyChange(ObservableProperty.INITIALIZER, this.initializer, initializer);
        if (this.initializer != null) {
            this.initializer.setParentNode(null);
        }
        this.initializer = initializer;
        this.setAsParentNodeOf(initializer);
        return this;
    }

    public VariableDeclarator setInitializer(String init) {
        return this.setInitializer(new NameExpr(Utils.assertNonEmpty(init)));
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public VariableDeclarator setType(Type type) {
        Utils.assertNotNull(type);
        this.notifyPropertyChange(ObservableProperty.TYPE, this.type, type);
        if (this.type != null) {
            this.type.setParentNode(null);
        }
        this.type = type;
        this.setAsParentNodeOf(type);
        return this;
    }
}

