/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.utils;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Utils {
    public static final String EOL = System.getProperty("line.separator");

    public static <T> List<T> ensureNotNull(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    public static <E> boolean isNullOrEmpty(Collection<E> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> T assertNotNull(T o) {
        if (o == null) {
            throw new AssertionError((Object)"A reference was unexpectedly null.");
        }
        return o;
    }

    public static String assertNonEmpty(String string) {
        if (string == null || string.isEmpty()) {
            throw new AssertionError((Object)"A string was unexpectedly empty.");
        }
        return string;
    }

    public static String escapeEndOfLines(String string) {
        StringBuilder escapedString = new StringBuilder();
        block4: for (char c : string.toCharArray()) {
            switch (c) {
                case '\n': {
                    escapedString.append("\\n");
                    continue block4;
                }
                case '\r': {
                    escapedString.append("\\r");
                    continue block4;
                }
                default: {
                    escapedString.append(c);
                }
            }
        }
        return escapedString.toString();
    }

    public static String readerToString(Reader reader) throws IOException {
        int numChars;
        StringBuilder result = new StringBuilder();
        char[] buffer = new char[8192];
        while ((numChars = reader.read(buffer, 0, buffer.length)) > 0) {
            result.append(buffer, 0, numChars);
        }
        return result.toString();
    }

    public static <T> List<T> arrayToList(T[] array) {
        LinkedList list = new LinkedList();
        Collections.addAll(list, array);
        return list;
    }

    public static String toCamelCase(String original) {
        StringBuilder sb = new StringBuilder();
        String[] parts = original.toLowerCase().split("_");
        for (int i = 0; i < parts.length; ++i) {
            sb.append(i == 0 ? parts[i] : Utils.capitalize(parts[i]));
        }
        return sb.toString();
    }

    private static String capitalize(String original) {
        if (original.length() < 1) {
            throw new IllegalArgumentException("This string is empty");
        }
        if (original.length() == 1) {
            return original.toUpperCase();
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1);
    }

    public static String nextWord(String string) {
        int index;
        for (index = 0; index < string.length() && !Character.isWhitespace(string.charAt(index)); ++index) {
        }
        return string.substring(0, index);
    }
}

