/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.visitor;

import com.github.javaparser.ast.ArrayCreationLevel;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EmptyMemberDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.SuperExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.AssertStmt;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.BreakStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ContinueStmt;
import com.github.javaparser.ast.stmt.DoStmt;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.ForeachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.LabeledStmt;
import com.github.javaparser.ast.stmt.LocalClassDeclarationStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.SwitchEntryStmt;
import com.github.javaparser.ast.stmt.SwitchStmt;
import com.github.javaparser.ast.stmt.SynchronizedStmt;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.stmt.WhileStmt;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.IntersectionType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.type.UnionType;
import com.github.javaparser.ast.type.UnknownType;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.type.WildcardType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.Visitable;
import java.util.List;
import java.util.Optional;

public class EqualsVisitor
implements GenericVisitor<Boolean, Visitable> {
    private static final EqualsVisitor SINGLETON = new EqualsVisitor();

    public static boolean equals(Node n1, Node n2) {
        return SINGLETON.nodeEquals(n1, n2);
    }

    private EqualsVisitor() {
    }

    private boolean commonNodeEquality(Node n1, Node n2) {
        if (!this.nodeEquals(n1.getComment(), n2.getComment())) {
            return false;
        }
        return this.nodesEquals(n1.getOrphanComments(), n2.getOrphanComments());
    }

    private <T extends Node> boolean nodesEquals(List<T> nodes1, List<T> nodes2) {
        if (nodes1 == null) {
            return nodes2 == null;
        }
        if (nodes2 == null) {
            return false;
        }
        if (nodes1.size() != nodes2.size()) {
            return false;
        }
        for (int i = 0; i < nodes1.size(); ++i) {
            if (this.nodeEquals((Node)nodes1.get(i), (Node)nodes2.get(i))) continue;
            return false;
        }
        return true;
    }

    private <N extends Node> boolean nodesEquals(NodeList<N> n1, NodeList<N> n2) {
        if (n1 == n2) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        if (n1.size() != n2.size()) {
            return false;
        }
        for (int i = 0; i < n1.size(); ++i) {
            if (this.nodeEquals(n1.get(i), n2.get(i))) continue;
            return false;
        }
        return true;
    }

    private <T extends Node> boolean nodeEquals(T n1, T n2) {
        if (n1 == n2) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        if (n1.getClass() != n2.getClass()) {
            return false;
        }
        if (!this.commonNodeEquality(n1, n2)) {
            return false;
        }
        return n1.accept(this, n2);
    }

    private <T extends Node> boolean nodeEquals(Optional<T> n1, Optional<T> n2) {
        return this.nodeEquals((T)n1.orElse(null), (T)n2.orElse(null));
    }

    private <T extends Node> boolean nodesEquals(Optional<NodeList<T>> n1, Optional<NodeList<T>> n2) {
        return this.nodesEquals((NodeList<N>)n1.orElse(null), (NodeList<N>)n2.orElse(null));
    }

    private boolean objEquals(Object n1, Object n2) {
        if (n1 == n2) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        return n1.equals(n2);
    }

    @Override
    public Boolean visit(CompilationUnit n1, Visitable arg) {
        CompilationUnit n2 = (CompilationUnit)arg;
        if (!this.nodeEquals(n1.getPackageDeclaration(), n2.getPackageDeclaration())) {
            return false;
        }
        if (!this.nodesEquals(n1.getImports(), n2.getImports())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypes(), n2.getTypes())) {
            return false;
        }
        if (!this.nodesEquals(n1.getComments(), n2.getComments())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(PackageDeclaration n1, Visitable arg) {
        PackageDeclaration n2 = (PackageDeclaration)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(TypeParameter n1, Visitable arg) {
        TypeParameter n2 = (TypeParameter)arg;
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeBound(), n2.getTypeBound())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(LineComment n1, Visitable arg) {
        LineComment n2 = (LineComment)arg;
        if (!this.objEquals(n1.getContent(), n2.getContent())) {
            return false;
        }
        if (!this.objEquals(n1.getRange(), n2.getRange())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(BlockComment n1, Visitable arg) {
        BlockComment n2 = (BlockComment)arg;
        if (!this.objEquals(n1.getContent(), n2.getContent())) {
            return false;
        }
        if (!this.objEquals(n1.getRange(), n2.getRange())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ClassOrInterfaceDeclaration n1, Visitable arg) {
        ClassOrInterfaceDeclaration n2 = (ClassOrInterfaceDeclaration)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (n1.isInterface() != n2.isInterface()) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeParameters(), n2.getTypeParameters())) {
            return false;
        }
        if (!this.nodesEquals(n1.getExtendedTypes(), n2.getExtendedTypes())) {
            return false;
        }
        if (!this.nodesEquals(n1.getImplementedTypes(), n2.getImplementedTypes())) {
            return false;
        }
        if (!this.nodesEquals(n1.getMembers(), n2.getMembers())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(EnumDeclaration n1, Visitable arg) {
        EnumDeclaration n2 = (EnumDeclaration)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodesEquals(n1.getImplementedTypes(), n2.getImplementedTypes())) {
            return false;
        }
        if (!this.nodesEquals(n1.getEntries(), n2.getEntries())) {
            return false;
        }
        if (!this.nodesEquals(n1.getMembers(), n2.getMembers())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(EnumConstantDeclaration n1, Visitable arg) {
        EnumConstantDeclaration n2 = (EnumConstantDeclaration)arg;
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodesEquals(n1.getArguments(), n2.getArguments())) {
            return false;
        }
        if (!this.nodesEquals(n1.getClassBody(), n2.getClassBody())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(AnnotationDeclaration n1, Visitable arg) {
        AnnotationDeclaration n2 = (AnnotationDeclaration)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodesEquals(n1.getMembers(), n2.getMembers())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(AnnotationMemberDeclaration n1, Visitable arg) {
        AnnotationMemberDeclaration n2 = (AnnotationMemberDeclaration)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodeEquals(n1.getDefaultValue(), n2.getDefaultValue())) {
            return false;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(FieldDeclaration n1, Visitable arg) {
        FieldDeclaration n2 = (FieldDeclaration)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodesEquals(n1.getVariables(), n2.getVariables())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(VariableDeclarator n1, Visitable arg) {
        VariableDeclarator n2 = (VariableDeclarator)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        if (!this.nodeEquals(n1.getInitializer(), n2.getInitializer())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ConstructorDeclaration n1, Visitable arg) {
        ConstructorDeclaration n2 = (ConstructorDeclaration)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        if (!this.nodesEquals(n1.getParameters(), n2.getParameters())) {
            return false;
        }
        if (!this.nodesEquals(n1.getThrownExceptions(), n2.getThrownExceptions())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeParameters(), n2.getTypeParameters())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(MethodDeclaration n1, Visitable arg) {
        MethodDeclaration n2 = (MethodDeclaration)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        if (!this.nodesEquals(n1.getParameters(), n2.getParameters())) {
            return false;
        }
        if (!this.nodesEquals(n1.getThrownExceptions(), n2.getThrownExceptions())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeParameters(), n2.getTypeParameters())) {
            return false;
        }
        if (n1.isDefault() != n2.isDefault()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(Parameter n1, Visitable arg) {
        Parameter n2 = (Parameter)arg;
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(EmptyMemberDeclaration n1, Visitable arg) {
        return true;
    }

    @Override
    public Boolean visit(InitializerDeclaration n1, Visitable arg) {
        InitializerDeclaration n2 = (InitializerDeclaration)arg;
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(JavadocComment n1, Visitable arg) {
        JavadocComment n2 = (JavadocComment)arg;
        if (!this.objEquals(n1.getContent(), n2.getContent())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ClassOrInterfaceType n1, Visitable arg) {
        ClassOrInterfaceType n2 = (ClassOrInterfaceType)arg;
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodeEquals(n1.getScope(), n2.getScope())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeArguments(), n2.getTypeArguments())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(PrimitiveType n1, Visitable arg) {
        PrimitiveType n2 = (PrimitiveType)arg;
        if (n1.getType() != n2.getType()) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ArrayType n1, Visitable arg) {
        ArrayType n2 = (ArrayType)arg;
        if (!this.nodeEquals(n1.getComponentType(), n2.getComponentType())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ArrayCreationLevel n1, Visitable arg) {
        ArrayCreationLevel n2 = (ArrayCreationLevel)arg;
        if (!this.nodeEquals(n1.getDimension(), n2.getDimension())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(IntersectionType n1, Visitable arg) {
        IntersectionType n2 = (IntersectionType)arg;
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        NodeList<ReferenceType> n1Elements = n1.getElements();
        NodeList<ReferenceType> n2Elements = n2.getElements();
        if (n1Elements != null && n2Elements != null) {
            if (n1Elements.size() != n2Elements.size()) {
                return false;
            }
            int i = 0;
            for (ReferenceType aux : n1Elements) {
                if (aux.accept(this, n2Elements.get(i)).booleanValue()) {
                    return false;
                }
                ++i;
            }
        } else if (n1Elements != n2Elements) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(UnionType n1, Visitable arg) {
        UnionType n2 = (UnionType)arg;
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        NodeList<ReferenceType> n1Elements = n1.getElements();
        NodeList<ReferenceType> n2Elements = n2.getElements();
        if (n1Elements != null && n2Elements != null) {
            if (n1Elements.size() != n2Elements.size()) {
                return false;
            }
            int i = 0;
            for (ReferenceType aux : n1Elements) {
                if (aux.accept(this, n2Elements.get(i)).booleanValue()) {
                    return false;
                }
                ++i;
            }
        } else if (n1Elements != n2Elements) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(VoidType n1, Visitable arg) {
        VoidType n2 = (VoidType)arg;
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(WildcardType n1, Visitable arg) {
        WildcardType n2 = (WildcardType)arg;
        if (!this.nodeEquals(n1.getExtendedTypes(), n2.getExtendedTypes())) {
            return false;
        }
        if (!this.nodeEquals(n1.getSuperTypes(), n2.getSuperTypes())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(UnknownType n1, Visitable arg) {
        return true;
    }

    @Override
    public Boolean visit(ArrayAccessExpr n1, Visitable arg) {
        ArrayAccessExpr n2 = (ArrayAccessExpr)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodeEquals(n1.getIndex(), n2.getIndex())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ArrayCreationExpr n1, Visitable arg) {
        ArrayCreationExpr n2 = (ArrayCreationExpr)arg;
        if (!this.nodeEquals(n1.getElementType(), n2.getElementType())) {
            return false;
        }
        if (!this.nodesEquals(n1.getLevels(), n2.getLevels())) {
            return false;
        }
        if (!this.nodeEquals(n1.getInitializer(), n2.getInitializer())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ArrayInitializerExpr n1, Visitable arg) {
        ArrayInitializerExpr n2 = (ArrayInitializerExpr)arg;
        if (!this.nodesEquals(n1.getValues(), n2.getValues())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(AssignExpr n1, Visitable arg) {
        AssignExpr n2 = (AssignExpr)arg;
        if (n1.getOperator() != n2.getOperator()) {
            return false;
        }
        if (!this.nodeEquals(n1.getTarget(), n2.getTarget())) {
            return false;
        }
        if (!this.nodeEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(BinaryExpr n1, Visitable arg) {
        BinaryExpr n2 = (BinaryExpr)arg;
        if (n1.getOperator() != n2.getOperator()) {
            return false;
        }
        if (!this.nodeEquals(n1.getLeft(), n2.getLeft())) {
            return false;
        }
        if (!this.nodeEquals(n1.getRight(), n2.getRight())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(CastExpr n1, Visitable arg) {
        CastExpr n2 = (CastExpr)arg;
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        if (!this.nodeEquals(n1.getExpression(), n2.getExpression())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ClassExpr n1, Visitable arg) {
        ClassExpr n2 = (ClassExpr)arg;
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ConditionalExpr n1, Visitable arg) {
        ConditionalExpr n2 = (ConditionalExpr)arg;
        if (!this.nodeEquals(n1.getCondition(), n2.getCondition())) {
            return false;
        }
        if (!this.nodeEquals(n1.getThenExpr(), n2.getThenExpr())) {
            return false;
        }
        if (!this.nodeEquals(n1.getElseExpr(), n2.getElseExpr())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(EnclosedExpr n1, Visitable arg) {
        EnclosedExpr n2 = (EnclosedExpr)arg;
        if (!this.nodeEquals(n1.getInner(), n2.getInner())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(FieldAccessExpr n1, Visitable arg) {
        FieldAccessExpr n2 = (FieldAccessExpr)arg;
        if (!this.nodeEquals(n1.getScope(), n2.getScope())) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeArguments(), n2.getTypeArguments())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(InstanceOfExpr n1, Visitable arg) {
        InstanceOfExpr n2 = (InstanceOfExpr)arg;
        if (!this.nodeEquals(n1.getExpression(), n2.getExpression())) {
            return false;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(StringLiteralExpr n1, Visitable arg) {
        StringLiteralExpr n2 = (StringLiteralExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(IntegerLiteralExpr n1, Visitable arg) {
        IntegerLiteralExpr n2 = (IntegerLiteralExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(LongLiteralExpr n1, Visitable arg) {
        LongLiteralExpr n2 = (LongLiteralExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(CharLiteralExpr n1, Visitable arg) {
        CharLiteralExpr n2 = (CharLiteralExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(DoubleLiteralExpr n1, Visitable arg) {
        DoubleLiteralExpr n2 = (DoubleLiteralExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(BooleanLiteralExpr n1, Visitable arg) {
        BooleanLiteralExpr n2 = (BooleanLiteralExpr)arg;
        if (n1.getValue() != n2.getValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(NullLiteralExpr n1, Visitable arg) {
        return true;
    }

    @Override
    public Boolean visit(MethodCallExpr n1, Visitable arg) {
        MethodCallExpr n2 = (MethodCallExpr)arg;
        if (!this.nodeEquals(n1.getScope(), n2.getScope())) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getArguments(), n2.getArguments())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeArguments(), n2.getTypeArguments())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(NameExpr n1, Visitable arg) {
        NameExpr n2 = (NameExpr)arg;
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ObjectCreationExpr n1, Visitable arg) {
        ObjectCreationExpr n2 = (ObjectCreationExpr)arg;
        if (!this.nodeEquals(n1.getScope(), n2.getScope())) {
            return false;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnonymousClassBody(), n2.getAnonymousClassBody())) {
            return false;
        }
        if (!this.nodesEquals(n1.getArguments(), n2.getArguments())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeArguments(), n2.getTypeArguments())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(Name n1, Visitable arg) {
        Name n2 = (Name)arg;
        if (!this.nodeEquals(n1.getQualifier(), n2.getQualifier())) {
            return false;
        }
        if (!this.objEquals(n1.getIdentifier(), n2.getIdentifier())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(SimpleName n, Visitable arg) {
        SimpleName n2 = (SimpleName)arg;
        return this.objEquals(n.getIdentifier(), n2.getIdentifier());
    }

    @Override
    public Boolean visit(ThisExpr n1, Visitable arg) {
        ThisExpr n2 = (ThisExpr)arg;
        if (!this.nodeEquals(n1.getClassExpr(), n2.getClassExpr())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(SuperExpr n1, Visitable arg) {
        SuperExpr n2 = (SuperExpr)arg;
        if (!this.nodeEquals(n1.getClassExpr(), n2.getClassExpr())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(UnaryExpr n1, Visitable arg) {
        UnaryExpr n2 = (UnaryExpr)arg;
        if (n1.getOperator() != n2.getOperator()) {
            return false;
        }
        if (!this.nodeEquals(n1.getExpression(), n2.getExpression())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(VariableDeclarationExpr n1, Visitable arg) {
        VariableDeclarationExpr n2 = (VariableDeclarationExpr)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodesEquals(n1.getVariables(), n2.getVariables())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(MarkerAnnotationExpr n1, Visitable arg) {
        MarkerAnnotationExpr n2 = (MarkerAnnotationExpr)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(SingleMemberAnnotationExpr n1, Visitable arg) {
        SingleMemberAnnotationExpr n2 = (SingleMemberAnnotationExpr)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodeEquals(n1.getMemberValue(), n2.getMemberValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(NormalAnnotationExpr n1, Visitable arg) {
        NormalAnnotationExpr n2 = (NormalAnnotationExpr)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getPairs(), n2.getPairs())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(MemberValuePair n1, Visitable arg) {
        MemberValuePair n2 = (MemberValuePair)arg;
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodeEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ExplicitConstructorInvocationStmt n1, Visitable arg) {
        ExplicitConstructorInvocationStmt n2 = (ExplicitConstructorInvocationStmt)arg;
        if (!this.nodeEquals(n1.getExpression(), n2.getExpression())) {
            return false;
        }
        if (!this.nodesEquals(n1.getArguments(), n2.getArguments())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeArguments(), n2.getTypeArguments())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(LocalClassDeclarationStmt n1, Visitable arg) {
        LocalClassDeclarationStmt n2 = (LocalClassDeclarationStmt)arg;
        if (!this.nodeEquals(n1.getClassDeclaration(), n2.getClassDeclaration())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(AssertStmt n1, Visitable arg) {
        AssertStmt n2 = (AssertStmt)arg;
        if (!this.nodeEquals(n1.getCheck(), n2.getCheck())) {
            return false;
        }
        if (!this.nodeEquals(n1.getMessage(), n2.getMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(BlockStmt n1, Visitable arg) {
        BlockStmt n2 = (BlockStmt)arg;
        if (!this.nodesEquals(n1.getStatements(), n2.getStatements())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(LabeledStmt n1, Visitable arg) {
        LabeledStmt n2 = (LabeledStmt)arg;
        if (!this.nodeEquals(n1.getStatement(), n2.getStatement())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(EmptyStmt n1, Visitable arg) {
        return true;
    }

    @Override
    public Boolean visit(ExpressionStmt n1, Visitable arg) {
        ExpressionStmt n2 = (ExpressionStmt)arg;
        if (!this.nodeEquals(n1.getExpression(), n2.getExpression())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(SwitchStmt n1, Visitable arg) {
        SwitchStmt n2 = (SwitchStmt)arg;
        if (!this.nodeEquals(n1.getSelector(), n2.getSelector())) {
            return false;
        }
        if (!this.nodesEquals(n1.getEntries(), n2.getEntries())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(SwitchEntryStmt n1, Visitable arg) {
        SwitchEntryStmt n2 = (SwitchEntryStmt)arg;
        if (!this.nodeEquals(n1.getLabel(), n2.getLabel())) {
            return false;
        }
        if (!this.nodesEquals(n1.getStatements(), n2.getStatements())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(BreakStmt n1, Visitable arg) {
        BreakStmt n2 = (BreakStmt)arg;
        if (!this.nodeEquals(n1.getLabel(), n2.getLabel())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ReturnStmt n1, Visitable arg) {
        ReturnStmt n2 = (ReturnStmt)arg;
        if (!this.nodeEquals(n1.getExpression(), n2.getExpression())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(IfStmt n1, Visitable arg) {
        IfStmt n2 = (IfStmt)arg;
        if (!this.nodeEquals(n1.getCondition(), n2.getCondition())) {
            return false;
        }
        if (!this.nodeEquals(n1.getThenStmt(), n2.getThenStmt())) {
            return false;
        }
        if (!this.nodeEquals(n1.getElseStmt(), n2.getElseStmt())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(WhileStmt n1, Visitable arg) {
        WhileStmt n2 = (WhileStmt)arg;
        if (!this.nodeEquals(n1.getCondition(), n2.getCondition())) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ContinueStmt n1, Visitable arg) {
        ContinueStmt n2 = (ContinueStmt)arg;
        if (!this.nodeEquals(n1.getLabel(), n2.getLabel())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(DoStmt n1, Visitable arg) {
        DoStmt n2 = (DoStmt)arg;
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        if (!this.nodeEquals(n1.getCondition(), n2.getCondition())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ForeachStmt n1, Visitable arg) {
        ForeachStmt n2 = (ForeachStmt)arg;
        if (!this.nodeEquals(n1.getVariable(), n2.getVariable())) {
            return false;
        }
        if (!this.nodeEquals(n1.getIterable(), n2.getIterable())) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ForStmt n1, Visitable arg) {
        ForStmt n2 = (ForStmt)arg;
        if (!this.nodesEquals(n1.getInitialization(), n2.getInitialization())) {
            return false;
        }
        if (!this.nodeEquals(n1.getCompare(), n2.getCompare())) {
            return false;
        }
        if (!this.nodesEquals(n1.getUpdate(), n2.getUpdate())) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ThrowStmt n1, Visitable arg) {
        ThrowStmt n2 = (ThrowStmt)arg;
        if (!this.nodeEquals(n1.getExpression(), n2.getExpression())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(SynchronizedStmt n1, Visitable arg) {
        SynchronizedStmt n2 = (SynchronizedStmt)arg;
        if (!this.nodeEquals(n1.getExpression(), n2.getExpression())) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(TryStmt n1, Visitable arg) {
        TryStmt n2 = (TryStmt)arg;
        if (!this.nodeEquals(n1.getTryBlock(), n2.getTryBlock())) {
            return false;
        }
        if (!this.nodesEquals(n1.getCatchClauses(), n2.getCatchClauses())) {
            return false;
        }
        if (!this.nodesEquals(n1.getResources(), n2.getResources())) {
            return false;
        }
        if (!this.nodeEquals(n1.getFinallyBlock(), n2.getFinallyBlock())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(CatchClause n1, Visitable arg) {
        CatchClause n2 = (CatchClause)arg;
        if (!this.nodeEquals(n1.getParameter(), n2.getParameter())) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(LambdaExpr n1, Visitable arg) {
        LambdaExpr n2 = (LambdaExpr)arg;
        if (!this.nodesEquals(n1.getParameters(), n2.getParameters())) {
            return false;
        }
        if (n1.isEnclosingParameters() != n2.isEnclosingParameters()) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(MethodReferenceExpr n1, Visitable arg) {
        MethodReferenceExpr n2 = (MethodReferenceExpr)arg;
        if (!this.nodeEquals(n1.getScope(), n2.getScope())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeArguments(), n2.getTypeArguments())) {
            return false;
        }
        if (!this.objEquals(n1.getIdentifier(), n2.getIdentifier())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(TypeExpr n, Visitable arg) {
        TypeExpr n2 = (TypeExpr)arg;
        if (!this.nodeEquals(n.getType(), n2.getType())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ImportDeclaration n1, Visitable arg) {
        ImportDeclaration n2 = (ImportDeclaration)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (n1.isAsterisk() != n2.isAsterisk()) {
            return false;
        }
        if (n1.isStatic() != n2.isStatic()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(NodeList n, Visitable arg) {
        return this.nodesEquals(n, (NodeList)arg);
    }
}

