/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast;

import com.github.javaparser.JavaParser;
import com.github.javaparser.Range;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.ClassUtils;
import com.github.javaparser.utils.Utils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class CompilationUnit
extends Node {
    private PackageDeclaration packageDeclaration;
    private NodeList<ImportDeclaration> imports;
    private NodeList<TypeDeclaration<?>> types;

    public CompilationUnit() {
        this(null, null, new NodeList<ImportDeclaration>(), new NodeList());
    }

    public CompilationUnit(PackageDeclaration packageDeclaration, NodeList<ImportDeclaration> imports, NodeList<TypeDeclaration<?>> types) {
        this(null, packageDeclaration, imports, types);
    }

    public CompilationUnit(Range range, PackageDeclaration packageDeclaration, NodeList<ImportDeclaration> imports, NodeList<TypeDeclaration<?>> types) {
        super(range);
        this.setPackageDeclaration(packageDeclaration);
        this.setImports(imports);
        this.setTypes(types);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public List<Comment> getComments() {
        return this.getAllContainedComments();
    }

    public NodeList<ImportDeclaration> getImports() {
        return this.imports;
    }

    public ImportDeclaration getImport(int i) {
        return (ImportDeclaration)this.getImports().get(i);
    }

    public Optional<PackageDeclaration> getPackageDeclaration() {
        return Optional.ofNullable(this.packageDeclaration);
    }

    public NodeList<TypeDeclaration<?>> getTypes() {
        return this.types;
    }

    public TypeDeclaration<?> getType(int i) {
        return (TypeDeclaration)this.getTypes().get(i);
    }

    public CompilationUnit setImports(NodeList<ImportDeclaration> imports) {
        this.notifyPropertyChange(ObservableProperty.IMPORTS, this.imports, imports);
        this.imports = Utils.assertNotNull(imports);
        this.setAsParentNodeOf(this.imports);
        return this;
    }

    public CompilationUnit setImport(int i, ImportDeclaration imports) {
        this.getImports().set(i, imports);
        return this;
    }

    public CompilationUnit addImport(ImportDeclaration imports) {
        this.getImports().add(imports);
        return this;
    }

    public CompilationUnit setPackageDeclaration(PackageDeclaration pakage) {
        this.notifyPropertyChange(ObservableProperty.PACKAGE_DECLARATION, this.packageDeclaration, pakage);
        this.packageDeclaration = pakage;
        this.setAsParentNodeOf(this.packageDeclaration);
        return this;
    }

    public CompilationUnit setTypes(NodeList<TypeDeclaration<?>> types) {
        this.notifyPropertyChange(ObservableProperty.TYPES, this.types, types);
        this.types = Utils.assertNotNull(types);
        this.setAsParentNodeOf(this.types);
        return this;
    }

    public CompilationUnit setType(int i, TypeDeclaration<?> type) {
        NodeList copy = new NodeList();
        copy.addAll(this.getTypes());
        this.getTypes().set(i, type);
        this.notifyPropertyChange(ObservableProperty.TYPES, copy, this.types);
        return this;
    }

    public CompilationUnit addType(TypeDeclaration<?> type) {
        NodeList copy = new NodeList();
        copy.addAll(this.getTypes());
        this.getTypes().add(type);
        this.notifyPropertyChange(ObservableProperty.TYPES, copy, this.types);
        return this;
    }

    public CompilationUnit setPackageName(String name) {
        this.setPackageDeclaration(new PackageDeclaration(Name.parse(name)));
        return this;
    }

    public CompilationUnit addImport(String name) {
        return this.addImport(name, false, false);
    }

    public CompilationUnit addImport(Class<?> clazz) {
        if (ClassUtils.isPrimitiveOrWrapper(clazz) || clazz.getName().startsWith("java.lang")) {
            return this;
        }
        if (clazz.isArray() && !ClassUtils.isPrimitiveOrWrapper(clazz.getComponentType()) && !clazz.getComponentType().getName().startsWith("java.lang")) {
            return this.addImport(clazz.getComponentType().getName());
        }
        return this.addImport(clazz.getName());
    }

    public CompilationUnit addImport(String name, boolean isStatic, boolean isAsterisk) {
        StringBuilder i = new StringBuilder("import ");
        if (isStatic) {
            i.append("static ");
        }
        i.append(name);
        if (isAsterisk) {
            i.append(".*");
        }
        i.append(";");
        ImportDeclaration importDeclaration = JavaParser.parseImport(i.toString());
        if (this.getImports().stream().anyMatch(im -> im.toString().equals(importDeclaration.toString()))) {
            return this;
        }
        this.getImports().add(importDeclaration);
        importDeclaration.setParentNode(this);
        return this;
    }

    public ClassOrInterfaceDeclaration addClass(String name) {
        return this.addClass(name, Modifier.PUBLIC);
    }

    public ClassOrInterfaceDeclaration addClass(String name, Modifier ... modifiers) {
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = new ClassOrInterfaceDeclaration(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))), false, name);
        this.getTypes().add(classOrInterfaceDeclaration);
        classOrInterfaceDeclaration.setParentNode(this);
        return classOrInterfaceDeclaration;
    }

    public ClassOrInterfaceDeclaration addInterface(String name) {
        return this.addInterface(name, Modifier.PUBLIC);
    }

    public ClassOrInterfaceDeclaration addInterface(String name, Modifier ... modifiers) {
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = new ClassOrInterfaceDeclaration(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))), true, name);
        this.getTypes().add(classOrInterfaceDeclaration);
        classOrInterfaceDeclaration.setParentNode(this);
        return classOrInterfaceDeclaration;
    }

    public EnumDeclaration addEnum(String name) {
        return this.addEnum(name, Modifier.PUBLIC);
    }

    public EnumDeclaration addEnum(String name, Modifier ... modifiers) {
        EnumDeclaration enumDeclaration = new EnumDeclaration(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))), name);
        this.getTypes().add(enumDeclaration);
        enumDeclaration.setParentNode(this);
        return enumDeclaration;
    }

    public AnnotationDeclaration addAnnotationDeclaration(String name) {
        return this.addAnnotationDeclaration(name, Modifier.PUBLIC);
    }

    public AnnotationDeclaration addAnnotationDeclaration(String name, Modifier ... modifiers) {
        AnnotationDeclaration annotationDeclaration = new AnnotationDeclaration(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))), name);
        this.getTypes().add(annotationDeclaration);
        annotationDeclaration.setParentNode(this);
        return annotationDeclaration;
    }

    public Optional<ClassOrInterfaceDeclaration> getClassByName(String className) {
        return this.getTypes().stream().filter(type -> type.getNameAsString().equals(className) && type instanceof ClassOrInterfaceDeclaration && !((ClassOrInterfaceDeclaration)type).isInterface()).findFirst().map(t -> (ClassOrInterfaceDeclaration)t);
    }

    public Optional<ClassOrInterfaceDeclaration> getInterfaceByName(String interfaceName) {
        return this.getTypes().stream().filter(type -> type.getNameAsString().equals(interfaceName) && type instanceof ClassOrInterfaceDeclaration && ((ClassOrInterfaceDeclaration)type).isInterface()).findFirst().map(t -> (ClassOrInterfaceDeclaration)t);
    }

    public Optional<EnumDeclaration> getEnumByName(String enumName) {
        return this.getTypes().stream().filter(type -> type.getNameAsString().equals(enumName) && type instanceof EnumDeclaration).findFirst().map(t -> (EnumDeclaration)t);
    }

    public Optional<AnnotationDeclaration> getAnnotationDeclarationByName(String annotationName) {
        return this.getTypes().stream().filter(type -> type.getNameAsString().equals(annotationName) && type instanceof AnnotationDeclaration).findFirst().map(t -> (AnnotationDeclaration)t);
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        return Arrays.asList(this.imports, this.types);
    }

    public CompilationUnit setPackageDeclaration(String s) {
        return this.setPackageDeclaration(new PackageDeclaration(Name.parse(Utils.assertNotNull(s))));
    }
}

