/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.github.javaparser.javadoc.description.JavadocDescription;
import com.github.javaparser.utils.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class JavadocParser {
    JavadocParser() {
    }

    public static Javadoc parse(JavadocComment comment) {
        return JavadocParser.parse(comment.getContent());
    }

    public static Javadoc parse(String commentContent) {
        List<String> cleanLines = JavadocParser.cleanLines(commentContent);
        int index = -1;
        for (int i = 0; i < cleanLines.size() && index == -1; ++i) {
            if (!JavadocParser.isABlockLine(cleanLines.get(i))) continue;
            index = i;
        }
        List<Object> blockLines = null;
        String descriptionText = null;
        if (index == -1) {
            descriptionText = JavadocParser.trimRight(String.join((CharSequence)"\n", cleanLines));
            blockLines = Collections.emptyList();
        } else {
            descriptionText = JavadocParser.trimRight(String.join((CharSequence)"\n", cleanLines.subList(0, index)));
            blockLines = cleanLines.subList(index, cleanLines.size());
        }
        Javadoc document = new Javadoc(JavadocDescription.parseText(descriptionText));
        blockLines.forEach(l -> document.addBlockTag(JavadocParser.parseBlockTag(l)));
        return document;
    }

    private static JavadocBlockTag parseBlockTag(String line) {
        line = line.trim().substring(1);
        String tagName = Utils.nextWord(line);
        String rest = line.substring(tagName.length()).trim();
        return new JavadocBlockTag(tagName, rest);
    }

    private static boolean isABlockLine(String line) {
        return line.trim().startsWith("@");
    }

    private static String trimRight(String string) {
        while (!string.isEmpty() && Character.isWhitespace(string.charAt(string.length() - 1))) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static JavadocDescription parseText(String content) {
        return JavadocDescription.parseText(content);
    }

    private static List<String> cleanLines(String content) {
        String[] lines = content.split("\n");
        List<String> cleanedLines = Arrays.stream(lines).map(l -> {
            char c;
            int asteriskIndex = JavadocParser.startsWithAsterisk(l);
            if (asteriskIndex == -1) {
                return l;
            }
            if (l.length() > asteriskIndex + 1 && ((c = l.charAt(asteriskIndex + 1)) == ' ' || c == '\t')) {
                return l.substring(asteriskIndex + 2);
            }
            return l.substring(asteriskIndex + 1);
        }).collect(Collectors.toList());
        if (!(((String)(cleanedLines = cleanedLines.stream().map(l -> l.trim().isEmpty() ? "" : l).collect(Collectors.toList())).get(0)).isEmpty() || ((String)cleanedLines.get(0)).charAt(0) != ' ' && cleanedLines.get(0).charAt(0) != '\t')) {
            cleanedLines.set(0, cleanedLines.get(0).substring(1));
        }
        while (cleanedLines.size() > 0 && ((String)cleanedLines.get(0)).trim().isEmpty()) {
            cleanedLines = cleanedLines.subList(1, cleanedLines.size());
        }
        while (cleanedLines.size() > 0 && cleanedLines.get(cleanedLines.size() - 1).trim().isEmpty()) {
            cleanedLines = cleanedLines.subList(0, cleanedLines.size() - 1);
        }
        return cleanedLines;
    }

    static int startsWithAsterisk(String line) {
        if (line.startsWith("*")) {
            return 0;
        }
        if ((line.startsWith(" ") || line.startsWith("\t")) && line.length() > 1) {
            int res = JavadocParser.startsWithAsterisk(line.substring(1));
            if (res == -1) {
                return -1;
            }
            return 1 + res;
        }
        return -1;
    }
}

