/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.stmt;

import com.github.javaparser.Range;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public final class TryStmt
extends Statement {
    private NodeList<VariableDeclarationExpr> resources;
    private BlockStmt tryBlock;
    private NodeList<CatchClause> catchClauses;
    private BlockStmt finallyBlock;

    public TryStmt() {
        this(null, new NodeList<VariableDeclarationExpr>(), new BlockStmt(), new NodeList<CatchClause>(), null);
    }

    public TryStmt(BlockStmt tryBlock, NodeList<CatchClause> catchClauses, BlockStmt finallyBlock) {
        this(null, new NodeList<VariableDeclarationExpr>(), tryBlock, catchClauses, finallyBlock);
    }

    public TryStmt(Range range, NodeList<VariableDeclarationExpr> resources, BlockStmt tryBlock, NodeList<CatchClause> catchClauses, BlockStmt finallyBlock) {
        super(range);
        this.setResources(resources);
        this.setTryBlock(tryBlock);
        this.setCatchClauses(catchClauses);
        this.setFinallyBlock(finallyBlock);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public NodeList<CatchClause> getCatchClauses() {
        return this.catchClauses;
    }

    public Optional<BlockStmt> getFinallyBlock() {
        return Optional.ofNullable(this.finallyBlock);
    }

    public Optional<BlockStmt> getTryBlock() {
        return Optional.ofNullable(this.tryBlock);
    }

    public NodeList<VariableDeclarationExpr> getResources() {
        return this.resources;
    }

    public TryStmt setCatchClauses(NodeList<CatchClause> catchClauses) {
        this.notifyPropertyChange(ObservableProperty.CATCH_CLAUSES, this.catchClauses, catchClauses);
        this.catchClauses = Utils.assertNotNull(catchClauses);
        this.setAsParentNodeOf(this.catchClauses);
        return this;
    }

    public TryStmt setFinallyBlock(BlockStmt finallyBlock) {
        this.notifyPropertyChange(ObservableProperty.FINALLY_BLOCK, this.finallyBlock, finallyBlock);
        this.finallyBlock = finallyBlock;
        this.setAsParentNodeOf(this.finallyBlock);
        return this;
    }

    public TryStmt setTryBlock(BlockStmt tryBlock) {
        this.notifyPropertyChange(ObservableProperty.TRY_BLOCK, this.tryBlock, tryBlock);
        this.tryBlock = tryBlock;
        this.setAsParentNodeOf(this.tryBlock);
        return this;
    }

    public TryStmt setResources(NodeList<VariableDeclarationExpr> resources) {
        this.notifyPropertyChange(ObservableProperty.RESOURCES, this.resources, resources);
        this.resources = Utils.assertNotNull(resources);
        this.setAsParentNodeOf(this.resources);
        return this;
    }
}

