/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;

public final class AssignExpr
extends Expression {
    private Expression target;
    private Expression value;
    private Operator op;

    public AssignExpr() {
        this(Range.UNKNOWN, new NameExpr(), new StringLiteralExpr(), Operator.assign);
    }

    public AssignExpr(Expression target, Expression value, Operator op) {
        this(Range.UNKNOWN, target, value, op);
    }

    public AssignExpr(Range range, Expression target, Expression value, Operator op) {
        super(range);
        this.setTarget(target);
        this.setValue(value);
        this.setOperator(op);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Operator getOperator() {
        return this.op;
    }

    public Expression getTarget() {
        return this.target;
    }

    public Expression getValue() {
        return this.value;
    }

    public AssignExpr setOperator(Operator op) {
        this.op = op;
        return this;
    }

    public AssignExpr setTarget(Expression target) {
        this.notifyPropertyChange(ObservableProperty.TARGET, this.target, target);
        this.target = target;
        this.setAsParentNodeOf(this.target);
        return this;
    }

    public AssignExpr setValue(Expression value) {
        this.notifyPropertyChange(ObservableProperty.VALUE, this.value, value);
        this.value = value;
        this.setAsParentNodeOf(this.value);
        return this;
    }

    public static enum Operator {
        assign,
        plus,
        minus,
        star,
        slash,
        and,
        or,
        xor,
        rem,
        lShift,
        rSignedShift,
        rUnsignedShift;

    }
}

